/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.watchverticallive.present;

import android.app.Activity;
import android.content.Context;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import androidx.fragment.app.FragmentActivity;
import com.alibaba.fastjson.JSON;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.VhSdk;
import com.vhall.appui.baselib.bean.GoodsAuctionInfo;
import com.vhall.appui.baselib.config.VhallComponentConfig;
import com.vhall.appui.baselib.network.CommonManagerNetWrapper;
import com.vhall.appui.baselib.service.auction.AuctionManager;
import com.vhall.appui.baselib.service.broadcast.IChatContract;
import com.vhall.appui.baselib.service.coupon.CouponManager;
import com.vhall.appui.baselib.service.document.IDocumentContract;
import com.vhall.appui.baselib.service.exam.ExamManager;
import com.vhall.appui.baselib.service.like.LikeManager;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.service.question.QuestionConstantsInternal;
import com.vhall.appui.baselib.service.question.QuestionManager;
import com.vhall.appui.baselib.service.questionanswer.QuestionAnswerManager;
import com.vhall.appui.baselib.service.sensitivewords.SensitiveWordsManager;
import com.vhall.appui.baselib.service.sign.SignManager;
import com.vhall.appui.baselib.service.vote.VoteConstantsInternal;
import com.vhall.appui.baselib.service.vote.VoteManager;
import com.vhall.appui.baselib.utils.DialogUtils;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.utils.JsonParseUtil;
import com.vhall.appui.baselib.utils.LogUtils;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.VssSdk;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.data.ResponseImMessageInfo;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.data.ResponseScrollingInfo;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.data.VssMessageQuestionnaireData;
import com.vhall.appui.baselib.vss.data.VssMessageSignData;
import com.vhall.appui.baselib.vss.data.VssQuestionListData;
import com.vhall.appui.baselib.vss.module.question.VssQuestionManager;
import com.vhall.appui.baselib.vss.module.room.ProxyVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import com.vhall.appui.baselib.vss.module.rtc.IVssRtcListener;
import com.vhall.appui.baselib.vss.module.rtc.VssRtcManager;
import com.vhall.appui.baselib.vss.utils.handler.WeakHandler;
import com.vhall.appui.baselib.webview.VhallWebManager;
import com.vhall.appui.baselib.webview.VhallWebviewActivity;
import com.vhall.appui.loginview.UserManager;
import com.vhall.appui.watchverticallive.network.WatchLiveNetWrapper;
import com.vhall.appui.watchverticallive.network.bean.ResponsePushGoodsScreenBean;
import com.vhall.appui.watchverticallive.present.IWatchLiveGroupContract;
import com.vhall.document.DocumentView;
import com.vhall.lss.play.VHLivePlayer;
import com.vhall.ops.VHOPS;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import com.vhall.vhallrtc.client.Room;
import com.vhall.vhallrtc.client.Stream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class WatchLiveGroupPresenter
implements IWatchLiveGroupContract.IWatchPresenter,
IChatContract.IChatPresenter,
IDocumentContract.IDocumentPresent {
    private static final String TAG = "WatchLiveGroupPresenter";
    private IWatchLiveGroupContract.IWatchLiveView watchLiveView;
    private IDocumentContract.IDocumentView documentView;
    private IChatContract.IChatView chatView;
    private Context context;
    private FragmentActivity fragmentActivity;
    private boolean isWatching = false;
    private static final int CAMERA_VIDEO = 2;
    private static final int CAMERA_AUDIO = 1;
    private static final int CAMERA_DEVICE_OPEN = 1;
    private static final int CAMERA_DEVICE_CLOSE = 0;
    private Stream localStream;
    private ResponseRoomInfo roomInfo;
    private VHLivePlayer mPlayer;
    private String canSpeak = "0";
    private boolean isUpMic = false;
    private VHOPS mDocument;
    private DocumentView mDocumentView;
    private boolean mVideoOpen;
    private boolean mAudioOpen;
    private ProxyVssMessageListener listener;
    private long delayTime = 0L;
    private AudioManager audioManager;
    private CountDownTimer countDownTimer = new CountDownTimer(1000L, 3000L){

        public void onTick(long millisUntilFinished) {
            WatchLiveGroupPresenter.this.watchLiveView.showProgress();
        }

        public void onFinish() {
            WatchLiveGroupPresenter.this.watchLiveView.hideProgress();
        }
    };
    private VHOPS.EventListener opsCallback = new VHOPS.EventListener(){

        public void onEvent(String event, String type, String cid) {
            if (WatchLiveGroupPresenter.this.documentView == null || WatchLiveGroupPresenter.this.mDocument == null) {
                return;
            }
            if (event.equals(VHOPS.KEY_OPERATE)) {
                if (type.equals(VHOPS.TYPE_ACTIVE)) {
                    WatchLiveGroupPresenter.this.mDocumentView = WatchLiveGroupPresenter.this.mDocument.getActiveView();
                    WatchLiveGroupPresenter.this.documentView.setDocView(WatchLiveGroupPresenter.this.mDocument.getActiveView());
                } else if (type.equals(VHOPS.TYPE_SWITCHOFF)) {
                    WatchLiveGroupPresenter.this.documentView.hideDoc();
                } else if (type.equals(VHOPS.TYPE_SWITCHON)) {
                    WatchLiveGroupPresenter.this.documentView.showDoc();
                }
            }
        }

        public void onError(int errorCode, int innerError, String errorMsg) {
            if (WatchLiveGroupPresenter.this.documentView == null || WatchLiveGroupPresenter.this.mDocument == null) {
                return;
            }
            WatchLiveGroupPresenter.this.watchLiveView.showToast(errorMsg);
        }
    };

    public WatchLiveGroupPresenter(FragmentActivity activity, IWatchLiveGroupContract.IWatchLiveView liveView, IChatContract.IChatView chatView, IDocumentContract.IDocumentView documentView, final ResponseRoomInfo roomInfo) {
        try {
            this.watchLiveView = liveView;
            this.fragmentActivity = activity;
            this.documentView = documentView;
            this.watchLiveView.setPresenter(this);
            this.roomInfo = roomInfo;
            this.context = liveView.getContext();
            this.chatView = chatView;
            if (chatView == null) {
                this.watchLiveView.showChat(8);
            } else {
                this.chatView.setPresenter(this);
                this.watchLiveView.showChat(0);
            }
            if (documentView != null) {
                documentView.setPresenter(this);
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        WatchLiveGroupPresenter.this.mDocument = new VHOPS(WatchLiveGroupPresenter.this.context, roomInfo.getChannel_id(), roomInfo.getRoom_id(), roomInfo.getPaas_access_token());
                        WatchLiveGroupPresenter.this.mDocument.setListener(WatchLiveGroupPresenter.this.opsCallback);
                        WatchLiveGroupPresenter.this.mDocument.join();
                    }
                });
            }
            if (roomInfo.getSign_life_time() > 0 && !TextUtils.isEmpty((CharSequence)roomInfo.getSign_id())) {
                DialogUtils.showUserSignDialog(this.context, roomInfo.getSign_id(), roomInfo.getSign_life_time());
            }
            this.canSpeak = roomInfo.getIs_banned();
            VhallComponentConfig.share().addVal("can_speak", this.canSpeak);
            this.listener = new ProxyVssMessageListener(new MyRoomListener());
            VssRoomManager.getInstance().setVssMessageListener(this.listener);
            SensitiveWordsManager.getInstance().requestSensitiveWords();
        }
        catch (Exception e) {
            VhLog.d(e.getMessage());
        }
    }

    @Override
    public void initLive() {
        if (this.roomInfo == null) {
            this.watchLiveView.showToast(M.getString(R.string.watch_vertical_room_init_error));
        }
        this.initPlay();
    }

    @Override
    public void initPlay() {
        this.watchLiveView.showProgress();
        this.getPlayer();
        this.play();
        VssRoomManager.getInstance().getScrollingInfo(new CallBack<ResponseScrollingInfo>(){

            @Override
            public void onSuccess(ResponseScrollingInfo result) {
                if (result != null) {
                    WatchLiveGroupPresenter.this.watchLiveView.setMarquee(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }

    public void setDocDelayTime(long delayTime) {
        this.delayTime = delayTime;
        if (this.mPlayer != null) {
            delayTime = (long)this.mPlayer.getRealityBufferTime() + delayTime;
        }
        if (this.mDocument != null) {
            this.mDocument.setDealTime((int)delayTime);
        }
    }

    @Override
    public void play() {
        if (!this.isWatching) {
            if (this.getPlayer().resumeAble()) {
                this.getPlayer().resume();
            } else {
                this.getPlayer().start(this.roomInfo.getRoom_id(), this.roomInfo.getPaas_access_token());
            }
        }
    }

    @Override
    public void releasePlay() {
        this.isWatching = false;
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        this.mPlayer = null;
    }

    private VHLivePlayer getPlayer() {
        if (this.mPlayer == null) {
            VHVideoPlayerView mVideoPlayer = this.watchLiveView.getPlay();
            mVideoPlayer.setDrawMode(1);
            this.mPlayer = new VHLivePlayer.Builder().videoPlayer((IVHVideoPlayer)mVideoPlayer).listener((VHPlayerListener)new MyPlayListener()).build();
            this.mPlayer.setDrawMode(2);
        }
        return this.mPlayer;
    }

    @Override
    public void onDownHand() {
        if (this.isUpMic) {
            this.localStream = null;
            VssRtcManager.leaveRoom();
            this.isUpMic = false;
        } else {
            VssRtcManager.getInstance(this.context).cancelApply(new CallBack(){

                public void onSuccess(Object result) {
                    WatchLiveGroupPresenter.this.watchLiveView.cancelUpHand();
                }

                @Override
                public void onError(int eventCode, String msg) {
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_cancel_hands_error_format, msg));
                }
            });
        }
    }

    @Override
    public void onUpHand() {
        WatchLiveNetWrapper.apply(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                WatchLiveGroupPresenter.this.watchLiveView.hand();
            }

            @Override
            public void onError(int eventCode, String msg) {
                WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_hands_error_format, msg));
                WatchLiveGroupPresenter.this.watchLiveView.cancelUpHand();
            }
        });
    }

    private void onUpMic() {
        VssRtcManager.getInstance(this.context).setRtvListener(new RtcListener());
        VssRtcManager.getInstance(this.context).speak(null, new CallBack(){

            public void onSuccess(Object o) {
                WatchLiveGroupPresenter.this.localStream = VssRtcManager.getLocalStream();
                WatchLiveGroupPresenter.this.releasePlay();
                WatchLiveGroupPresenter.this.watchLiveView.successUpHand();
                WatchLiveGroupPresenter.this.watchLiveView.addStream(WatchLiveGroupPresenter.this.localStream);
                WatchLiveGroupPresenter.this.setSpeakerphoneOn(true);
                WatchLiveGroupPresenter.this.isUpMic = true;
            }

            @Override
            public void onError(int eventCode, String msg) {
                WatchLiveGroupPresenter.this.watchLiveView.showToast(msg);
                VssRtcManager.leaveRoom();
                WatchLiveGroupPresenter.this.watchLiveView.hideProgress();
            }
        });
    }

    @Override
    public void onSwitchCamera() {
        if (this.localStream != null) {
            this.localStream.switchCamera();
        }
    }

    private void setSpeakerphoneOn(boolean on) {
        if (this.audioManager == null) {
            this.audioManager = (AudioManager)this.context.getSystemService("audio");
        }
        this.audioManager.setMode(3);
        this.audioManager.setSpeakerphoneOn(on);
    }

    @Override
    public void onSwitchVideo(final boolean isOpen) {
        if (this.localStream == null) {
            return;
        }
        VssRtcManager.getInstance(this.context).setDeviceStatus(String.valueOf(2), isOpen ? String.valueOf(1) : String.valueOf(0), new CallBack(){

            public void onSuccess(Object result) {
                WatchLiveGroupPresenter.this.mVideoOpen = true;
            }

            @Override
            public void onError(int eventCode, String msg) {
                WatchLiveGroupPresenter.this.watchLiveView.showToast(msg);
                WatchLiveGroupPresenter.this.watchLiveView.updateVideoFrame(!isOpen);
            }
        });
    }

    @Override
    public void onSwitchAudio(final boolean isOpen) {
        if (this.localStream == null) {
            return;
        }
        VssRtcManager.getInstance(this.context).setDeviceStatus(String.valueOf(1), isOpen ? String.valueOf(1) : String.valueOf(0), new CallBack(){

            public void onSuccess(Object result) {
                WatchLiveGroupPresenter.this.mAudioOpen = true;
            }

            @Override
            public void onError(int eventCode, String msg) {
                WatchLiveGroupPresenter.this.watchLiveView.showToast(msg);
                WatchLiveGroupPresenter.this.watchLiveView.updateAudioFrame(!isOpen);
            }
        });
    }

    @Override
    public void getQuestionnaireList() {
        VssQuestionManager.getInstance().questionList(new CallBack<VssQuestionListData>(){

            @Override
            public void onSuccess(VssQuestionListData result) {
                WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_quest_list_is_empty));
            }

            @Override
            public void onError(int eventCode, String msg) {
                WatchLiveGroupPresenter.this.watchLiveView.showToast(msg);
            }
        });
    }

    @Override
    public void agreeUpHandInvited() {
        VssRtcManager.getInstance(this.context).agreeInvite(new CallBack(){

            public void onSuccess(Object result) {
                WatchLiveGroupPresenter.this.onUpMic();
            }

            @Override
            public void onError(int eventCode, String msg) {
                WatchLiveGroupPresenter.this.watchLiveView.showToast(msg);
            }
        });
    }

    @Override
    public void disAgreeUpHandInvited() {
        VssRtcManager.getInstance(this.context).rejectInvite(new CallBack(){

            public void onSuccess(Object result) {
            }

            @Override
            public void onError(int eventCode, String msg) {
                WatchLiveGroupPresenter.this.watchLiveView.showToast(msg);
            }
        });
    }

    private void switchVideoFrame(int status) {
        if (this.localStream == null) {
            return;
        }
        if (status == 1) {
            this.localStream.unmuteVideo(null);
            this.watchLiveView.updateVideoFrame(true);
        } else {
            this.localStream.muteVideo(null);
            this.watchLiveView.updateVideoFrame(false);
        }
    }

    private void switchAudioFrame(int status) {
        if (this.localStream == null) {
            return;
        }
        if (status == 1) {
            this.localStream.unmuteAudio(null);
            this.watchLiveView.updateAudioFrame(true);
        } else {
            this.localStream.muteAudio(null);
            this.watchLiveView.updateAudioFrame(false);
        }
    }

    @Override
    public String getCanSpeak() {
        return this.canSpeak;
    }

    @Override
    public void setTime(long time) {
    }

    @Override
    public void seekTo(long time) {
    }

    private void dealAuction(MessageData msg) {
        if (!AuctionManager.getInstance().isLoaded()) {
            return;
        }
        GoodsAuctionInfo info = (GoodsAuctionInfo)JSON.parseObject((String)msg.getImMessageInfo().getData(), GoodsAuctionInfo.class);
        if (info != null && TextUtils.equals((CharSequence)info.type, (CharSequence)"start_bid") && (TextUtils.equals((CharSequence)"2", (CharSequence)this.roomInfo.getRole_name()) || TextUtils.equals((CharSequence)"4", (CharSequence)this.roomInfo.getRole_name()) || TextUtils.equals((CharSequence)"3", (CharSequence)this.roomInfo.getRole_name()))) {
            info.isUser = true;
            this.watchLiveView.showAuctionView(info);
        } else if (info != null && TextUtils.equals((CharSequence)info.type, (CharSequence)"end_bid")) {
            this.watchLiveView.hideAuctionView();
            Bundle bundle1 = new Bundle();
            GoodsAuctionInfo.GoodsInfoBean goodsInfoBean = new GoodsAuctionInfo.GoodsInfoBean();
            goodsInfoBean.isMySelf = info.winner != null && TextUtils.equals((CharSequence)info.winner.account_id, (CharSequence)AccountManager.getInstance().getUserId());
            if (info.winner != null) {
                goodsInfoBean.name = info.winner.nickname;
                goodsInfoBean.price = info.winner.offer_price;
            }
            goodsInfoBean.success = !TextUtils.equals((CharSequence)"2", (CharSequence)info.result_status);
            bundle1.putSerializable(AuctionManager.BUNDLE_KEY_AUCTION_RESULT_INFO, (Serializable)goodsInfoBean);
            AuctionManager.getInstance().showAuctionResult(this.watchLiveView.getContext(), bundle1);
        } else if (info != null && TextUtils.equals((CharSequence)info.type, (CharSequence)"offer_bid")) {
            GoodsAuctionInfo.GoodsInfoBean goodsInfoBean = new GoodsAuctionInfo.GoodsInfoBean();
            goodsInfoBean.price = info.offer_price;
            goodsInfoBean.name = info.nickname;
            this.watchLiveView.showAuctionOfferView(goodsInfoBean);
        } else if (info != null && TextUtils.equals((CharSequence)info.type, (CharSequence)"bid_switch")) {
            if (TextUtils.equals((CharSequence)"1", (CharSequence)info.status)) {
                this.watchLiveView.setAuctionStatus(true);
                this.watchLiveView.showToast(M.context.getString(R.string.watch_vertical_open_auction));
            } else {
                this.watchLiveView.showToast(M.context.getString(R.string.watch_vertical_chose_auction));
                this.watchLiveView.setAuctionStatus(false);
            }
        }
    }

    private void processRtcMessage(MessageData msg) {
        this.watchLiveView.notifyIMData(msg);
    }

    private void scheduleMessage(MessageData msg) {
        try {
            JSONObject data = new JSONObject(msg.getImMessageInfo().getData());
            String json = data.toString();
            if (data.optInt("type") == 3001) {
                ResponsePushGoodsScreenBean responsePushGoodsScreenBean = JsonParseUtil.jsonStringToBean(json, ResponsePushGoodsScreenBean.class);
                this.onPushGoodsScreen(responsePushGoodsScreenBean);
            } else if (data.optInt("type") == 4001) {
                int status = data.optInt("status");
                this.watchLiveView.onSetGoodsListState(status);
            } else if ("pendant_push_screen".equals(data.optString("type"))) {
                this.onPendantPushScreen(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.e(e.toString() + "///scheduleMessage");
        }
    }

    private void onPushGoodsScreen(ResponsePushGoodsScreenBean rpg) {
        this.watchLiveView.goodsPushScreen(rpg);
    }

    private void onPendantPushScreen(MessageData msg) {
        LogUtils.e("/////////MessageData\u5230\u8fd9\u4e86/");
        try {
            LogUtils.e("/////////MessageData/");
            JSONObject data = new JSONObject(msg.getImMessageInfo().getData());
            String pic = data.optString("pic");
            int screen_second = data.optInt("screen_second");
            String pendant_url = data.optString("pendant_url");
            String pendant_id = data.optString("id");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(pic);
            arrayList.add(pendant_url);
            arrayList.add(String.valueOf(screen_second));
            arrayList.add(pendant_id);
            this.watchLiveView.pendantPushScreen(arrayList);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LogUtils.e(e.toString() + "///");
        }
    }

    @Override
    public void onResume() {
        if (this.getPlayer().resumeAble() && !this.getPlayer().isPlaying()) {
            this.getPlayer().resume();
        } else {
            this.getPlayer().start(this.roomInfo.getRoom_id(), this.roomInfo.getPaas_access_token());
        }
    }

    @Override
    public void onStop() {
        if (this.mPlayer != null && this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        }
    }

    @Override
    public void leaveNet() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", this.roomInfo.getRoom_id() + "");
        params.put("type", "1");
        CommonManagerNetWrapper.joinRoomStarrt(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                VhLog.d(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhLog.d(msg);
            }
        });
    }

    @Override
    public IVssMessageListener getListener() {
        return this.listener;
    }

    @Override
    public void leaveRoom() {
        if (this.context != null) {
            if (this.mPlayer != null) {
                this.mPlayer.release();
            }
            this.isWatching = false;
        }
        if (this.mDocument != null) {
            this.mDocument.leave();
        }
        if (this.isUpMic) {
            VssRtcManager.leaveRoom();
        } else {
            VssRtcManager.leaveRoom(false);
        }
    }

    class RtcListener
    implements IVssRtcListener {
        RtcListener() {
        }

        @Override
        public void onDidError(Room room, Room.VHRoomErrorStatus vhRoomErrorStatus, String s) {
        }

        @Override
        public void addStream(final Stream stream) {
            if (stream == null) {
                return;
            }
            new WeakHandler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    WatchLiveGroupPresenter.this.watchLiveView.addStream(stream);
                }
            });
        }

        @Override
        public void removeStream(final Stream stream) {
            if (stream == null) {
                return;
            }
            new WeakHandler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    WatchLiveGroupPresenter.this.watchLiveView.removeStream(stream);
                }
            });
        }

        @Override
        public void updateStream(final Stream stream) {
            if (stream == null) {
                return;
            }
            new WeakHandler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    WatchLiveGroupPresenter.this.watchLiveView.updateStream(stream);
                }
            });
        }

        @Override
        public void onReconnect(int i, int i1) {
        }

        @Override
        public void roomStatusMessageChange(Room room, int status) {
        }

        @Override
        public void onRefreshMembers(JSONObject jsonObject) {
        }

        @Override
        public void onRefreshMemberState() {
        }

        @Override
        public void onStreamMixed(JSONObject jsonObject) {
        }

        @Override
        public void onSpeakError(String userID) {
            if (TextUtils.equals((CharSequence)userID, (CharSequence)AccountManager.getInstance().getUserId()) && WatchLiveGroupPresenter.this.isUpMic) {
                WatchLiveGroupPresenter.this.onDownHand();
                VssRtcManager.getInstance(WatchLiveGroupPresenter.this.context).unableSpeak();
            }
        }
    }

    class MyRoomListener
    implements IVssMessageListener {
        private Activity activity;

        MyRoomListener() {
            this.activity = (Activity)WatchLiveGroupPresenter.this.watchLiveView.getContext();
        }

        @Override
        public void onMessage(MessageData msg) {
            if (msg == null || TextUtils.isEmpty((CharSequence)msg.getType())) {
                return;
            }
            WatchLiveGroupPresenter.this.processRtcMessage(msg);
            switch (msg.getType()) {
                case "lottery_end_switch_status": {
                    try {
                        ResponseImMessageInfo recordPushInfo = msg.getImMessageInfo();
                        String recordPushData = recordPushInfo.getData();
                        JSONObject jsonObject = new JSONObject(recordPushData);
                        WatchLiveGroupPresenter.this.watchLiveView.setWinningType(jsonObject.optString("status") + "");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "lottery_record_push": {
                    ResponseImMessageInfo recordPushInfo = msg.getImMessageInfo();
                    String recordPushData = recordPushInfo.getData();
                    if (TextUtils.isEmpty((CharSequence)recordPushData)) break;
                    try {
                        boolean checkLogin;
                        JSONObject jsonObject = new JSONObject(recordPushData);
                        String lottery_record_user_id = jsonObject.optString("lottery_record_user_id");
                        if (TextUtils.isEmpty((CharSequence)lottery_record_user_id) || TextUtils.isEmpty((CharSequence)UserManager.getUserId())) break;
                        String lottery_record_code = jsonObject.optString("lottery_record_code");
                        String[] split = lottery_record_code.split(",");
                        WatchLiveGroupPresenter.this.watchLiveView.setTopData(split);
                        if (lottery_record_user_id.contains(UserManager.getUserId() + "")) {
                            WatchLiveGroupPresenter.this.watchLiveView.showWiningDialog();
                            break;
                        }
                        if (WatchLiveGroupPresenter.this.fragmentActivity == null || !(checkLogin = VhSdk.getInstance().vhallCallback.checkLogin(WatchLiveGroupPresenter.this.fragmentActivity)) || TextUtils.isEmpty((CharSequence)lottery_record_code)) break;
                        DialogUtils.showLotteyCode(WatchLiveGroupPresenter.this.context, split);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "filterword_push": {
                    SensitiveWordsManager.getInstance().requestSensitiveWords();
                    break;
                }
                case "lottery_switch_push": {
                    try {
                        JSONObject dataJson = new JSONObject(msg.getImMessageInfo().getData());
                        String id2 = dataJson.optString("status");
                        if (TextUtils.equals((CharSequence)id2, (CharSequence)"0")) {
                            WatchLiveGroupPresenter.this.watchLiveView.switchLottery(false);
                            break;
                        }
                        if (!TextUtils.equals((CharSequence)id2, (CharSequence)"1")) break;
                        WatchLiveGroupPresenter.this.watchLiveView.switchLottery(true);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "vrtc_disconnecting_speak": {
                    try {
                        JSONObject dataJson = new JSONObject(msg.getImMessageInfo().getData());
                        String id3 = dataJson.optString("target_id");
                        if (!TextUtils.equals((CharSequence)id3, (CharSequence)WatchLiveGroupPresenter.this.roomInfo.getThird_party_user_id())) break;
                        WatchLiveGroupPresenter.this.onDownHand();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "live_start": {
                    WatchLiveGroupPresenter.this.watchLiveView.onLiveStart();
                    break;
                }
                case "live_over": {
                    WatchLiveGroupPresenter.this.watchLiveView.hideProgress();
                    if (WatchLiveGroupPresenter.this.isUpMic) {
                        VssRtcManager.leaveRoom(false);
                    } else if (WatchLiveGroupPresenter.this.mPlayer != null) {
                        WatchLiveGroupPresenter.this.mPlayer.stop();
                    }
                    WatchLiveGroupPresenter.this.watchLiveView.broadcastFinish();
                    break;
                }
                case "questionnaire_push": {
                    if (!QuestionManager.getInstance().isLoaded() || !QuestionManager.getInstance().isAddedChatInterceptor()) {
                        return;
                    }
                    VssMessageChatData questionOpen = new VssMessageChatData();
                    questionOpen.setQAMsg(true);
                    questionOpen.setUserId(VssRoomManager.getInstance().getRoomInfo().getHostId());
                    questionOpen.setNickname(VssRoomManager.getInstance().getRoomInfo().getHostNickName());
                    questionOpen.setText_content(String.format(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_push_question), VssRoomManager.getInstance().getRoomInfo().getHostNickName()));
                    JSONObject qeJsonObject = (JSONObject)msg.getT();
                    String questionnaire_id = qeJsonObject.optString("questionnaire_id");
                    Bundle bundle = new Bundle();
                    VssMessageChatData.JumpMsgBean jumpMsgBean = new VssMessageChatData.JumpMsgBean();
                    jumpMsgBean.url = QuestionConstantsInternal.watchQuestionUrl(questionnaire_id);
                    jumpMsgBean.id = questionnaire_id;
                    jumpMsgBean.msgType = 1;
                    questionOpen.setJumpMsgBean(jumpMsgBean);
                    WatchLiveGroupPresenter.this.watchLiveView.updateQuestion(true);
                    if (!VhallWebManager.getInstance().judgeQuestionInfo()) break;
                    bundle.putString("load_url", QuestionConstantsInternal.watchQuestionUrl(questionnaire_id));
                    break;
                }
                case "questionnaire_repush": {
                    if (!QuestionManager.getInstance().isLoaded() || QuestionManager.getInstance().isAddedChatInterceptor()) {
                        return;
                    }
                    VssMessageQuestionnaireData qeRePushJsonObject = (VssMessageQuestionnaireData)JSON.parseObject((String)msg.getImMessageInfo().getData(), VssMessageQuestionnaireData.class);
                    String questionnaire_id1 = qeRePushJsonObject.questionnaire_id;
                    List<VssMessageQuestionnaireData.UnanswerJoinsBean> unanswer_joins = qeRePushJsonObject.unanswer_joins;
                    WatchLiveGroupPresenter.this.watchLiveView.updateQuestion(true);
                    if (!VhallWebManager.getInstance().judgeQuestionInfo()) {
                        return;
                    }
                    if (unanswer_joins == null || unanswer_joins.size() == 0) {
                        return;
                    }
                    for (int i = 0; i < unanswer_joins.size(); ++i) {
                        VssMessageQuestionnaireData.UnanswerJoinsBean unanswerJoinsBean = unanswer_joins.get(i);
                        if (unanswerJoinsBean == null || !TextUtils.equals((CharSequence)unanswerJoinsBean.account_id, (CharSequence)VssSdk.getInstance().getUserId())) continue;
                        Bundle bundle2 = new Bundle();
                        bundle2.putString("load_url", QuestionConstantsInternal.watchQuestionUrl(questionnaire_id1));
                        VhallWebviewActivity.startActivity(WatchLiveGroupPresenter.this.watchLiveView.getContext(), bundle2);
                    }
                    break;
                }
                case "vrtc_disconnect_success": {
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_down_mic));
                    VssRtcManager.leaveRoom(false);
                    WatchLiveGroupPresenter.this.watchLiveView.successDownHand();
                    break;
                }
                case "vrtc_connect_close": {
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_not_allow_mic));
                    break;
                }
                case "vrtc_connect_open": {
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_allow_mic));
                    break;
                }
                case "vrtc_connect_invite": {
                    WatchLiveGroupPresenter.this.watchLiveView.showInvited();
                    break;
                }
                case "vrtc_connect_agree": {
                    WatchLiveGroupPresenter.this.onUpMic();
                    break;
                }
                case "room_like_num": {
                    if (!LikeManager.getInstance().isLoaded()) {
                        return;
                    }
                    try {
                        JSONObject jsonObject = new JSONObject(msg.getImMessageInfo().getData());
                        int like = jsonObject.optInt("like");
                        if (like <= 0) break;
                        WatchLiveGroupPresenter.this.watchLiveView.updateLikeNum(like);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "vrtc_connect_refused": 
                case "vrtc_connect_failure": {
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_reject_you_request_rtc_format, VssRoomManager.getInstance().getRoomInfo().getHostNickName()));
                    WatchLiveGroupPresenter.this.watchLiveView.cancelUpHand();
                    break;
                }
                case "kick_out": {
                    VssRoomManager.getInstance().removeVssMessageListener(this);
                    WatchLiveGroupPresenter.this.watchLiveView.kickOut();
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_you_are_kicked));
                    break;
                }
                case "forbidden_words": 
                case "disable_all": {
                    try {
                        JSONObject jsonObject = new JSONObject(msg.getImMessageInfo().getData());
                        String target_id = jsonObject.optString("target_id");
                        if (!TextUtils.equals((CharSequence)AccountManager.getInstance().getUserId(), (CharSequence)target_id)) break;
                        WatchLiveGroupPresenter.this.canSpeak = "1";
                        WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_you_are_banned));
                        WatchLiveGroupPresenter.this.watchLiveView.setForbidSpeakStates(true);
                        VhallComponentConfig.share().addVal("can_speak", WatchLiveGroupPresenter.this.canSpeak);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "permit_words": 
                case "permit_all": {
                    try {
                        JSONObject jsonObject = new JSONObject(msg.getImMessageInfo().getData());
                        String target_id = jsonObject.optString("target_id");
                        if (!TextUtils.equals((CharSequence)AccountManager.getInstance().getUserId(), (CharSequence)target_id)) break;
                        WatchLiveGroupPresenter.this.canSpeak = "0";
                        WatchLiveGroupPresenter.this.watchLiveView.showToast(M.getString(R.string.watch_vertical_you_are_cancel_banned));
                        VhallComponentConfig.share().addVal("can_speak", WatchLiveGroupPresenter.this.canSpeak);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "vrtc_frames_forbid": {
                    WatchLiveGroupPresenter.this.switchVideoFrame(0);
                    if (WatchLiveGroupPresenter.this.mVideoOpen) {
                        WatchLiveGroupPresenter.this.watchLiveView.showToast(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_close_camera_me));
                        WatchLiveGroupPresenter.this.mVideoOpen = false;
                        break;
                    }
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_close_camera));
                    break;
                }
                case "vrtc_frames_display": {
                    WatchLiveGroupPresenter.this.watchLiveView.updateVideoFrame(true);
                    WatchLiveGroupPresenter.this.switchVideoFrame(1);
                    if (WatchLiveGroupPresenter.this.mVideoOpen) {
                        WatchLiveGroupPresenter.this.watchLiveView.showToast(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_open_camera_me));
                        WatchLiveGroupPresenter.this.mVideoOpen = false;
                        break;
                    }
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_open_camera));
                    break;
                }
                case "vrtc_mute": 
                case "vrtc_mute_all": {
                    WatchLiveGroupPresenter.this.switchAudioFrame(0);
                    if (WatchLiveGroupPresenter.this.mAudioOpen) {
                        WatchLiveGroupPresenter.this.watchLiveView.showToast(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_close_mute_me));
                        WatchLiveGroupPresenter.this.mAudioOpen = false;
                        break;
                    }
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_close_mute));
                    break;
                }
                case "vrtc_mute_cancel": 
                case "vrtc_mute_all_cancel": {
                    WatchLiveGroupPresenter.this.switchAudioFrame(1);
                    if (WatchLiveGroupPresenter.this.mAudioOpen) {
                        WatchLiveGroupPresenter.this.mAudioOpen = false;
                        WatchLiveGroupPresenter.this.watchLiveView.showToast(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_open_mute_me));
                        break;
                    }
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_open_mute));
                    break;
                }
                case "room_announcement": {
                    try {
                        JSONObject object = new JSONObject(msg.getImMessageInfo().getData());
                        JSONObject announcement = new JSONObject(object.optString("room_announcement_text"));
                        if (TextUtils.isEmpty((CharSequence)announcement.optString("content")) || !"text".equals(announcement.optString("type"))) break;
                        WatchLiveGroupPresenter.this.watchLiveView.showNotice(announcement.optString("content"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "sign_end": {
                    if (!SignManager.getInstance().isLoaded()) {
                        return;
                    }
                    SignManager.getInstance().hintUserSignDialog();
                    break;
                }
                case "sign_in_push": {
                    if (!SignManager.getInstance().isLoaded()) {
                        return;
                    }
                    VssMessageSignData vssMessageSignData = (VssMessageSignData)msg.getT();
                    try {
                        SignManager.getInstance().showUserSignDialog(vssMessageSignData, WatchLiveGroupPresenter.this.watchLiveView.getContext());
                    }
                    catch (Exception e) {
                        WatchLiveGroupPresenter.this.watchLiveView.showToast(e.getMessage());
                    }
                    break;
                }
                case "Join": {
                    break;
                }
                case "Leave": {
                    break;
                }
                case "text": 
                case "image": {
                    if (TextUtils.equals((CharSequence)msg.getImMessageInfo().getSender_id(), (CharSequence)AccountManager.getInstance().getUserId())) {
                        return;
                    }
                    WatchLiveGroupPresenter.this.watchLiveView.notifyDataChangedChat((VssMessageChatData)msg.getT());
                    break;
                }
                case "service_custom": {
                    Log.e((String)"adassdasd", (String)"MESSAGE_SERVICE_CUSTOM");
                    WatchLiveGroupPresenter.this.dealAuction(msg);
                    WatchLiveGroupPresenter.this.scheduleMessage(msg);
                    break;
                }
                case "photo_signin_push": {
                    try {
                        JSONObject photoSign = new JSONObject(msg.getImMessageInfo().getData());
                        if (TextUtils.isEmpty((CharSequence)photoSign.optString("sign_id"))) break;
                        WatchLiveGroupPresenter.this.watchLiveView.photoSignPush(photoSign.optString("sign_id"), photoSign.optInt("max_photo_count"), photoSign.optInt("sign_show_time"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "question_answer_create": {
                    try {
                        if (InternalUtils.convertBoolean(new JSONObject(msg.getImMessageInfo().getData()).optJSONObject("content").optString("is_show"))) break;
                        WatchLiveGroupPresenter.this.watchLiveView.updateQuestionAnswer(0, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "question_show_status": {
                    if (!QuestionAnswerManager.getInstance().isLoaded()) {
                        return;
                    }
                    WatchLiveGroupPresenter.this.watchLiveView.updateQuestionAnswer(0, true);
                    break;
                }
                case "question_answer_open": {
                    if (!QuestionAnswerManager.getInstance().isLoaded() || !QuestionManager.getInstance().isAddedChatInterceptor()) {
                        return;
                    }
                    VssMessageChatData qaOpen = new VssMessageChatData();
                    qaOpen.setQAMsg(true);
                    qaOpen.setUserId(VssRoomManager.getInstance().getRoomInfo().getHostId());
                    qaOpen.setNickname(VssRoomManager.getInstance().getRoomInfo().getHostNickName());
                    qaOpen.setText_content(String.format(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_open_qa), VssRoomManager.getInstance().getRoomInfo().getHostNickName()));
                    WatchLiveGroupPresenter.this.watchLiveView.updateQuestionAnswer(2, false);
                    WatchLiveGroupPresenter.this.watchLiveView.notifyDataChangedChat(qaOpen);
                    break;
                }
                case "question_answer_close": {
                    if (!QuestionAnswerManager.getInstance().isLoaded() || !QuestionManager.getInstance().isAddedChatInterceptor()) {
                        return;
                    }
                    VssMessageChatData qaClose = new VssMessageChatData();
                    qaClose.setQAMsg(true);
                    qaClose.setUserId(VssRoomManager.getInstance().getRoomInfo().getHostId());
                    qaClose.setNickname(VssRoomManager.getInstance().getRoomInfo().getHostNickName());
                    qaClose.setText_content(String.format(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_close_qa), VssRoomManager.getInstance().getRoomInfo().getHostNickName()));
                    WatchLiveGroupPresenter.this.watchLiveView.updateQuestionAnswer(1, false);
                    WatchLiveGroupPresenter.this.watchLiveView.notifyDataChangedChat(qaClose);
                    break;
                }
                case "vrtc_big_screen_set": {
                    try {
                        JSONObject dataJson;
                        String userId;
                        ResponseImMessageInfo imMessageInfo = msg.getImMessageInfo();
                        if (imMessageInfo == null || TextUtils.isEmpty((CharSequence)(userId = (dataJson = new JSONObject(imMessageInfo.getData())).optString("target_id")))) break;
                        WatchLiveGroupPresenter.this.watchLiveView.switchToHost(userId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "exam_push": {
                    if (!ExamManager.getInstance().isLoaded() || ExamManager.getInstance().isAddedChatInterceptor()) {
                        return;
                    }
                    try {
                        JSONObject examPush = new JSONObject(msg.getImMessageInfo().getData());
                        String exam_id = examPush.optString("exam_id");
                        VssMessageChatData examPushData = new VssMessageChatData();
                        examPushData.setQAMsg(true);
                        examPushData.setUserId(VssRoomManager.getInstance().getRoomInfo().getHostId());
                        examPushData.setNickname(VssRoomManager.getInstance().getRoomInfo().getHostNickName());
                        examPushData.setText_content(String.format(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_push_exam), VssRoomManager.getInstance().getRoomInfo().getHostNickName()));
                        VssMessageChatData.JumpMsgBean voteJumpMsgBean = new VssMessageChatData.JumpMsgBean();
                        Bundle bundle1 = new Bundle();
                        bundle1.putString("id", exam_id);
                        voteJumpMsgBean.url = ExamManager.getInstance().getExamUrl(WatchLiveGroupPresenter.this.watchLiveView.getContext(), bundle1);
                        voteJumpMsgBean.id = exam_id;
                        voteJumpMsgBean.msgType = 4;
                        examPushData.setJumpMsgBean(voteJumpMsgBean);
                        WatchLiveGroupPresenter.this.watchLiveView.notifyDataChangedChat(examPushData);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    WatchLiveGroupPresenter.this.watchLiveView.onPushExam();
                    break;
                }
                case "exam_finish": {
                    if (!ExamManager.getInstance().isLoaded() || ExamManager.getInstance().isAddedChatInterceptor()) {
                        return;
                    }
                    VssMessageChatData examClose = new VssMessageChatData();
                    examClose.setQAMsg(true);
                    examClose.setUserId(VssRoomManager.getInstance().getRoomInfo().getHostId());
                    examClose.setNickname(VssRoomManager.getInstance().getRoomInfo().getHostNickName());
                    examClose.setText_content(String.format(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_close_exam), VssRoomManager.getInstance().getRoomInfo().getHostNickName()));
                    WatchLiveGroupPresenter.this.watchLiveView.notifyDataChangedChat(examClose);
                    WatchLiveGroupPresenter.this.watchLiveView.onExamFinish();
                    break;
                }
                case "vote_push": {
                    if (!VoteManager.getInstance().isLoaded() || VoteManager.getInstance().isAddedChatInterceptor()) {
                        return;
                    }
                    try {
                        JSONObject votePush = new JSONObject(msg.getImMessageInfo().getData());
                        String vote_id = votePush.optString("vote_id");
                        if (TextUtils.isEmpty((CharSequence)vote_id)) {
                            return;
                        }
                        WatchLiveGroupPresenter.this.watchLiveView.onPushVote(vote_id, Integer.parseInt(votePush.optString("limit_time")));
                        VssMessageChatData votePushData = new VssMessageChatData();
                        votePushData.setQAMsg(true);
                        votePushData.setUserId(VssRoomManager.getInstance().getRoomInfo().getHostId());
                        votePushData.setNickname(VssRoomManager.getInstance().getRoomInfo().getHostNickName());
                        votePushData.setText_content(String.format(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_push_vote), VssRoomManager.getInstance().getRoomInfo().getHostNickName()));
                        VssMessageChatData.JumpMsgBean voteJumpMsgBean = new VssMessageChatData.JumpMsgBean();
                        voteJumpMsgBean.url = VoteConstantsInternal.createVoteUrl(vote_id, VoteConstantsInternal.EnumVoteWEB.SUBMIT);
                        voteJumpMsgBean.id = vote_id;
                        voteJumpMsgBean.msgType = 3;
                        votePushData.setJumpMsgBean(voteJumpMsgBean);
                        WatchLiveGroupPresenter.this.watchLiveView.notifyDataChangedChat(votePushData);
                    }
                    catch (Exception e) {
                        Log.e((String)"vhall", (String)e.getMessage());
                    }
                    break;
                }
                case "vote_finish": {
                    if (!VoteManager.getInstance().isLoaded() || VoteManager.getInstance().isAddedChatInterceptor()) {
                        return;
                    }
                    try {
                        JSONObject vote = new JSONObject(msg.getImMessageInfo().getData());
                        if (!TextUtils.isEmpty((CharSequence)vote.optString("vote_id"))) {
                            WatchLiveGroupPresenter.this.watchLiveView.onVoteFinish(vote.optString("vote_id"));
                        }
                        VssMessageChatData votePushData = new VssMessageChatData();
                        votePushData.setQAMsg(true);
                        votePushData.setUserId(VssRoomManager.getInstance().getRoomInfo().getHostId());
                        votePushData.setNickname(VssRoomManager.getInstance().getRoomInfo().getHostNickName());
                        votePushData.setText_content(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_finish_vote));
                        WatchLiveGroupPresenter.this.watchLiveView.notifyDataChangedChat(votePushData);
                    }
                    catch (Exception e) {
                        Log.e((String)"vhall", (String)e.getMessage());
                    }
                    break;
                }
                case "vote_statis": 
                case "vote_final_statis": {
                    if (!VoteManager.getInstance().isLoaded() || VoteManager.getInstance().isAddedChatInterceptor()) {
                        return;
                    }
                    JSONObject voteStatis = null;
                    try {
                        voteStatis = new JSONObject(msg.getImMessageInfo().getData());
                        final String vote_id = voteStatis.optString("vote_id");
                        if (!TextUtils.isEmpty((CharSequence)vote_id)) {
                            new WeakHandler(Looper.getMainLooper()).post(new Runnable(){

                                @Override
                                public void run() {
                                    Bundle bundleVote = new Bundle();
                                    bundleVote.putString("load_url", VoteConstantsInternal.createVoteUrl(vote_id, VoteConstantsInternal.EnumVoteWEB.RESULT));
                                    VhallWebviewActivity.startActivity(WatchLiveGroupPresenter.this.watchLiveView.getContext(), bundleVote);
                                }
                            });
                        }
                        VssMessageChatData votePushData = new VssMessageChatData();
                        votePushData.setQAMsg(true);
                        votePushData.setUserId(VssRoomManager.getInstance().getRoomInfo().getHostId());
                        votePushData.setNickname(VssRoomManager.getInstance().getRoomInfo().getHostNickName());
                        votePushData.setText_content(String.format(WatchLiveGroupPresenter.this.watchLiveView.getContext().getString(R.string.watch_vertical_result_vote), VssRoomManager.getInstance().getRoomInfo().getHostNickName()));
                        WatchLiveGroupPresenter.this.watchLiveView.notifyDataChangedChat(votePushData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "set_coupon_list_switch_push": {
                    if (!CouponManager.getInstance().isLoaded()) break;
                    try {
                        JSONObject data = new JSONObject(msg.getImMessageInfo().getData());
                        if (TextUtils.isEmpty((CharSequence)data.optString("show_coupon"))) break;
                        WatchLiveGroupPresenter.this.watchLiveView.updateCoupon(InternalUtils.convertBoolean(data.optString("show_coupon")));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
            Log.e((String)WatchLiveGroupPresenter.TAG, (String)msg);
        }
    }

    private class MyPlayListener
    implements VHPlayerListener {
        private MyPlayListener() {
        }

        public void onStateChanged(Constants.State state) {
            switch (state) {
                case START: {
                    WatchLiveGroupPresenter.this.isWatching = true;
                    WatchLiveGroupPresenter.this.countDownTimer.cancel();
                    WatchLiveGroupPresenter.this.countDownTimer.start();
                    WatchLiveGroupPresenter.this.setDocDelayTime(3000L);
                    WatchLiveGroupPresenter.this.watchLiveView.hideError();
                    break;
                }
                case BUFFER: {
                    WatchLiveGroupPresenter.this.countDownTimer.cancel();
                    if (!WatchLiveGroupPresenter.this.isWatching) break;
                    WatchLiveGroupPresenter.this.watchLiveView.showProgress();
                    break;
                }
                case STOP: {
                    if (!WatchLiveGroupPresenter.this.isWatching) break;
                    WatchLiveGroupPresenter.this.isWatching = false;
                    break;
                }
            }
        }

        public void onEvent(int event, String msg) {
            LogUtils.e(String.format("errorCode %s  msg %s", event, msg));
            switch (event) {
                case -262: {
                    WatchLiveGroupPresenter.this.watchLiveView.setBps(msg);
                    break;
                }
                case -260: {
                    Log.i((String)WatchLiveGroupPresenter.TAG, (String)msg);
                    break;
                }
                case -261: {
                    break;
                }
                case -265: {
                    try {
                        int width;
                        JSONObject jsonObject = new JSONObject(msg);
                        if (WatchLiveGroupPresenter.this.mPlayer == null) break;
                        int height = (Integer)jsonObject.opt("height");
                        if (height >= (width = ((Integer)jsonObject.opt("width")).intValue())) {
                            WatchLiveGroupPresenter.this.mPlayer.setDrawMode(2);
                            break;
                        }
                        WatchLiveGroupPresenter.this.mPlayer.setDrawMode(1);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }

        public void onError(int errorCode, int innerCode, String msg) {
            WatchLiveGroupPresenter.this.watchLiveView.hideProgress();
            switch (errorCode) {
                case -1: {
                    Log.e((String)WatchLiveGroupPresenter.TAG, (String)("ERROR_CONNECT  " + msg));
                    WatchLiveGroupPresenter.this.isWatching = false;
                    WatchLiveGroupPresenter.this.watchLiveView.playerError();
                    break;
                }
                default: {
                    WatchLiveGroupPresenter.this.watchLiveView.showToast(msg);
                }
            }
        }
    }
}

