/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.watchverticallive;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.bumptech.glide.Glide;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.VhSdk;
import com.vhall.appui.baselib.base.BaseActivity;
import com.vhall.appui.baselib.base.BaseFragment;
import com.vhall.appui.baselib.core.service.IBaseEventListener;
import com.vhall.appui.baselib.net.utils.CoreNetCallback;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureConstance;
import com.vhall.appui.baselib.service.watchlive.WatchVerticalLiveManager;
import com.vhall.appui.baselib.service.watchplayback.WatchPlayBackManager;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.utils.LogUtils;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.InavGetRoomInfo;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.main.network.MainListWrapper;
import com.vhall.appui.watchverticallive.AddressFragment;
import com.vhall.appui.watchverticallive.WatchVerticalLiveFragment;
import java.io.Serializable;
import java.util.HashMap;

public class WatchVerticalLiveActivity
extends BaseActivity {
    public static final String KEY_ID = "roomId";
    public static final String KEY_IL_ID = "ilId";
    public static final String KEY_TOKEN = "vssToken";
    private String vssToken;
    private String roomId;
    private String ilId;
    private BaseFragment watchLiveFragment;
    private BaseFragment watchPlaybackFragment;
    private ResponseRoomInfo roomInfo;
    private InavGetRoomInfo inavGetRoomInfo;
    private AddressFragment addressFragment;
    public static final int STATE_LIVE = 1;
    public static final int STATE_VIDEO = 2;
    public static final int STATE_INTERACTIVE = 3;

    @Override
    protected int getLayoutId() {
        return R.layout.activity_watch;
    }

    @Override
    protected void initView() {
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Glide.with((Context)M.context).resumeRequests();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    @Override
    public boolean isHoldLightScreen() {
        return true;
    }

    @Override
    protected boolean isUseBlackFontWithStatusBar() {
        return false;
    }

    public void refteshRoom(Bundle bundle) {
        this.inavGetRoomInfo = (InavGetRoomInfo)bundle.getSerializable("extra");
        VssRoomManager.getInstance().enterRoom(this.inavGetRoomInfo, new CallBack<ResponseRoomInfo>(){

            @Override
            public void onSuccess(ResponseRoomInfo result) {
                WatchVerticalLiveActivity.this.roomInfo = result;
                if (InternalUtils.convertBoolean(result.getIs_kicked())) {
                    Toast.makeText((Context)WatchVerticalLiveActivity.this, (int)R.string.watch_vertical_sorry_kicked_room, (int)0).show();
                    WatchVerticalLiveActivity.this.finish();
                } else if (WatchVerticalLiveActivity.this.watchLiveFragment != null && WatchVerticalLiveActivity.this.watchLiveFragment.isVisible()) {
                    WatchVerticalLiveActivity.this.changeState(result.getStatus());
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                Toast.makeText((Context)WatchVerticalLiveActivity.this, (CharSequence)msg, (int)0).show();
                Log.e((String)"enterRoom", (String)msg);
            }
        });
    }

    @Override
    protected void initData() {
        this.vssToken = this.getIntent().getStringExtra(KEY_TOKEN);
        this.roomId = this.getIntent().getStringExtra(KEY_ID);
        this.ilId = this.getIntent().getStringExtra(KEY_IL_ID);
        this.inavGetRoomInfo = (InavGetRoomInfo)this.getIntent().getExtras().getBundle("extra").getSerializable("extra");
        this.getWindow().setFormat(-3);
        if (this.inavGetRoomInfo != null && this.inavGetRoomInfo.room_info != null) {
            this.getRoomInfo((Context)this, this.inavGetRoomInfo.room_info.il_id);
        }
    }

    public void getRoomInfo(final Context context, String ilid) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("il_id", ilid);
        param.put("role_name", "2");
        MainListWrapper.getRoomInfo(param, new CoreNetCallback<InavGetRoomInfo>(new CallBack<InavGetRoomInfo>(){

            @Override
            public void onSuccess(InavGetRoomInfo inavGetRoomInfo) {
                PictureInPictureConstance.INAVGETROOMINFO = inavGetRoomInfo;
                if (inavGetRoomInfo != null) {
                    PictureInPictureConstance.INAVGETROOMINFO = inavGetRoomInfo;
                    WatchVerticalLiveActivity.this.inavGetRoomInfo = inavGetRoomInfo;
                    WatchVerticalLiveActivity.this.vssToken = inavGetRoomInfo.vss_token;
                    if (inavGetRoomInfo.room_info != null) {
                        WatchVerticalLiveActivity.this.roomId = inavGetRoomInfo.room_info.room_id;
                        WatchVerticalLiveActivity.this.ilId = inavGetRoomInfo.room_info.il_id;
                    }
                }
                VssRoomManager.getInstance().enterRoom(inavGetRoomInfo, new CallBack<ResponseRoomInfo>(){

                    @Override
                    public void onSuccess(ResponseRoomInfo result) {
                        WatchVerticalLiveActivity.this.roomInfo = result;
                        WatchVerticalLiveActivity.this.changeState(result.getStatus());
                        if (InternalUtils.convertBoolean(result.getIs_kicked())) {
                            Toast.makeText((Context)WatchVerticalLiveActivity.this, (int)R.string.watch_vertical_sorry_kicked_room, (int)0).show();
                            WatchVerticalLiveActivity.this.finish();
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        Toast.makeText((Context)WatchVerticalLiveActivity.this, (CharSequence)msg, (int)0).show();
                        Log.e((String)"enterRoom", (String)msg);
                    }
                });
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhLog.d(msg);
                VHToast.showLongToast(context, msg);
            }
        }, InavGetRoomInfo.class));
    }

    private void changeState(int state) {
        if (VhSdk.getInstance().vhallCallback != null) {
            VhSdk.getInstance().vhallCallback.buriedPoint("Livestream_View", this.roomInfo.getSubject() + "", this.roomInfo.getRoom_id() + "");
        }
        switch (state) {
            case 1: 
            case 3: {
                this.showWatchLiveFragment();
                break;
            }
            case 2: {
                Bundle bundle = new Bundle();
                bundle.putSerializable("responseRoomInfo", (Serializable)this.roomInfo);
                bundle.putSerializable("position", (Serializable)Long.valueOf(this.getIntent().getLongExtra("position", 0L)));
                this.watchPlaybackFragment = WatchPlayBackManager.getInstance().getWatchPlayBackGroupFragment(bundle);
                this.watchPlaybackFragment.registerBaseEventListener(new IBaseEventListener(){

                    @Override
                    public void onEvent(String method, String args, Bundle extra) {
                        if (TextUtils.equals((CharSequence)"onWatchChange", (CharSequence)method)) {
                            WatchVerticalLiveActivity.this.showWatchLiveFragment();
                        }
                    }
                });
                this.showFragment(this.watchPlaybackFragment);
                this.watchLiveFragment = null;
                break;
            }
            default: {
                Toast.makeText((Context)this, (int)R.string.watch_vertical_unknown_status, (int)0).show();
            }
        }
    }

    public void addressFragmet(boolean isAdd, Bundle bundle) {
        try {
            if (isAdd) {
                this.addressFragment = new AddressFragment();
                if (bundle != null) {
                    this.addressFragment.setArguments(bundle);
                }
                FragmentManager fragmentManager = this.getSupportFragmentManager();
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                transaction.add(R.id.fragment_container, (Fragment)this.addressFragment);
                transaction.commitAllowingStateLoss();
            } else if (this.addressFragment != null && !isAdd) {
                FragmentManager fragmentManager = this.getSupportFragmentManager();
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                transaction.remove((Fragment)this.addressFragment);
                transaction.commitAllowingStateLoss();
                if (bundle != null) {
                    this.showToast("\u6210\u529f\u63d0\u4ea4");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showWatchLiveFragment() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_IL_ID, this.ilId);
        bundle.putSerializable("extra", (Serializable)this.roomInfo);
        bundle.putString(KEY_TOKEN, this.vssToken);
        bundle.putString("lottery_switch", this.inavGetRoomInfo.getRoom_info().lottery_switch);
        bundle.putString("end_lottery_switch", this.inavGetRoomInfo.getRoom_info().end_lottery_switch);
        bundle.putString("is_screen_ad", this.inavGetRoomInfo.is_screen_ad + "");
        bundle.putString("start_image", this.inavGetRoomInfo.room_info.start_image + "");
        bundle.putString("welcome_words", this.inavGetRoomInfo.room_info.welcome_words + "");
        bundle.putBoolean("floatingClick", this.getIntent().getBooleanExtra("floatingClick", false));
        this.watchLiveFragment = WatchVerticalLiveManager.getInstance().getWatchLiveGroupFragment(bundle);
        this.watchPlaybackFragment = null;
        if (this.watchLiveFragment != null && this.watchLiveFragment instanceof WatchVerticalLiveFragment) {
            this.showFragment(this.watchLiveFragment);
        } else {
            LogUtils.e(WatchVerticalLiveManager.getInstance().dump());
        }
    }

    private void showFragment(Fragment fragment) {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        transaction.replace(R.id.fragment_container, fragment);
        transaction.commitAllowingStateLoss();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.addressFragment != null && this.addressFragment.isVisible()) {
                FragmentManager fragmentManager = this.getSupportFragmentManager();
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                transaction.remove((Fragment)this.addressFragment);
                transaction.commitAllowingStateLoss();
                return false;
            }
            if (this.watchLiveFragment != null) {
                this.watchLiveFragment.back();
                this.watchLiveFragment.call("back", "", null);
                return false;
            }
            if (this.watchPlaybackFragment != null) {
                this.watchPlaybackFragment.call("back", "", null);
                return false;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    public AddressFragment getAddressFragment() {
        return this.addressFragment;
    }
}

