/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.watchverticallive;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.BaseFragment;
import com.vhall.appui.baselib.callback.VhCallBack;
import com.vhall.appui.baselib.network.CommonManagerNetWrapper;
import com.vhall.appui.baselib.utils.DialogUtils;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.watchverticallive.WatchVerticalLiveActivity;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class AddressFragment
extends BaseFragment {
    private TextView save_address;
    private EditText et_address;
    private EditText et_phone;
    private EditText et_address_info;
    private EditText et_name;
    private String is_entity = "1";
    private String checkMath = "(^[a-zA-Z[ ]\u4e00-\u9fa5\uf900-\ufa2d]+$)";
    private static final Pattern CHINA_PATTERN = Pattern.compile("^((13[0-9])|(14[0-9])|(15[0-9])|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$");

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        final View view = inflater.inflate(R.layout.address_dialog, null);
        this.is_entity = this.getArguments().getString("is_entity");
        if (TextUtils.equals((CharSequence)this.is_entity, (CharSequence)"1")) {
            view.findViewById(R.id.address_title).setVisibility(0);
            view.findViewById(R.id.et_address).setVisibility(0);
            view.findViewById(R.id.address_view).setVisibility(0);
            view.findViewById(R.id.address_info_title).setVisibility(0);
            view.findViewById(R.id.et_address_info).setVisibility(0);
            view.findViewById(R.id.address_info_view).setVisibility(0);
            ((TextView)view.findViewById(R.id.save_address)).setText((CharSequence)"\u4fdd\u5b58\u5730\u5740");
        } else {
            view.findViewById(R.id.address_title).setVisibility(4);
            view.findViewById(R.id.et_address).setVisibility(4);
            view.findViewById(R.id.address_view).setVisibility(4);
            view.findViewById(R.id.address_info_title).setVisibility(4);
            view.findViewById(R.id.et_address_info).setVisibility(4);
            view.findViewById(R.id.address_info_view).setVisibility(4);
            ((TextView)view.findViewById(R.id.save_address)).setText((CharSequence)"\u63d0\u4ea4");
        }
        this.et_name = (EditText)view.findViewById(R.id.et_name);
        view.findViewById(R.id.iv_close).setOnClickListener(v -> {
            if (this.getActivity() instanceof WatchVerticalLiveActivity) {
                ((WatchVerticalLiveActivity)this.getActivity()).addressFragmet(false, null);
            }
        });
        this.et_address = (EditText)view.findViewById(R.id.et_address);
        this.save_address = (TextView)view.findViewById(R.id.save_address);
        this.et_phone = (EditText)view.findViewById(R.id.et_phone);
        this.et_address_info = (EditText)view.findViewById(R.id.et_address_info);
        final TextView tips_name = (TextView)view.findViewById(R.id.tips_name);
        final TextView tips_address = (TextView)view.findViewById(R.id.tips_address);
        final TextView tips_phone = (TextView)view.findViewById(R.id.tips_phone);
        final TextView tips_address_info = (TextView)view.findViewById(R.id.tips_address_info);
        view.findViewById(R.id.name_bg).setOnClickListener(v -> {
            this.et_name.setFocusable(true);
            this.et_name.setFocusableInTouchMode(true);
            this.et_name.requestFocus();
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.showSoftInput((View)this.et_name, 0);
        });
        view.findViewById(R.id.phone_bg).setOnClickListener(v -> {
            this.et_phone.setFocusable(true);
            this.et_phone.setFocusableInTouchMode(true);
            this.et_phone.requestFocus();
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.showSoftInput((View)this.et_phone, 0);
        });
        view.findViewById(R.id.address_bg).setOnClickListener(v -> {
            this.et_address.setFocusable(true);
            this.et_address.setFocusableInTouchMode(true);
            this.et_address.requestFocus();
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.showSoftInput((View)this.et_address, 0);
        });
        view.findViewById(R.id.address_info_bg).setOnClickListener(v -> {
            this.et_address_info.setFocusable(true);
            this.et_address_info.setFocusableInTouchMode(true);
            this.et_address_info.requestFocus();
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.showSoftInput((View)this.et_address_info, 0);
        });
        this.save_address.setOnClickListener(v -> {
            if (TextUtils.equals((CharSequence)this.is_entity, (CharSequence)"1")) {
                if (this.checkName(this.et_name.getText().toString().trim())) {
                    tips_name.setVisibility(0);
                    return;
                }
                if (this.checkPhone(this.et_phone.getText().toString().trim())) {
                    tips_phone.setVisibility(0);
                    return;
                }
                if (this.et_address.getText().toString().trim().length() <= 0) {
                    tips_address.setVisibility(0);
                    return;
                }
                if (this.et_address_info.getText().toString().trim().length() <= 0) {
                    tips_address_info.setVisibility(0);
                    return;
                }
                DialogUtils.showAddressDialog((Context)this.getActivity(), new VhCallBack(){

                    @Override
                    public void success() {
                        HashMap<String, String> params = new HashMap<String, String>();
                        String record_id = AddressFragment.this.getArguments().getString("record_id");
                        if (!TextUtils.isEmpty((CharSequence)record_id)) {
                            params.put("record_id", record_id);
                        }
                        JSONObject jsonObject = new JSONObject();
                        try {
                            jsonObject.put("name", (Object)AddressFragment.this.et_name.getText().toString().trim());
                            jsonObject.put("phone", (Object)AddressFragment.this.et_phone.getText().toString().trim());
                            jsonObject.put("province", (Object)AddressFragment.this.et_address.getText().toString().trim());
                            jsonObject.put("address", (Object)AddressFragment.this.et_address_info.getText().toString().trim());
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        params.put("info", jsonObject.toString());
                        CommonManagerNetWrapper.getRecordWinninginfo(params, new CallBack<String>(){

                            @Override
                            public void onSuccess(String result) {
                                VhLog.d(result);
                                if (AddressFragment.this.getActivity() instanceof WatchVerticalLiveActivity) {
                                    ((WatchVerticalLiveActivity)AddressFragment.this.getActivity()).addressFragmet(false, new Bundle());
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                VhLog.d(msg);
                                VHToast.showLongToast((Context)M.context, msg);
                            }
                        });
                    }

                    @Override
                    public void error(String message) {
                    }
                });
            } else {
                if (this.checkName(this.et_name.getText().toString().trim())) {
                    tips_name.setVisibility(0);
                    return;
                }
                if (this.checkPhone(this.et_phone.getText().toString().trim())) {
                    tips_phone.setVisibility(0);
                    return;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                String record_id = this.getArguments().getString("record_id");
                if (!TextUtils.isEmpty((CharSequence)record_id)) {
                    params.put("record_id", record_id);
                }
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("name", (Object)this.et_name.getText().toString().trim());
                    jsonObject.put("phone", (Object)this.et_phone.getText().toString().trim());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                params.put("info", jsonObject.toString());
                CommonManagerNetWrapper.getRecordWinninginfo(params, new CallBack<String>(){

                    @Override
                    public void onSuccess(String result) {
                        VhLog.d(result);
                        if (AddressFragment.this.getActivity() instanceof WatchVerticalLiveActivity) {
                            ((WatchVerticalLiveActivity)AddressFragment.this.getActivity()).addressFragmet(false, new Bundle());
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        VhLog.d(msg);
                    }
                });
            }
        });
        this.et_name.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String text = s.toString();
                if (!TextUtils.isEmpty((CharSequence)text)) {
                    if (text.length() > 30) {
                        AddressFragment.this.et_name.setText(s.subSequence(0, 30));
                        Selection.setSelection((Spannable)AddressFragment.this.et_name.getText(), (int)30);
                    }
                    Pattern pattern = Pattern.compile(AddressFragment.this.checkMath);
                    if (text.length() > 1 && pattern.matcher(text).matches()) {
                        tips_name.setVisibility(4);
                        ((TextView)view.findViewById(R.id.name_title)).setText((CharSequence)"\u59d3\u540d");
                        ((TextView)view.findViewById(R.id.name_title)).setTextColor(Color.parseColor((String)"#000000"));
                        view.findViewById(R.id.title_view).setBackgroundColor(Color.parseColor((String)"#000000"));
                    } else {
                        ((TextView)view.findViewById(R.id.name_title)).setText((CharSequence)"\u59d3\u540d");
                        tips_name.setVisibility(0);
                        ((TextView)view.findViewById(R.id.name_title)).setTextColor(Color.parseColor((String)"#AE4747"));
                        view.findViewById(R.id.title_view).setBackgroundColor(Color.parseColor((String)"#AE4747"));
                    }
                    AddressFragment.this.checkAll();
                }
            }
        });
        this.et_phone.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String text = s.toString();
                if (text.length() > 11) {
                    AddressFragment.this.et_phone.setText(s.subSequence(0, 11));
                    Selection.setSelection((Spannable)AddressFragment.this.et_phone.getText(), (int)11);
                }
                if (!AddressFragment.this.checkPhone(AddressFragment.this.et_phone.getText().toString().trim())) {
                    tips_phone.setVisibility(4);
                    ((TextView)view.findViewById(R.id.phone_title)).setTextColor(Color.parseColor((String)"#000000"));
                    view.findViewById(R.id.phone_view).setBackgroundColor(Color.parseColor((String)"#000000"));
                } else {
                    tips_phone.setVisibility(0);
                    ((TextView)view.findViewById(R.id.phone_title)).setTextColor(Color.parseColor((String)"#AE4747"));
                    view.findViewById(R.id.phone_view).setBackgroundColor(Color.parseColor((String)"#AE4747"));
                }
                if (AddressFragment.this.checkName(AddressFragment.this.et_name.getText().toString().trim())) {
                    ((TextView)view.findViewById(R.id.name_title)).setText((CharSequence)"\u59d3\u540d");
                    tips_name.setVisibility(0);
                    ((TextView)view.findViewById(R.id.name_title)).setTextColor(Color.parseColor((String)"#AE4747"));
                    view.findViewById(R.id.title_view).setBackgroundColor(Color.parseColor((String)"#AE4747"));
                }
                AddressFragment.this.checkAll();
            }
        });
        this.et_address.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String text = s.toString();
                if (text.length() > 60) {
                    AddressFragment.this.et_address.setText(s.subSequence(0, 60));
                    Selection.setSelection((Spannable)AddressFragment.this.et_address.getText(), (int)60);
                }
                if (text.length() > 0) {
                    tips_address.setVisibility(4);
                    ((TextView)view.findViewById(R.id.address_title)).setTextColor(Color.parseColor((String)"#000000"));
                    view.findViewById(R.id.address_view).setBackgroundColor(Color.parseColor((String)"#000000"));
                } else {
                    tips_address.setVisibility(0);
                    ((TextView)view.findViewById(R.id.address_title)).setTextColor(Color.parseColor((String)"#AE4747"));
                    view.findViewById(R.id.address_view).setBackgroundColor(Color.parseColor((String)"#AE4747"));
                }
                if (AddressFragment.this.checkPhone(AddressFragment.this.et_phone.getText().toString().trim())) {
                    tips_phone.setVisibility(0);
                    ((TextView)view.findViewById(R.id.phone_title)).setTextColor(Color.parseColor((String)"#AE4747"));
                    view.findViewById(R.id.phone_view).setBackgroundColor(Color.parseColor((String)"#AE4747"));
                }
                AddressFragment.this.checkAll();
            }
        });
        this.et_address_info.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String text = s.toString();
                if (text.length() > 60) {
                    AddressFragment.this.et_address_info.setText(s.subSequence(0, 60));
                    Selection.setSelection((Spannable)AddressFragment.this.et_address_info.getText(), (int)60);
                }
                if (text.length() > 0) {
                    tips_address_info.setVisibility(4);
                    ((TextView)view.findViewById(R.id.address_info_title)).setTextColor(Color.parseColor((String)"#000000"));
                    view.findViewById(R.id.address_info_view).setBackgroundColor(Color.parseColor((String)"#000000"));
                } else {
                    tips_address_info.setVisibility(0);
                    ((TextView)view.findViewById(R.id.address_info_title)).setTextColor(Color.parseColor((String)"#AE4747"));
                    view.findViewById(R.id.address_info_view).setBackgroundColor(Color.parseColor((String)"#AE4747"));
                }
                if (AddressFragment.this.checkName(AddressFragment.this.et_name.getText().toString().trim())) {
                    ((TextView)view.findViewById(R.id.name_title)).setText((CharSequence)"\u59d3\u540d");
                    tips_name.setVisibility(0);
                    ((TextView)view.findViewById(R.id.name_title)).setTextColor(Color.parseColor((String)"#AE4747"));
                    view.findViewById(R.id.title_view).setBackgroundColor(Color.parseColor((String)"#AE4747"));
                }
                if (AddressFragment.this.checkPhone(AddressFragment.this.et_phone.getText().toString().trim())) {
                    tips_phone.setVisibility(0);
                    ((TextView)view.findViewById(R.id.phone_title)).setTextColor(Color.parseColor((String)"#AE4747"));
                    view.findViewById(R.id.phone_view).setBackgroundColor(Color.parseColor((String)"#AE4747"));
                }
                if (AddressFragment.this.et_address.getText().toString().trim().length() <= 0) {
                    tips_address.setVisibility(0);
                    ((TextView)view.findViewById(R.id.address_title)).setTextColor(Color.parseColor((String)"#AE4747"));
                    view.findViewById(R.id.address_view).setBackgroundColor(Color.parseColor((String)"#AE4747"));
                }
                AddressFragment.this.checkAll();
            }
        });
        return view;
    }

    public boolean checkPhone(String phone) {
        if (!TextUtils.isEmpty((CharSequence)phone)) {
            Matcher m = CHINA_PATTERN.matcher(phone);
            return !m.matches();
        }
        return true;
    }

    public boolean checkName(String name) {
        return TextUtils.isEmpty((CharSequence)name) || name.length() <= 1;
    }

    public void checkAll() {
        if (this.save_address != null) {
            if (TextUtils.equals((CharSequence)this.is_entity, (CharSequence)"1")) {
                if (!(TextUtils.isEmpty((CharSequence)this.et_address.getText().toString()) || TextUtils.isEmpty((CharSequence)this.et_address_info.getText().toString()) || TextUtils.isEmpty((CharSequence)this.et_name.getText().toString()) || TextUtils.isEmpty((CharSequence)this.et_phone.getText().toString()))) {
                    this.save_address.setEnabled(true);
                    this.save_address.setBackgroundColor(Color.parseColor((String)"#222222"));
                } else {
                    this.save_address.setEnabled(false);
                    this.save_address.setBackgroundColor(Color.parseColor((String)"#B3B3B3"));
                }
            } else if (!TextUtils.isEmpty((CharSequence)this.et_name.getText().toString()) && !TextUtils.isEmpty((CharSequence)this.et_phone.getText().toString())) {
                this.save_address.setEnabled(true);
                this.save_address.setBackgroundColor(Color.parseColor((String)"#222222"));
            } else {
                this.save_address.setEnabled(false);
                this.save_address.setBackgroundColor(Color.parseColor((String)"#B3B3B3"));
            }
        }
    }
}

