/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.watchplayback.present;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.vhall.appui.baselib.utils.UserUtils;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.module.room.ProxyVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import com.vhall.appui.baselib.vss.module.rtc.VssRtcManager;
import com.vhall.appui.watchplayback.present.IWatchBackContract;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.vod.VHVodPlayer;
import org.json.JSONObject;

public class WatchBackPresenter
implements IWatchBackContract.IWatchBackPresenter {
    private static final String TAG = "WatchBackGroupPresenter";
    private IWatchBackContract.IWatchBackView watchBackView;
    private Context context;
    private ResponseRoomInfo roomInfo;
    private VHVodPlayer mPlayer;
    private boolean isInit = false;
    private boolean isPlaying = false;
    private String canSpeak = "0";

    public WatchBackPresenter(IWatchBackContract.IWatchBackView watchBackView, ResponseRoomInfo roomInfo) {
        this.watchBackView = watchBackView;
        this.watchBackView.setPresenter(this);
        this.roomInfo = roomInfo;
        this.context = watchBackView.getContext();
        VssRoomManager.getInstance().setVssMessageListener(new ProxyVssMessageListener(new MyVssMessageListener()));
        this.canSpeak = roomInfo.getIs_banned();
    }

    @Override
    public void initLive() {
        this.mPlayer = this.watchBackView.getPlay();
        this.mPlayer.setListener((VHPlayerListener)new MyPlayerListener());
        this.play();
    }

    @Override
    public void play() {
        if (!this.isInit) {
            this.mPlayer.init(this.roomInfo.getRecord_id(), this.roomInfo.getPaas_access_token());
        } else if (this.isPlaying) {
            this.mPlayer.pause();
        } else if (this.mPlayer.getState() == Constants.State.END) {
            this.mPlayer.seekto(0L);
        } else if (this.mPlayer.getState() == Constants.State.STOP) {
            this.mPlayer.resume();
        } else {
            this.mPlayer.start();
        }
    }

    @Override
    public void leaveRoom() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        VssRtcManager.leaveRoom(false);
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onStop() {
    }

    class MyVssMessageListener
    implements IVssMessageListener {
        MyVssMessageListener() {
        }

        @Override
        public void onMessage(MessageData msg) {
            if (msg == null || TextUtils.isEmpty((CharSequence)msg.getType())) {
                return;
            }
            switch (msg.getType()) {
                case "live_start": {
                    WatchBackPresenter.this.watchBackView.startLive();
                    break;
                }
                case "forbidden_words": 
                case "disable_all": {
                    WatchBackPresenter.this.watchBackView.showToast("\u60a8\u5df2\u88ab\u7981\u8a00");
                    WatchBackPresenter.this.canSpeak = "1";
                    break;
                }
                case "permit_words": 
                case "permit_all": {
                    WatchBackPresenter.this.watchBackView.showToast("\u60a8\u5df2\u88ab\u53d6\u6d88\u7981\u8a00");
                    WatchBackPresenter.this.canSpeak = "0";
                    break;
                }
                case "Join": {
                    JSONObject joinObject = (JSONObject)msg.getT();
                    VssMessageChatData join = new VssMessageChatData();
                    join.event = "online";
                    join.setTime(joinObject.optString("time"));
                    join.setNickname(joinObject.optString("name"));
                    join.setUserId(joinObject.optString("id"));
                    join.setText_content(UserUtils.getNickname(joinObject.optString("name")) + "\u4e0a\u7ebf\u4e86");
                    break;
                }
                case "Leave": {
                    JSONObject leaveObject = (JSONObject)msg.getT();
                    VssMessageChatData leave = new VssMessageChatData();
                    leave.event = "online";
                    leave.setTime(leaveObject.optString("time"));
                    leave.setNickname(leaveObject.optString("name"));
                    leave.setUserId(leaveObject.optString("id"));
                    leave.setText_content(UserUtils.getNickname(leaveObject.optString("name")) + "\u4e0b\u7ebf\u4e86");
                    break;
                }
                case "text": 
                case "image": 
                case "service_custom": {
                    break;
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
            Log.e((String)WatchBackPresenter.TAG, (String)msg);
        }
    }

    class MyPlayerListener
    implements VHPlayerListener {
        MyPlayerListener() {
        }

        public void onStateChanged(Constants.State state) {
            int playState = -1;
            switch (state) {
                case IDLE: {
                    WatchBackPresenter.this.isPlaying = false;
                    playState = 1;
                    break;
                }
                case BUFFER: {
                    WatchBackPresenter.this.watchBackView.showProgress();
                    break;
                }
                case START: {
                    WatchBackPresenter.this.watchBackView.hideProgress();
                    WatchBackPresenter.this.isPlaying = true;
                    playState = 0;
                    break;
                }
                case STOP: {
                    WatchBackPresenter.this.isPlaying = false;
                    WatchBackPresenter.this.watchBackView.hideProgress();
                    playState = 1;
                    break;
                }
                case END: {
                    WatchBackPresenter.this.isPlaying = false;
                    WatchBackPresenter.this.watchBackView.hideProgress();
                    playState = 2;
                    break;
                }
            }
            WatchBackPresenter.this.watchBackView.setPlayBtn(WatchBackPresenter.this.isPlaying, playState);
        }

        public void onEvent(int event, String msg) {
            switch (event) {
                case -256: {
                    WatchBackPresenter.this.mPlayer.start();
                    WatchBackPresenter.this.isInit = true;
                    break;
                }
                case -265: {
                    break;
                }
                case -261: {
                    break;
                }
                case -260: {
                    break;
                }
            }
        }

        public void onError(int errorCode, int i1, String msg) {
            WatchBackPresenter.this.isInit = false;
            switch (errorCode) {
                case -1: {
                    WatchBackPresenter.this.watchBackView.showToast("\u521d\u59cb\u5316\u5931\u8d25");
                    break;
                }
                case -2: {
                    WatchBackPresenter.this.watchBackView.showToast("\u8bf7\u5148\u521d\u59cb\u5316");
                    break;
                }
                default: {
                    WatchBackPresenter.this.watchBackView.showToast(msg);
                }
            }
            WatchBackPresenter.this.isPlaying = false;
            WatchBackPresenter.this.watchBackView.setPlayBtn(false, 1);
            WatchBackPresenter.this.watchBackView.hideProgress();
        }
    }
}

