/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.watchplayback.present;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.service.broadcast.IChatContract;
import com.vhall.appui.baselib.service.document.IDocumentContract;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.module.room.ProxyVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import com.vhall.appui.baselib.vss.module.rtc.VssRtcManager;
import com.vhall.appui.watchplayback.present.IWatchBackGroupContract;
import com.vhall.ops.VHOPS;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.vod.VHVodPlayer;
import org.json.JSONException;
import org.json.JSONObject;

public class WatchBackGroupPresenter
implements IWatchBackGroupContract.IWatchBackPresenter,
IChatContract.IChatPresenter,
IDocumentContract.IDocumentPresent {
    private static final String TAG = "WatchBackGroupPresenter";
    private IWatchBackGroupContract.IWatchBackView watchBackView;
    private IDocumentContract.IDocumentView documentView;
    private IChatContract.IChatView chatView;
    private Context context;
    private ResponseRoomInfo roomInfo;
    private VHVodPlayer mPlayer;
    private boolean isInit = false;
    private boolean isPlaying = false;
    private VHOPS mDocument;
    private String canSpeak = "0";
    private long delayTime = 0L;
    private VHOPS.EventListener opsCallback = new VHOPS.EventListener(){

        public void onEvent(String event, String type, String cid) {
            if (WatchBackGroupPresenter.this.documentView == null || WatchBackGroupPresenter.this.mDocument == null) {
                return;
            }
            if (event.equals(VHOPS.KEY_OPERATE)) {
                if (type.equals(VHOPS.TYPE_ACTIVE)) {
                    WatchBackGroupPresenter.this.documentView.setDocView(WatchBackGroupPresenter.this.mDocument.getActiveView());
                } else if (type.equals(VHOPS.TYPE_SWITCHOFF)) {
                    WatchBackGroupPresenter.this.documentView.hideDoc();
                } else if (type.equals(VHOPS.TYPE_SWITCHON)) {
                    WatchBackGroupPresenter.this.documentView.showDoc();
                }
            }
        }

        public void onError(int errorCode, int innerError, String errorMsg) {
            if (WatchBackGroupPresenter.this.documentView == null || WatchBackGroupPresenter.this.mDocument == null) {
                return;
            }
            WatchBackGroupPresenter.this.watchBackView.showToast(errorMsg);
        }
    };

    public WatchBackGroupPresenter(IWatchBackGroupContract.IWatchBackView watchBackView, IChatContract.IChatView chatView, IDocumentContract.IDocumentView documentView, ResponseRoomInfo roomInfo) {
        this.watchBackView = watchBackView;
        this.documentView = documentView;
        this.watchBackView.setPresenter(this);
        this.roomInfo = roomInfo;
        this.context = watchBackView.getContext();
        VssRoomManager.getInstance().setVssMessageListener(new ProxyVssMessageListener(new MyRoomListener()));
        this.canSpeak = roomInfo.getIs_banned();
        this.chatView = chatView;
        if (chatView == null) {
            this.watchBackView.showChat(8);
        } else {
            this.chatView.setPresenter(this);
            this.watchBackView.showChat(0);
            if (this.canSpeak.equals("1")) {
                this.chatView.upDateStatus(false, this.context.getString(R.string.disable_chat));
            } else {
                this.chatView.upDateStatus(true, this.context.getString(R.string.input_content_to_send));
            }
        }
        try {
            if (documentView != null) {
                this.documentView.setPresenter(this);
                this.mDocument = new VHOPS(this.context, roomInfo.getRecord_id(), null);
                this.mDocument.setListener(this.opsCallback);
                this.mDocument.join();
            }
        }
        catch (Exception e) {
            VhLog.d(e.getMessage());
        }
    }

    @Override
    public void initLive() {
        this.mPlayer = this.watchBackView.getPlay();
        this.mPlayer.setListener((VHPlayerListener)new MyPlayer());
        this.play();
    }

    @Override
    public void play() {
        if (!this.isInit) {
            this.mPlayer.init(this.roomInfo.getRecord_id(), this.roomInfo.getPaas_access_token());
        } else if (this.isPlaying) {
            this.mPlayer.pause();
        } else if (this.mPlayer.getState() == Constants.State.END) {
            this.mPlayer.seekto(0L);
            if (this.mDocument != null) {
                this.mDocument.seekTo(0L);
            }
            this.mPlayer.start();
        } else if (this.mPlayer.getState() == Constants.State.STOP) {
            this.mPlayer.resume();
        } else {
            this.mPlayer.start();
        }
    }

    public void setDocDelayTime(long delayTime) {
        this.delayTime = delayTime;
        if (this.mDocument != null) {
            this.mDocument.setDealTime((int)delayTime);
        }
    }

    @Override
    public void setTime(long time) {
        if (this.mDocument != null) {
            this.mDocument.setTime(time);
        }
    }

    @Override
    public void seekTo(long time) {
        if (this.mDocument != null) {
            this.mDocument.seekTo(time);
        }
    }

    @Override
    public String getCanSpeak() {
        return this.canSpeak;
    }

    @Override
    public void leaveRoom() {
        if (this.mDocument != null) {
            this.mDocument.leave();
        }
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        VssRtcManager.leaveRoom(false);
    }

    @Override
    public void onResume() {
        if (!this.isInit) {
            this.mPlayer.init(this.roomInfo.getRecord_id(), this.roomInfo.getPaas_access_token());
        } else if (!this.isPlaying) {
            if (this.mPlayer.getState() == Constants.State.END) {
                this.mPlayer.seekto(0L);
                if (this.mDocument != null) {
                    this.mDocument.seekTo(0L);
                }
                this.mPlayer.start();
            } else if (this.mPlayer.getState() == Constants.State.STOP) {
                this.mPlayer.resume();
            } else {
                this.mPlayer.start();
            }
        }
    }

    @Override
    public void onStop() {
        this.play();
    }

    class MyRoomListener
    implements IVssMessageListener {
        MyRoomListener() {
        }

        @Override
        public void onMessage(MessageData msg) {
            if (msg == null || TextUtils.isEmpty((CharSequence)msg.getType())) {
                return;
            }
            switch (msg.getType()) {
                case "live_start": {
                    WatchBackGroupPresenter.this.watchBackView.startLive();
                    break;
                }
                case "forbidden_words": 
                case "disable_all": {
                    WatchBackGroupPresenter.this.watchBackView.showToast("\u60a8\u5df2\u88ab\u7981\u8a00");
                    WatchBackGroupPresenter.this.canSpeak = "1";
                    WatchBackGroupPresenter.this.chatView.upDateStatus(false, WatchBackGroupPresenter.this.context.getString(R.string.disable_chat));
                    break;
                }
                case "permit_words": 
                case "permit_all": {
                    WatchBackGroupPresenter.this.watchBackView.showToast("\u60a8\u5df2\u88ab\u53d6\u6d88\u7981\u8a00");
                    WatchBackGroupPresenter.this.chatView.upDateStatus(true, WatchBackGroupPresenter.this.context.getString(R.string.input_content_to_send));
                    WatchBackGroupPresenter.this.canSpeak = "0";
                    break;
                }
                case "Join": {
                    JSONObject joinObject = (JSONObject)msg.getT();
                    VssMessageChatData join = new VssMessageChatData();
                    join.setTime(joinObject.optString("time"));
                    join.setNickname(joinObject.optString("name"));
                    join.setUserId(joinObject.optString("id"));
                    join.setText_content("\u4e0a\u7ebf\u4e86");
                    WatchBackGroupPresenter.this.watchBackView.notifyDataChangedChat(join);
                    break;
                }
                case "Leave": {
                    JSONObject leaveObject = (JSONObject)msg.getT();
                    VssMessageChatData leave = new VssMessageChatData();
                    leave.setTime(leaveObject.optString("time"));
                    leave.setNickname(leaveObject.optString("name"));
                    leave.setUserId(leaveObject.optString("id"));
                    leave.setText_content("\u4e0b\u7ebf\u4e86");
                    WatchBackGroupPresenter.this.watchBackView.notifyDataChangedChat(leave);
                    break;
                }
                case "service_im": 
                case "service_custom": {
                    WatchBackGroupPresenter.this.watchBackView.notifyDataChangedChat((VssMessageChatData)msg.getT());
                    break;
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
            Log.e((String)WatchBackGroupPresenter.TAG, (String)msg);
        }
    }

    class MyPlayer
    implements VHPlayerListener {
        MyPlayer() {
        }

        public void onStateChanged(Constants.State state) {
            int playState = -1;
            switch (state) {
                case IDLE: {
                    WatchBackGroupPresenter.this.isPlaying = false;
                    playState = 1;
                    break;
                }
                case BUFFER: {
                    WatchBackGroupPresenter.this.watchBackView.showProgress();
                    break;
                }
                case START: {
                    WatchBackGroupPresenter.this.watchBackView.hideProgress();
                    WatchBackGroupPresenter.this.isPlaying = true;
                    playState = 0;
                    break;
                }
                case STOP: {
                    WatchBackGroupPresenter.this.isPlaying = false;
                    WatchBackGroupPresenter.this.watchBackView.hideProgress();
                    playState = 1;
                    break;
                }
                case END: {
                    WatchBackGroupPresenter.this.isPlaying = false;
                    WatchBackGroupPresenter.this.watchBackView.hideProgress();
                    playState = 2;
                    break;
                }
            }
            WatchBackGroupPresenter.this.watchBackView.setPlayBtn(WatchBackGroupPresenter.this.isPlaying, playState);
        }

        public void onEvent(int event, String msg) {
            switch (event) {
                case -256: {
                    if (WatchBackGroupPresenter.this.mDocument != null) {
                        WatchBackGroupPresenter.this.mDocument.setCue_point(WatchBackGroupPresenter.this.mPlayer.getCurePoint());
                    }
                    WatchBackGroupPresenter.this.mPlayer.start();
                    WatchBackGroupPresenter.this.isInit = true;
                    break;
                }
                case -265: {
                    try {
                        int width;
                        JSONObject jsonObject = new JSONObject(msg);
                        if (WatchBackGroupPresenter.this.mPlayer == null) break;
                        int height = (Integer)jsonObject.opt("height");
                        if (height >= (width = ((Integer)jsonObject.opt("width")).intValue())) {
                            WatchBackGroupPresenter.this.mPlayer.setDrawMode(2);
                            break;
                        }
                        WatchBackGroupPresenter.this.mPlayer.setDrawMode(1);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case -261: {
                    WatchBackGroupPresenter.this.mPlayer.setDPI("same");
                    break;
                }
                case -260: {
                    break;
                }
            }
        }

        public void onError(int errorCode, int i1, String msg) {
            WatchBackGroupPresenter.this.isInit = false;
            switch (errorCode) {
                case -1: {
                    WatchBackGroupPresenter.this.watchBackView.showToast("\u521d\u59cb\u5316\u5931\u8d25");
                    break;
                }
                case -2: {
                    WatchBackGroupPresenter.this.watchBackView.showToast("\u8bf7\u5148\u521d\u59cb\u5316");
                    break;
                }
                default: {
                    WatchBackGroupPresenter.this.watchBackView.showToast(msg);
                }
            }
            WatchBackGroupPresenter.this.isPlaying = false;
            WatchBackGroupPresenter.this.watchBackView.setPlayBtn(false, 1);
            WatchBackGroupPresenter.this.watchBackView.hideProgress();
        }
    }
}

