/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.watchplayback;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Group;
import com.lzf.easyfloat.permission.PermissionUtils;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.VhSdk;
import com.vhall.appui.baselib.base.BaseFragment;
import com.vhall.appui.baselib.net.bean.GoodsResultBean;
import com.vhall.appui.baselib.network.CommonManagerNetWrapper;
import com.vhall.appui.baselib.service.broadcast.IChatContract;
import com.vhall.appui.baselib.service.chat.IChatPanelView;
import com.vhall.appui.baselib.service.document.IDocumentContract;
import com.vhall.appui.baselib.service.pictureinpicture.IPictureInPictureListener;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureConstance;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureManager;
import com.vhall.appui.baselib.utils.CommonUtil;
import com.vhall.appui.baselib.utils.VHMMKV;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.utils.handler.WeakHandler;
import com.vhall.appui.baselib.widget.ChatView;
import com.vhall.appui.baselib.widget.VhGoodsListView;
import com.vhall.appui.watchplayback.present.IBaseWatchGroupContract;
import com.vhall.appui.watchplayback.present.IWatchBackGroupContract;
import com.vhall.appui.watchplayback.present.WatchBackGroupPresenter;
import com.vhall.document.DocumentView;
import com.vhall.vod.VHVodPlayer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WatchPlaybackGroupFragment
extends BaseFragment
implements IWatchBackGroupContract.IWatchBackView,
IChatContract.IChatView,
IDocumentContract.IDocumentView {
    public static final int STATE_PLAYING = 0;
    public static final int STATE_PAUSE = 1;
    public static final int STATE_COMP = 2;
    private TextView replay_vod_bg;
    private View replay_vod_bg_view;
    private TextView iv_watch_live_goods_num;
    private static final String PICTURE_PERMISSION = "picture_permission";
    private Callback mCallback;
    private ResponseRoomInfo roomInfo;
    private ChatView chatView;
    private IChatPanelView chatRecyclerView;
    private IWatchBackGroupContract.IWatchBackPresenter watchBackPresenter;
    private IDocumentContract.IDocumentPresent documentPresent;
    private IChatContract.IChatPresenter chatPresenter;
    private ConstraintLayout.LayoutParams playerViewLayoutParams;
    private FrameLayout frDoc;
    private ImageView ivPlay;
    private SurfaceView playerView;
    private VHVodPlayer mPlayer;
    private TextView tvFullTime;
    private TextView tvCurrentTime;
    private ScheduledThreadPoolExecutor service;
    private SeekBar seekBar;
    private View inflate;
    private boolean mPlaying = false;
    private Group groupSeekBar;
    private WeakHandler handler = new WeakHandler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (WatchPlaybackGroupFragment.this.clearScreen) {
                WatchPlaybackGroupFragment.this.seekBar.setMax((int)WatchPlaybackGroupFragment.this.mPlayer.getDuration());
                WatchPlaybackGroupFragment.this.seekBar.setEnabled(true);
                if (WatchPlaybackGroupFragment.this.mPlaying) {
                    int pos = (int)WatchPlaybackGroupFragment.this.mPlayer.getPosition();
                    int max = (int)WatchPlaybackGroupFragment.this.mPlayer.getDuration();
                    WatchPlaybackGroupFragment.this.seekBar.setProgress(pos);
                    WatchPlaybackGroupFragment.this.tvFullTime.setText((CharSequence)CommonUtil.converLongTimeToStr(max));
                    WatchPlaybackGroupFragment.this.tvCurrentTime.setText((CharSequence)CommonUtil.converLongTimeToStr(pos));
                    WatchPlaybackGroupFragment.this.seekBar.setSecondaryProgress((int)WatchPlaybackGroupFragment.this.mPlayer.getBufferedPosition());
                    if (WatchPlaybackGroupFragment.this.documentPresent != null) {
                        WatchPlaybackGroupFragment.this.documentPresent.setTime(WatchPlaybackGroupFragment.this.mPlayer.getPosition());
                    }
                }
            }
            return false;
        }
    });
    private boolean allowPicture;
    private boolean clearScreen = true;
    boolean testpiicture;
    CountDownTimer timerSeek = new CountDownTimer(5000L, 1000L){

        public void onTick(long millisUntilFinished) {
        }

        public void onFinish() {
            if (WatchPlaybackGroupFragment.this.groupSeekBar.getVisibility() == 0) {
                WatchPlaybackGroupFragment.this.groupSeekBar.setVisibility(8);
            }
        }
    };

    public static WatchPlaybackGroupFragment getInstance(ResponseRoomInfo info) {
        WatchPlaybackGroupFragment fragment = new WatchPlaybackGroupFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("responseRoomInfo", (Serializable)info);
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WatchPlaybackGroupFragment getInstance(Bundle bundle) {
        WatchPlaybackGroupFragment fragment = new WatchPlaybackGroupFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        VhSdk.getInstance().lastActivity = false;
        this.inflate = inflater.inflate(R.layout.fragment_watch_playback_group, container, false);
        Bundle bundle = this.getArguments();
        assert (bundle != null);
        this.roomInfo = (ResponseRoomInfo)bundle.getSerializable("responseRoomInfo");
        new WatchBackGroupPresenter(this, this, this, this.roomInfo);
        this.ivPlay = (ImageView)this.inflate.findViewById(R.id.iv_play);
        this.replay_vod_bg = (TextView)this.inflate.findViewById(R.id.replay_vod_bg);
        this.replay_vod_bg_view = this.inflate.findViewById(R.id.replay_vod_bg_view);
        this.frDoc = (FrameLayout)this.inflate.findViewById(R.id.doc_container);
        this.tvCurrentTime = (TextView)this.inflate.findViewById(R.id.tv_now_time);
        this.iv_watch_live_goods_num = (TextView)this.inflate.findViewById(R.id.goods_num);
        this.tvFullTime = (TextView)this.inflate.findViewById(R.id.tv_full_time);
        this.groupSeekBar = (Group)this.inflate.findViewById(R.id.group_bar);
        this.chatRecyclerView = (IChatPanelView)this.inflate.findViewById(R.id.recycle_view_chat);
        this.inflate.findViewById(R.id.iv_watch_vod_gift).setOnClickListener(v -> new VhGoodsListView((Context)this.mContext, this.roomInfo, this.getActivity()).setNumCallBack(new VhGoodsListView.NumCallback(){

            @Override
            public void callback(int num) {
                WatchPlaybackGroupFragment.this.iv_watch_live_goods_num.setText((CharSequence)(num + ""));
            }

            @Override
            public void openFloat(final GoodsResultBean.ListBean item) {
                PictureInPictureManager.getInstance().checkFloatingPermission(new IPictureInPictureListener.CheckFloatPermissionCallback(){

                    @Override
                    public void callback(boolean isOpen) {
                        if (null != WatchPlaybackGroupFragment.this.getActivity()) {
                            VhSdk.getInstance().vhallCallback.fullScreenGoods(item.getArticle_id() + "", WatchPlaybackGroupFragment.this.roomInfo.getSubject() + "", WatchPlaybackGroupFragment.this.roomInfo.getRoom_id() + "", WatchPlaybackGroupFragment.this.getActivity());
                            if (isOpen) {
                                VHMMKV.share().put(WatchPlaybackGroupFragment.PICTURE_PERMISSION, isOpen);
                                WatchPlaybackGroupFragment.this.openPicture(false);
                                WatchPlaybackGroupFragment.this.allowPicture = true;
                            }
                        }
                    }
                }, (Activity)WatchPlaybackGroupFragment.this.getActivity());
            }
        }).show());
        this.seekBar = (SeekBar)this.inflate.findViewById(R.id.seek_bar);
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new MySeekBarListener());
        this.playerView = (SurfaceView)this.inflate.findViewById(R.id.vod_player_view);
        this.playerViewLayoutParams = new ConstraintLayout.LayoutParams((ConstraintLayout.LayoutParams)this.playerView.getLayoutParams());
        this.playerView.setZOrderMediaOverlay(true);
        this.mPlayer = new VHVodPlayer((Context)this.getActivity());
        this.mPlayer.setDrawMode(1);
        this.mPlayer.setDisplay(this.playerView);
        this.mPlayer.seekto(this.getArguments().getLong("position", 0L));
        this.watchBackPresenter.initLive();
        this.inflate.findViewById(R.id.iv_check_picture).setOnClickListener(v -> PictureInPictureManager.getInstance().checkFloatingPermission(new IPictureInPictureListener.CheckFloatPermissionCallback(){

            @Override
            public void callback(boolean isOpen) {
                if (isOpen) {
                    VHMMKV.share().put(WatchPlaybackGroupFragment.PICTURE_PERMISSION, isOpen);
                    WatchPlaybackGroupFragment.this.openPicture(true);
                    WatchPlaybackGroupFragment.this.allowPicture = true;
                }
            }
        }, (Activity)this.getActivity()));
        this.handlePosition();
        this.playerView.setOnClickListener(v -> {
            this.clearScreen = !this.clearScreen;
            this.clearScreens();
        });
        this.inflate.findViewById(R.id.iv_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WatchPlaybackGroupFragment.this.back();
            }
        });
        this.ivPlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WatchPlaybackGroupFragment.this.showProgress();
                WatchPlaybackGroupFragment.this.watchBackPresenter.play();
            }
        });
        this.replay_vod_bg.setOnClickListener(v -> {
            this.showProgress();
            this.watchBackPresenter.play();
        });
        if (PictureInPictureManager.getInstance().isLoaded()) {
            IPictureInPictureListener.getInstance().registListenerToPip(new IPictureInPictureListener.PipOnclicCallback(){

                @Override
                public void callback(boolean showOrHide) {
                    if (WatchPlaybackGroupFragment.this.watchBackPresenter != null && !showOrHide) {
                        if (WatchPlaybackGroupFragment.this.playerView.getParent() == null || WatchPlaybackGroupFragment.this.playerView != null) {
                            // empty if block
                        }
                        WatchPlaybackGroupFragment.this.inflate.findViewById(R.id.iv_check_picture).setVisibility(0);
                        WatchPlaybackGroupFragment.this.allowPicture = false;
                    }
                }
            });
        }
        IPictureInPictureListener.getInstance().sendNewRoomMessageToPip(true);
        IPictureInPictureListener.getInstance().sendMessageToPip(false);
        this.getGoodsData();
        return this.inflate;
    }

    private void getGoodsData() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.roomInfo != null) {
            params.put("room_id", this.roomInfo.getRoom_id());
        }
        CommonManagerNetWrapper.getGoodsList(params, new CallBack<GoodsResultBean>(){

            @Override
            public void onSuccess(GoodsResultBean result) {
                if (result != null) {
                    if (result.getTotal() > 0) {
                        WatchPlaybackGroupFragment.this.iv_watch_live_goods_num.setText((CharSequence)("" + result.getTotal()));
                    } else {
                        WatchPlaybackGroupFragment.this.iv_watch_live_goods_num.setVisibility(8);
                    }
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhLog.d(msg);
            }
        });
    }

    private void openPicture(boolean isFinish) {
        if (PictureInPictureManager.getInstance().isLoaded() && VHMMKV.share().decodeBoolean(PICTURE_PERMISSION).booleanValue()) {
            Bundle bundle = new Bundle();
            if (this.roomInfo != null) {
                bundle.putBoolean("pause", this.testpiicture);
                PictureInPictureConstance.PIP_ROOM_ID = this.roomInfo.getRoom_id() + "";
                PictureInPictureConstance.PIP_ACCESS_TOKEN = this.roomInfo.getPaas_access_token() + "";
                PictureInPictureConstance.PIP_IL_ID = this.roomInfo.getIl_id() + "";
                PictureInPictureConstance.ROLE_NAME = this.roomInfo.getRole_name() + "";
                PictureInPictureConstance.ROOMINFO = this.roomInfo;
                if (this.seekBar != null) {
                    bundle.putLong("seekPostion", (long)this.seekBar.getProgress());
                }
            }
            PictureInPictureManager.getInstance().startVodFloating((Activity)this.getActivity(), bundle);
            if (isFinish) {
                Objects.requireNonNull(this.getActivity()).finish();
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        VhSdk.getInstance().closePIPView((Context)this.getActivity());
        this.watchBackPresenter.onResume();
        IPictureInPictureListener.getInstance().sendMessageToPip(false);
    }

    public void onStop() {
        super.onStop();
        this.watchBackPresenter.onStop();
        IPictureInPictureListener.getInstance().sendMessageToPip(true);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    @Override
    public void startLive() {
        if (this.mCallback != null) {
            this.watchBackPresenter.leaveRoom();
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    WatchPlaybackGroupFragment.this.baseShowToast("\u4e3b\u64ad\u5f00\u59cb\u76f4\u64ad");
                    WatchPlaybackGroupFragment.this.mCallback.onWatchChange();
                }
            }, 1000L);
        }
    }

    private void handlePosition() {
        if (this.service != null) {
            return;
        }
        this.service = new ScheduledThreadPoolExecutor(1);
        this.service.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                WatchPlaybackGroupFragment.this.handler.sendEmptyMessage(0);
            }
        }, 0L, 150L, TimeUnit.MILLISECONDS);
    }

    @Override
    public VHVodPlayer getPlay() {
        return this.mPlayer;
    }

    @Override
    public void setPlayBtn(boolean isPlaying, int state) {
        this.mPlaying = isPlaying;
        switch (state) {
            case 0: {
                this.ivPlay.setBackgroundResource(R.drawable.play_back_icon_pause_bro);
                this.replay_vod_bg.setVisibility(8);
                this.replay_vod_bg_view.setVisibility(8);
                break;
            }
            case 1: {
                this.ivPlay.setBackgroundResource(R.drawable.play_back_icon_start_bro);
                this.replay_vod_bg.setVisibility(8);
                this.replay_vod_bg_view.setVisibility(8);
                break;
            }
            case 2: {
                this.ivPlay.setBackgroundResource(R.drawable.play_back_icon_start_bro);
                this.replay_vod_bg.setVisibility(0);
                this.replay_vod_bg_view.setVisibility(0);
                break;
            }
        }
    }

    public void clearScreens() {
        try {
            if (!this.clearScreen) {
                this.inflate.findViewById(R.id.iv_check_picture).setVisibility(4);
                this.inflate.findViewById(R.id.iv_play).setVisibility(4);
                this.inflate.findViewById(R.id.tv_now_time).setVisibility(4);
                this.inflate.findViewById(R.id.seek_bar).setVisibility(4);
                this.inflate.findViewById(R.id.tv_full_time).setVisibility(4);
            } else {
                this.inflate.findViewById(R.id.iv_check_picture).setVisibility(0);
                this.inflate.findViewById(R.id.iv_play).setVisibility(0);
                this.inflate.findViewById(R.id.tv_now_time).setVisibility(0);
                this.inflate.findViewById(R.id.seek_bar).setVisibility(0);
                this.inflate.findViewById(R.id.tv_full_time).setVisibility(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showChat(int visible) {
        this.inflate.findViewById(R.id.recycle_view_chat).setVisibility(visible);
        if (visible == 0) {
            this.chatView = (ChatView)this.inflate.findViewById(R.id.chat_view);
        }
    }

    @Override
    public void showProgress() {
        this.inflate.findViewById(R.id.player_loading_view).setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.inflate.findViewById(R.id.player_loading_view).setVisibility(8);
    }

    @Override
    public void notifyDataChangedChat(VssMessageChatData data) {
        this.chatRecyclerView.addMessage(data);
    }

    @Override
    public void setPresenter(IDocumentContract.IDocumentPresent presenter) {
        this.documentPresent = presenter;
    }

    @Override
    public void showDoc() {
        if (this.frDoc == null) {
            return;
        }
        this.frDoc.setVisibility(0);
        this.playerViewLayoutParams.width = 433;
        this.playerViewLayoutParams.height = 251;
        this.playerViewLayoutParams.setMargins(20, 20, 20, 20);
        this.playerView.setLayoutParams((ViewGroup.LayoutParams)this.playerViewLayoutParams);
    }

    @Override
    public void hideDoc() {
        if (this.frDoc == null) {
            return;
        }
        this.frDoc.setVisibility(8);
        this.playerViewLayoutParams.setMargins(0, 0, 0, 0);
        this.playerViewLayoutParams.width = -1;
        this.playerViewLayoutParams.height = -1;
        this.playerView.setLayoutParams((ViewGroup.LayoutParams)this.playerViewLayoutParams);
    }

    @Override
    public void setDocView(DocumentView view) {
        if (this.frDoc == null || view == null) {
            return;
        }
        this.frDoc.removeAllViews();
        this.frDoc.addView((View)view);
    }

    @Override
    public void setPresenter(IBaseWatchGroupContract.IBaseWatchPresenter presenter) {
        this.watchBackPresenter = (IWatchBackGroupContract.IWatchBackPresenter)presenter;
    }

    @Override
    public void showToast(String content) {
        this.baseShowToast(content);
    }

    @Override
    public void setPresenter(IChatContract.IChatPresenter presenter) {
        this.chatPresenter = presenter;
    }

    @Override
    public void upDateStatus(boolean canChat, String hint) {
        if (this.chatView != null) {
            this.chatView.setChatAble(canChat, hint);
        }
    }

    @Override
    public void back() {
        if (PermissionUtils.checkPermission((Context)this.getActivity())) {
            this.openPicture(true);
        } else {
            Objects.requireNonNull(this.getActivity()).finish();
        }
    }

    @Override
    public void onDestroy() {
        if (this.service != null) {
            this.service.shutdown();
        }
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        this.watchBackPresenter.leaveRoom();
        super.onDestroy();
    }

    @Override
    public Bundle call(String method, @Nullable String arg, @Nullable Bundle extras) {
        if (TextUtils.equals((CharSequence)"back", (CharSequence)method)) {
            this.back();
        }
        return super.call(method, arg, extras);
    }

    public static interface Callback {
        public void onWatchChange();
    }

    class MySeekBarListener
    implements SeekBar.OnSeekBarChangeListener {
        MySeekBarListener() {
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            WatchPlaybackGroupFragment.this.tvCurrentTime.setText((CharSequence)CommonUtil.converLongTimeToStr(progress));
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            WatchPlaybackGroupFragment.this.mPlayer.seekto((long)seekBar.getProgress());
            if (WatchPlaybackGroupFragment.this.documentPresent != null) {
                WatchPlaybackGroupFragment.this.documentPresent.seekTo(seekBar.getProgress());
            }
        }
    }
}

