/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.watchplayback;

import android.content.Context;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Group;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.BaseFragment;
import com.vhall.appui.baselib.utils.CommonUtil;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.utils.handler.WeakHandler;
import com.vhall.appui.watchplayback.WatchPlaybackGroupFragment;
import com.vhall.appui.watchplayback.present.IBaseWatchContract;
import com.vhall.appui.watchplayback.present.IWatchBackContract;
import com.vhall.appui.watchplayback.present.WatchBackPresenter;
import com.vhall.player.vod.VodPlayerView;
import com.vhall.vod.VHVodPlayer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WatchPlaybackFragment
extends BaseFragment
implements IWatchBackContract.IWatchBackView {
    public static final int STATE_PLAYING = 0;
    public static final int STATE_PAUSE = 1;
    public static final int STATE_COMP = 2;
    private Callback mCallback;
    private ResponseRoomInfo roomInfo;
    private IWatchBackContract.IWatchBackPresenter watchBackPresenter;
    private ConstraintLayout.LayoutParams playerViewLayoutParams;
    private ImageView ivPlay;
    private VodPlayerView playerView;
    private VHVodPlayer mPlayer;
    private TextView tvFullTime;
    private TextView tvCurrentTime;
    private ScheduledThreadPoolExecutor service;
    private SeekBar seekBar;
    private View inflate;
    private CheckBox clear;
    private boolean mPlaying = false;
    private Group groupSeekBar;
    private WeakHandler handler = new WeakHandler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            WatchPlaybackFragment.this.seekBar.setMax((int)WatchPlaybackFragment.this.mPlayer.getDuration());
            WatchPlaybackFragment.this.seekBar.setEnabled(true);
            if (WatchPlaybackFragment.this.mPlaying) {
                int pos = (int)WatchPlaybackFragment.this.mPlayer.getPosition();
                int max = (int)WatchPlaybackFragment.this.mPlayer.getDuration();
                WatchPlaybackFragment.this.seekBar.setProgress(pos);
                WatchPlaybackFragment.this.tvFullTime.setText((CharSequence)CommonUtil.converLongTimeToStr(max));
                WatchPlaybackFragment.this.tvCurrentTime.setText((CharSequence)CommonUtil.converLongTimeToStr(pos));
                WatchPlaybackFragment.this.seekBar.setSecondaryProgress((int)WatchPlaybackFragment.this.mPlayer.getBufferedPosition());
            }
            return false;
        }
    });
    CountDownTimer timerSeek = new CountDownTimer(5000L, 1000L){

        public void onTick(long millisUntilFinished) {
        }

        public void onFinish() {
            if (WatchPlaybackFragment.this.groupSeekBar.getVisibility() == 0) {
                WatchPlaybackFragment.this.groupSeekBar.setVisibility(8);
            }
        }
    };

    public static WatchPlaybackGroupFragment getInstance(Bundle bundle) {
        WatchPlaybackGroupFragment fragment = new WatchPlaybackGroupFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.inflate = inflater.inflate(R.layout.fragment_watch_playback, container, false);
        Bundle bundle = this.getArguments();
        assert (bundle != null);
        this.roomInfo = (ResponseRoomInfo)bundle.getSerializable("responseRoomInfo");
        this.ivPlay = (ImageView)this.inflate.findViewById(R.id.iv_play);
        this.playerView = (VodPlayerView)this.inflate.findViewById(R.id.vod_player_view);
        this.playerViewLayoutParams = new ConstraintLayout.LayoutParams((ConstraintLayout.LayoutParams)this.playerView.getLayoutParams());
        this.tvCurrentTime = (TextView)this.inflate.findViewById(R.id.tv_now_time);
        this.tvFullTime = (TextView)this.inflate.findViewById(R.id.tv_full_time);
        this.clear = (CheckBox)this.inflate.findViewById(R.id.cb_clear);
        this.groupSeekBar = (Group)this.inflate.findViewById(R.id.group_bar);
        this.seekBar = (SeekBar)this.inflate.findViewById(R.id.seek_bar);
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new MySeekBarListener());
        this.mPlayer = new VHVodPlayer((Context)this.getActivity());
        this.mPlayer.setDrawMode(1);
        this.mPlayer.setDisplay(this.playerView);
        this.watchBackPresenter.initLive();
        this.handlePosition();
        this.timerSeek.start();
        this.inflate.findViewById(R.id.iv_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WatchPlaybackFragment.this.back();
            }
        });
        this.ivPlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WatchPlaybackFragment.this.showProgress();
                WatchPlaybackFragment.this.watchBackPresenter.play();
            }
        });
        this.inflate.findViewById(R.id.view_root).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WatchPlaybackFragment.this.timerSeek.cancel();
                if (WatchPlaybackFragment.this.groupSeekBar.getVisibility() == 8) {
                    WatchPlaybackFragment.this.groupSeekBar.setVisibility(0);
                    WatchPlaybackFragment.this.timerSeek.start();
                } else {
                    WatchPlaybackFragment.this.groupSeekBar.setVisibility(8);
                }
            }
        });
        new WatchBackPresenter(this, this.roomInfo);
        return this.inflate;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    @Override
    public void startLive() {
        if (this.mCallback != null) {
            this.watchBackPresenter.leaveRoom();
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    WatchPlaybackFragment.this.baseShowToast("\u4e3b\u64ad\u5f00\u59cb\u76f4\u64ad");
                    WatchPlaybackFragment.this.mCallback.onWatchChange();
                }
            }, 1000L);
        }
    }

    private void handlePosition() {
        if (this.service != null) {
            return;
        }
        this.service = new ScheduledThreadPoolExecutor(1);
        this.service.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                WatchPlaybackFragment.this.handler.sendEmptyMessage(0);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public VHVodPlayer getPlay() {
        return this.mPlayer;
    }

    @Override
    public void setPlayBtn(boolean isPlaying, int state) {
        this.mPlaying = isPlaying;
        switch (state) {
            case 0: {
                this.ivPlay.setBackgroundResource(R.drawable.play_back_icon_pause_bro);
                break;
            }
            case 1: {
                this.ivPlay.setBackgroundResource(R.drawable.play_back_icon_start_bro);
                break;
            }
            case 2: {
                this.ivPlay.setBackgroundResource(R.drawable.play_back_icon_replay);
                break;
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.watchBackPresenter.onResume();
    }

    public void onStop() {
        super.onStop();
        this.watchBackPresenter.onStop();
    }

    @Override
    public void showProgress() {
        this.inflate.findViewById(R.id.player_loading_view).setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.inflate.findViewById(R.id.player_loading_view).setVisibility(8);
    }

    @Override
    public void setPresenter(IBaseWatchContract.IBaseWatchPresenter presenter) {
        this.watchBackPresenter = (IWatchBackContract.IWatchBackPresenter)presenter;
    }

    @Override
    public void showToast(String content) {
        this.baseShowToast(content);
    }

    @Override
    public void back() {
        this.getActivity().finish();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.service != null) {
            this.service.shutdown();
        }
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        this.watchBackPresenter.leaveRoom();
    }

    public static interface Callback {
        public void onWatchChange();
    }

    class MySeekBarListener
    implements SeekBar.OnSeekBarChangeListener {
        MySeekBarListener() {
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            WatchPlaybackFragment.this.tvCurrentTime.setText((CharSequence)CommonUtil.converLongTimeToStr(progress));
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            WatchPlaybackFragment.this.mPlayer.seekto((long)seekBar.getProgress());
        }
    }
}

