/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.sensitivewords;

import android.text.TextUtils;
import com.vhall.appui.baselib.core.BaseServiceImpl;
import com.vhall.appui.baselib.service.sensitivewords.IFilterSensitiveWordsListener;
import com.vhall.appui.baselib.service.sensitivewords.IFilterSensitiveWordsResultListener;
import com.vhall.appui.baselib.service.sensitivewords.ISensitiveWordsService;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.service.IMessage;
import com.vhall.appui.sensitivewords.bean.RequestReportSensitiveBean;
import com.vhall.appui.sensitivewords.network.SensitiveNetWrapper;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SensitiveWordsImpl
extends BaseServiceImpl
implements ISensitiveWordsService {
    private String[] keyWords = new String[0];
    private List<IFilterSensitiveWordsListener> mFakeMessageListeners = new ArrayList<IFilterSensitiveWordsListener>();

    @Override
    public void addOnFilterSensitiveWordsListener(IFilterSensitiveWordsListener listener) {
    }

    @Override
    public void removeFilterSensitiveWordsListener(IFilterSensitiveWordsListener listener) {
    }

    @Override
    public void requestSensitiveWords() {
        this.keyWords = new String[0];
        SensitiveNetWrapper.getSensitiveWords(new CallBack(){

            public void onSuccess(Object s) {
                if (s == null) {
                    return;
                }
                try {
                    JSONObject jsonObject = new JSONObject(s.toString());
                    String result = jsonObject.optString("data");
                    if (!TextUtils.isEmpty((CharSequence)result)) {
                        SensitiveWordsImpl.access$002(SensitiveWordsImpl.this, result.split(","));
                        for (int i = 0; i < SensitiveWordsImpl.this.keyWords.length; ++i) {
                            ((SensitiveWordsImpl)SensitiveWordsImpl.this).keyWords[i] = SensitiveWordsImpl.this.keyWords[i].toLowerCase();
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }

    @Override
    public void filterSensitiveWords(final String message, final IFilterSensitiveWordsResultListener listener) {
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(@NonNull ObservableEmitter<String> emitter) throws Exception {
                for (String k : SensitiveWordsImpl.this.keyWords) {
                    if (!message.toLowerCase().contains(k)) continue;
                    emitter.onNext((Object)k);
                    emitter.onComplete();
                    if (listener == null) break;
                    listener.showToast("\u5305\u542b\u654f\u611f\u8bcd");
                    break;
                }
                emitter.onNext((Object)"");
                emitter.onComplete();
            }
        }).observeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doOnNext((Consumer)new Consumer<String>(){

            public void accept(String s) throws Exception {
                listener.onFilterResult(TextUtils.isEmpty((CharSequence)s), message, s);
                if (!TextUtils.isEmpty((CharSequence)s)) {
                    RequestReportSensitiveBean bean = new RequestReportSensitiveBean(message);
                    SensitiveNetWrapper.reportSensitiveWords(bean);
                }
            }
        }).subscribe();
    }

    private void preFilterSensitiveWords(String message) {
        IMessage.SimpleMessage fakeMessage = new IMessage.SimpleMessage(message);
        for (int i = this.mFakeMessageListeners.size() - 1; i >= 0; --i) {
            this.mFakeMessageListeners.get(i).onPreFilterMessage(fakeMessage);
        }
    }

    @Override
    public String getServiceName() {
        return "sensitive_words";
    }

    @Override
    public String getVersion() {
        return "1.2.9";
    }

    static /* synthetic */ String[] access$002(SensitiveWordsImpl x0, String[] x1) {
        x0.keyWords = x1;
        return x1;
    }
}

