/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.scrolltext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.contrarywind.adapter.WheelAdapter;
import com.contrarywind.interfaces.IPickerViewData;
import com.contrarywind.listener.OnItemSelectedListener;
import com.contrarywind.view.WheelView;
import com.vhall.appui.baselib.R;
import com.vhall.appui.scrolltext.MyInertiaTimerTask;
import com.vhall.appui.scrolltext.MyLoopViewGestureListener;
import com.vhall.appui.scrolltext.MyMessageHandler;
import com.vhall.appui.scrolltext.MySmoothScrollTimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MyWheelView
extends View {
    private static final String[] TIME_NUM = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09"};
    private WheelView.DividerType dividerType;
    private Context context;
    private Handler handler;
    private GestureDetector gestureDetector;
    private OnItemSelectedListener onItemSelectedListener;
    private boolean isOptions = false;
    private boolean isCenterLabel = true;
    private ScheduledExecutorService mExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> mFuture;
    private Paint paintOuterText;
    private Paint paintCenterText;
    private Paint paintIndicator;
    private WheelAdapter adapter;
    private String label;
    private int textSize;
    private int maxTextWidth;
    private int maxTextHeight;
    private int textXOffset;
    private float itemHeight;
    private Typeface typeface = Typeface.MONOSPACE;
    private int textColorOut;
    private int textColorCenter;
    private int dividerColor;
    private int dividerWidth;
    private float lineSpacingMultiplier = 1.7f;
    private boolean isLoop;
    private float firstLineY;
    private float secondLineY;
    private float centerY;
    private float totalScrollY;
    private int initPosition;
    private int selectedItem;
    private int preCurrentIndex;
    private int itemsVisible = 11;
    private int measuredHeight;
    private int measuredWidth;
    private int radius;
    private int mOffset = 0;
    private float previousY = 0.0f;
    private long startTime = 0L;
    private static final int VELOCITY_FLING = 5;
    private int widthMeasureSpec;
    private int mGravity = 17;
    private int drawCenterContentStart = 0;
    private int drawOutContentStart = 0;
    private static final float SCALE_CONTENT = 1.0f;
    private float CENTER_CONTENT_OFFSET;
    private boolean isAlphaGradient = false;
    private int count = 0;

    public MyWheelView(Context context) {
        this(context, null);
    }

    public MyWheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.textSize = this.getResources().getDimensionPixelSize(R.dimen.pickerview_textsize);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float density = dm.density;
        if (density < 1.0f) {
            this.CENTER_CONTENT_OFFSET = 2.4f;
        } else if (1.0f <= density && density < 2.0f) {
            this.CENTER_CONTENT_OFFSET = 4.0f;
        } else if (2.0f <= density && density < 3.0f) {
            this.CENTER_CONTENT_OFFSET = 6.0f;
        } else if (density >= 3.0f) {
            this.CENTER_CONTENT_OFFSET = density * 2.5f;
        }
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.pickerview, 0, 0);
            this.mGravity = a.getInt(R.styleable.pickerview_wheelview_gravity, 17);
            this.textColorOut = a.getColor(R.styleable.pickerview_wheelview_textColorOut, -5723992);
            this.textColorCenter = a.getColor(R.styleable.pickerview_wheelview_textColorCenter, -14013910);
            this.dividerColor = a.getColor(R.styleable.pickerview_wheelview_dividerColor, -2763307);
            this.dividerWidth = a.getDimensionPixelSize(R.styleable.pickerview_wheelview_dividerWidth, 2);
            this.textSize = a.getDimensionPixelOffset(R.styleable.pickerview_wheelview_textSize, this.textSize);
            this.lineSpacingMultiplier = a.getFloat(R.styleable.pickerview_wheelview_lineSpacingMultiplier, this.lineSpacingMultiplier);
            a.recycle();
        }
        this.judgeLineSpace();
        this.initLoopView(context);
    }

    private void judgeLineSpace() {
        if (this.lineSpacingMultiplier < 1.0f) {
            this.lineSpacingMultiplier = 1.0f;
        } else if (this.lineSpacingMultiplier > 4.0f) {
            this.lineSpacingMultiplier = 4.0f;
        }
    }

    private void initLoopView(Context context) {
        this.context = context;
        this.handler = new MyMessageHandler(this);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MyLoopViewGestureListener(this));
        this.gestureDetector.setIsLongpressEnabled(false);
        this.isLoop = true;
        this.totalScrollY = 0.0f;
        this.initPosition = -1;
        this.initPaints();
    }

    private void initPaints() {
        this.paintOuterText = new Paint();
        this.paintOuterText.setColor(this.textColorOut);
        this.paintOuterText.setAntiAlias(true);
        this.paintOuterText.setTypeface(this.typeface);
        this.paintOuterText.setTextSize(20.0f);
        this.paintCenterText = new Paint();
        this.paintCenterText.setColor(this.textColorCenter);
        this.paintCenterText.setAntiAlias(true);
        this.paintCenterText.setTextScaleX(1.1f);
        this.paintCenterText.setTypeface(this.typeface);
        this.paintCenterText.setTextSize(13.0f);
        this.paintIndicator = new Paint();
        this.paintIndicator.setColor(this.dividerColor);
        this.paintIndicator.setAntiAlias(true);
        this.setLayerType(1, null);
    }

    private void reMeasure() {
        if (this.adapter == null) {
            return;
        }
        this.measureTextWidthHeight();
        int halfCircumference = (int)(this.itemHeight * (float)(this.itemsVisible - 1));
        this.measuredHeight = (int)((double)(halfCircumference * 2) / Math.PI);
        this.radius = (int)((double)halfCircumference / Math.PI);
        this.measuredWidth = View.MeasureSpec.getSize((int)this.widthMeasureSpec);
        this.firstLineY = ((float)this.measuredHeight - this.itemHeight) / 2.0f;
        this.secondLineY = ((float)this.measuredHeight + this.itemHeight) / 2.0f;
        this.centerY = this.secondLineY - (this.itemHeight - (float)this.maxTextHeight) / 2.0f - this.CENTER_CONTENT_OFFSET;
        if (this.initPosition == -1) {
            this.initPosition = this.isLoop ? (this.adapter.getItemsCount() + 1) / 2 : 0;
        }
        this.preCurrentIndex = this.initPosition;
    }

    private void measureTextWidthHeight() {
        Rect rect = new Rect();
        for (int i = 0; i < this.adapter.getItemsCount(); ++i) {
            String s1 = this.getContentText(this.adapter.getItem(i));
            this.paintCenterText.getTextBounds(s1, 0, s1.length(), rect);
            int textWidth = rect.width();
            if (textWidth <= this.maxTextWidth) continue;
            this.maxTextWidth = textWidth;
        }
        this.paintCenterText.getTextBounds("\u661f\u671f", 0, 2, rect);
        this.maxTextHeight = rect.height() + 2;
        this.itemHeight = this.lineSpacingMultiplier * (float)this.maxTextHeight;
    }

    public void smoothScroll(ACTION action) {
        this.cancelFuture();
        if (action == ACTION.FLING || action == ACTION.DAGGLE) {
            this.mOffset = (int)((this.totalScrollY % this.itemHeight + this.itemHeight) % this.itemHeight);
            this.mOffset = (float)this.mOffset > this.itemHeight / 2.0f ? (int)(this.itemHeight - (float)this.mOffset) : -this.mOffset;
        }
        this.mOffset = (int)this.itemHeight;
        ++this.count;
        if (this.count > this.getItemsCount()) {
            this.count = 0;
            this.totalScrollY = 0.0f;
        }
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new MySmoothScrollTimerTask(this, this.mOffset), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public final void scrollBy(float velocityY) {
        this.cancelFuture();
        this.mOffset = (int)this.itemHeight + 10;
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new MyInertiaTimerTask(this, this.mOffset), 0L, 5L, TimeUnit.MILLISECONDS);
    }

    public void cancelFuture() {
        if (this.mFuture != null && !this.mFuture.isCancelled()) {
            this.mFuture.cancel(true);
            this.mFuture = null;
        }
    }

    public final void setCyclic(boolean cyclic) {
        this.isLoop = cyclic;
    }

    public final void setTypeface(Typeface font) {
        this.typeface = font;
        this.paintOuterText.setTypeface(this.typeface);
        this.paintCenterText.setTypeface(this.typeface);
    }

    public final void setTextSize(float size) {
        if (size > 0.0f) {
            this.textSize = (int)(this.context.getResources().getDisplayMetrics().density * size);
            this.paintOuterText.setTextSize((float)this.textSize);
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    public final void setCurrentItem(int currentItem) {
        this.selectedItem = currentItem;
        this.initPosition = currentItem;
        this.totalScrollY = 0.0f;
        this.invalidate();
    }

    public final void setOnItemSelectedListener(OnItemSelectedListener OnItemSelectedListener2) {
        this.onItemSelectedListener = OnItemSelectedListener2;
    }

    public final void setAdapter(WheelAdapter adapter) {
        this.adapter = adapter;
        this.reMeasure();
        this.invalidate();
    }

    public void setItemsVisibleCount(int visibleCount) {
        if (visibleCount % 2 == 0) {
            ++visibleCount;
        }
        this.itemsVisible = visibleCount + 2;
    }

    public void setAlphaGradient(boolean alphaGradient) {
        this.isAlphaGradient = alphaGradient;
    }

    public final WheelAdapter getAdapter() {
        return this.adapter;
    }

    public final int getCurrentItem() {
        if (this.adapter == null) {
            return 0;
        }
        if (this.isLoop && (this.selectedItem < 0 || this.selectedItem >= this.adapter.getItemsCount())) {
            return Math.max(0, Math.min(Math.abs(Math.abs(this.selectedItem) - this.adapter.getItemsCount()), this.adapter.getItemsCount() - 1));
        }
        return Math.max(0, Math.min(this.selectedItem, this.adapter.getItemsCount() - 1));
    }

    public final void onItemSelected() {
        if (this.onItemSelectedListener != null) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MyWheelView.this.onItemSelectedListener.onItemSelected(MyWheelView.this.getCurrentItem());
                }
            }, 200L);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.adapter == null) {
            return;
        }
        this.initPosition = Math.min(Math.max(0, this.initPosition), this.adapter.getItemsCount() - 1);
        int change = (int)(this.totalScrollY / this.itemHeight);
        try {
            this.preCurrentIndex = this.initPosition + change % this.adapter.getItemsCount();
        }
        catch (ArithmeticException e) {
            Log.e((String)"WheelView", (String)"\u51fa\u9519\u4e86\uff01adapter.getItemsCount() == 0\uff0c\u8054\u52a8\u6570\u636e\u4e0d\u5339\u914d");
        }
        if (!this.isLoop) {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = 0;
            }
            if (this.preCurrentIndex > this.adapter.getItemsCount() - 1) {
                this.preCurrentIndex = this.adapter.getItemsCount() - 1;
            }
        } else {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = this.adapter.getItemsCount() + this.preCurrentIndex;
            }
            if (this.preCurrentIndex > this.adapter.getItemsCount() - 1) {
                this.preCurrentIndex -= this.adapter.getItemsCount();
            }
        }
        float itemHeightOffset = this.totalScrollY % this.itemHeight;
        if (this.dividerType == WheelView.DividerType.WRAP) {
            float startX = TextUtils.isEmpty((CharSequence)this.label) ? (float)((this.measuredWidth - this.maxTextWidth) / 2 - 12) : (float)((this.measuredWidth - this.maxTextWidth) / 4 - 12);
            if (startX <= 0.0f) {
                startX = 10.0f;
            }
            float endX = (float)this.measuredWidth - startX;
            canvas.drawLine(startX, this.firstLineY, endX, this.firstLineY, this.paintIndicator);
            canvas.drawLine(startX, this.secondLineY, endX, this.secondLineY, this.paintIndicator);
        } else if (this.dividerType == WheelView.DividerType.CIRCLE) {
            // empty if block
        }
        if (!TextUtils.isEmpty((CharSequence)this.label) && this.isCenterLabel) {
            int drawRightContentStart = this.measuredWidth - this.getTextWidth(this.paintCenterText, this.label);
            canvas.drawText(this.label, (float)drawRightContentStart - this.CENTER_CONTENT_OFFSET, this.centerY, this.paintCenterText);
        }
        for (int counter = 0; counter < this.itemsVisible; ++counter) {
            float Y;
            String showText;
            int index = this.preCurrentIndex - (this.itemsVisible / 2 - counter);
            if (this.isLoop) {
                index = this.getLoopMappingIndex(index);
                showText = this.adapter.getItem(index);
            } else {
                showText = index < 0 ? "" : (index > this.adapter.getItemsCount() - 1 ? "" : this.adapter.getItem(index));
            }
            canvas.save();
            double radian = (this.itemHeight * (float)counter - itemHeightOffset) / (float)this.radius;
            float angle = (float)(90.0 - radian / Math.PI * 180.0);
            if (angle > 90.0f || angle < -90.0f) {
                canvas.restore();
                continue;
            }
            String contentText = !this.isCenterLabel && !TextUtils.isEmpty((CharSequence)this.label) && !TextUtils.isEmpty((CharSequence)this.getContentText(showText)) ? this.getContentText(showText) + this.label : this.getContentText(showText);
            float offsetCoefficient = (float)Math.pow(Math.abs(angle) / 90.0f, 2.2);
            this.reMeasureTextSize(contentText);
            this.measuredCenterContentStart(contentText);
            this.measuredOutContentStart(contentText);
            float translateY = (float)((double)this.radius - Math.cos(radian) * (double)this.radius - Math.sin(radian) * (double)this.maxTextHeight / 2.0);
            canvas.translate(0.0f, translateY);
            if (translateY <= this.firstLineY && (float)this.maxTextHeight + translateY >= this.firstLineY) {
                LinearGradient linearGradient = new LinearGradient(0.0f, 0.0f, 0.0f, 40.0f, -1, -16777216, Shader.TileMode.CLAMP);
                this.paintOuterText.setShader((Shader)linearGradient);
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.firstLineY - translateY);
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                Y = (float)this.maxTextHeight - this.CENTER_CONTENT_OFFSET;
                canvas.drawText(contentText, (float)this.drawCenterContentStart, Y, this.paintOuterText);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.firstLineY - translateY, (float)this.measuredWidth, (float)((int)this.itemHeight));
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight, this.paintCenterText);
                canvas.restore();
            } else if (translateY <= this.secondLineY && (float)this.maxTextHeight + translateY >= this.secondLineY) {
                LinearGradient linearGradient = new LinearGradient(0.0f, 20.0f, 0.0f, 50.0f, -16777216, -1, Shader.TileMode.CLAMP);
                this.paintOuterText.setShader((Shader)linearGradient);
                canvas.save();
                canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.secondLineY - translateY);
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                Y = (float)this.maxTextHeight - this.CENTER_CONTENT_OFFSET;
                canvas.drawText(contentText, (float)this.drawCenterContentStart, Y, this.paintCenterText);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0.0f, this.secondLineY - translateY, (float)this.measuredWidth, (float)((int)this.itemHeight));
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight, this.paintOuterText);
                canvas.restore();
            } else if (translateY >= this.firstLineY && (float)this.maxTextHeight + translateY <= this.secondLineY) {
                float Y2 = (float)this.maxTextHeight - this.CENTER_CONTENT_OFFSET;
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight, this.paintCenterText);
                this.selectedItem = this.preCurrentIndex - (this.itemsVisible / 2 - counter);
            } else {
                LinearGradient linearGradient = new LinearGradient(0.0f, 15.0f, 0.0f, 50.0f, -16777216, -1, Shader.TileMode.CLAMP);
                this.paintOuterText.setShader((Shader)linearGradient);
                canvas.save();
                canvas.clipRect(0, 0, this.measuredWidth, (int)this.itemHeight);
                canvas.scale(1.0f, (float)Math.sin(radian) * 1.0f);
                canvas.drawText(contentText, (float)this.drawCenterContentStart, (float)this.maxTextHeight, this.paintOuterText);
                canvas.restore();
            }
            canvas.restore();
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    private void setOutPaintStyle(float offsetCoefficient, float angle) {
        float DEFAULT_TEXT_TARGET_SKEW_X = 0.0f;
        int multiplier = 0;
        if (this.textXOffset > 0) {
            multiplier = 1;
        } else if (this.textXOffset < 0) {
            multiplier = -1;
        }
        int alpha = this.isAlphaGradient ? (int)((90.0f - Math.abs(angle)) / 90.0f * 255.0f) : 255;
        this.paintOuterText.setAlpha(alpha);
    }

    private void reMeasureTextSize(String contentText) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(contentText, 0, contentText.length(), rect);
        int width = rect.width();
        int size = this.textSize;
        while (width > this.measuredWidth) {
            this.paintCenterText.setTextSize((float)(--size));
            this.paintCenterText.getTextBounds(contentText, 0, contentText.length(), rect);
            width = rect.width();
        }
        this.paintOuterText.setTextSize((float)size);
    }

    private int getLoopMappingIndex(int index) {
        if (index < 0) {
            index += this.adapter.getItemsCount();
            index = this.getLoopMappingIndex(index);
        } else if (index > this.adapter.getItemsCount() - 1) {
            index -= this.adapter.getItemsCount();
            index = this.getLoopMappingIndex(index);
        }
        return index;
    }

    private String getContentText(Object item) {
        if (item == null) {
            return "";
        }
        if (item instanceof IPickerViewData) {
            return ((IPickerViewData)item).getPickerViewText();
        }
        if (item instanceof Integer) {
            return this.getFixNum((Integer)item);
        }
        return item.toString();
    }

    private String getFixNum(int timeNum) {
        return timeNum >= 0 && timeNum < 10 ? TIME_NUM[timeNum] : String.valueOf(timeNum);
    }

    private void measuredCenterContentStart(String content) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(content, 0, content.length(), rect);
        switch (this.mGravity) {
            case 17: {
                if (this.isOptions || this.label == null || this.label.equals("") || !this.isCenterLabel) {
                    this.drawCenterContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                    break;
                }
                this.drawCenterContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.25);
                break;
            }
            case 3: {
                this.drawCenterContentStart = 0;
                break;
            }
            case 5: {
                this.drawCenterContentStart = this.measuredWidth - rect.width() - (int)this.CENTER_CONTENT_OFFSET;
            }
        }
    }

    private void measuredOutContentStart(String content) {
        Rect rect = new Rect();
        this.paintOuterText.getTextBounds(content, 0, content.length(), rect);
        switch (this.mGravity) {
            case 17: {
                if (this.isOptions || this.label == null || this.label.equals("") || !this.isCenterLabel) {
                    this.drawOutContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                    break;
                }
                this.drawOutContentStart = (int)((double)(this.measuredWidth - rect.width()) * 0.25);
                break;
            }
            case 3: {
                this.drawOutContentStart = 0;
                break;
            }
            case 5: {
                this.drawOutContentStart = this.measuredWidth - rect.width() - (int)this.CENTER_CONTENT_OFFSET;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.widthMeasureSpec = widthMeasureSpec;
        this.reMeasure();
        this.setMeasuredDimension(this.measuredWidth, this.measuredHeight);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean eventConsumed = this.gestureDetector.onTouchEvent(event);
        boolean isIgnore = false;
        float top = (float)(-this.initPosition) * this.itemHeight;
        float bottom = (float)(this.adapter.getItemsCount() - 1 - this.initPosition) * this.itemHeight;
        float ratio = 0.25f;
        switch (event.getAction()) {
            case 0: {
                this.startTime = System.currentTimeMillis();
                this.cancelFuture();
                this.previousY = event.getRawY();
                break;
            }
            case 2: {
                float dy = this.previousY - event.getRawY();
                this.previousY = event.getRawY();
                this.totalScrollY += dy;
                if (this.isLoop) break;
                if (this.totalScrollY - this.itemHeight * ratio < top && dy < 0.0f || this.totalScrollY + this.itemHeight * ratio > bottom && dy > 0.0f) {
                    this.totalScrollY -= dy;
                    isIgnore = true;
                    break;
                }
                isIgnore = false;
                break;
            }
            default: {
                if (eventConsumed) break;
                float y = event.getY();
                double L2 = Math.acos(((float)this.radius - y) / (float)this.radius) * (double)this.radius;
                int circlePosition = (int)((L2 + (double)(this.itemHeight / 2.0f)) / (double)this.itemHeight);
                float extraOffset = (this.totalScrollY % this.itemHeight + this.itemHeight) % this.itemHeight;
                this.mOffset = (int)((float)(circlePosition - this.itemsVisible / 2) * this.itemHeight - extraOffset);
                if (System.currentTimeMillis() - this.startTime > 120L) {
                    this.smoothScroll(ACTION.DAGGLE);
                    break;
                }
                this.smoothScroll(ACTION.CLICK);
            }
        }
        if (!isIgnore && event.getAction() != 0) {
            this.invalidate();
        }
        return true;
    }

    public int getItemsCount() {
        return this.adapter != null ? this.adapter.getItemsCount() : 0;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void isCenterLabel(boolean isCenterLabel) {
        this.isCenterLabel = isCenterLabel;
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    public int getTextWidth(Paint paint, String str) {
        int iRet = 0;
        if (str != null && str.length() > 0) {
            int len = str.length();
            float[] widths = new float[len];
            paint.getTextWidths(str, widths);
            for (int j = 0; j < len; ++j) {
                iRet += (int)Math.ceil(widths[j]);
            }
        }
        return iRet;
    }

    public void setIsOptions(boolean options) {
        this.isOptions = options;
    }

    public void setTextColorOut(int textColorOut) {
        this.textColorOut = textColorOut;
        this.paintOuterText.setColor(this.textColorOut);
    }

    public void setTextColorCenter(int textColorCenter) {
        this.textColorCenter = textColorCenter;
        this.paintCenterText.setColor(this.textColorCenter);
    }

    public void setTextXOffset(int textXOffset) {
        this.textXOffset = textXOffset;
        if (textXOffset != 0) {
            this.paintCenterText.setTextScaleX(1.0f);
        }
    }

    public void setDividerWidth(int dividerWidth) {
        this.dividerWidth = dividerWidth;
        this.paintIndicator.setStrokeWidth((float)dividerWidth);
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.paintIndicator.setColor(dividerColor);
    }

    public void setDividerType(WheelView.DividerType dividerType) {
        this.dividerType = dividerType;
    }

    public void setLineSpacingMultiplier(float lineSpacingMultiplier) {
        if (lineSpacingMultiplier != 0.0f) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            this.judgeLineSpace();
        }
    }

    public boolean isLoop() {
        return this.isLoop;
    }

    public float getTotalScrollY() {
        return this.totalScrollY;
    }

    public void setTotalScrollY(float totalScrollY) {
        this.totalScrollY = totalScrollY;
    }

    public float getItemHeight() {
        return this.itemHeight;
    }

    public int getInitPosition() {
        return this.initPosition;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public static enum DividerType {
        FILL,
        WRAP,
        CIRCLE;

    }

    public static enum ACTION {
        CLICK,
        FLING,
        DAGGLE;

    }
}

