/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.picture.weight;

import android.content.Context;
import com.vhall.appui.baselib.M;
import com.vhall.lss.play.VHLivePlayer;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import com.vhall.player.vod.VodPlayerView;
import com.vhall.vod.VHVodPlayer;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class PicturePlayer {
    private static PicturePlayer instance;
    private VHLivePlayer livePlayer;
    private VHVodPlayer vodPlayer;
    private VHVideoPlayerView liveView;
    private VodPlayerView vodView;
    private Context context;
    public boolean isPlaying = false;
    private List<String> dpis;
    public String floatingIlId;
    private VHLivePlayer mPlayer;
    VHVideoPlayerView vhVideoPlayerView;

    private PicturePlayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PicturePlayer getInstance() {
        if (instance != null) return instance;
        Class<PicturePlayer> clazz = PicturePlayer.class;
        synchronized (PicturePlayer.class) {
            if (instance != null) return instance;
            instance = new PicturePlayer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public VHLivePlayer getPlayer(VHVideoPlayerView mVideoPlayer) {
        if (this.mPlayer == null) {
            mVideoPlayer.setDrawMode(1);
            this.mPlayer = new VHLivePlayer.Builder().videoPlayer((IVHVideoPlayer)mVideoPlayer).listener((VHPlayerListener)new MyPlayListener()).build();
        }
        return this.mPlayer;
    }

    public VHVideoPlayerView getVHVideoPlayerView() {
        if (this.vhVideoPlayerView == null) {
            this.vhVideoPlayerView = new VHVideoPlayerView((Context)M.context);
        }
        return this.vhVideoPlayerView;
    }

    public void setDpis(List<String> dpis) {
        this.dpis = dpis;
    }

    public List<String> getDpis() {
        return this.dpis;
    }

    public void release() {
        if (this.livePlayer != null) {
            this.livePlayer.stop();
            this.livePlayer.release();
            this.livePlayer = null;
        }
        if (this.liveView != null) {
            this.liveView.release();
            this.liveView = null;
        }
        if (this.vodPlayer != null) {
            this.vodPlayer.stop();
            this.vodPlayer.release();
            this.vodPlayer = null;
        }
        if (this.vodView != null) {
            this.vodView = null;
        }
        this.isPlaying = false;
    }

    public void releasePlayer() {
        if (this.livePlayer != null) {
            this.livePlayer.stop();
            this.livePlayer.release();
            this.livePlayer = null;
        }
        this.isPlaying = false;
    }

    public void releaseView() {
        if (this.liveView != null) {
            this.liveView.release();
            this.liveView = null;
        }
    }

    private class MyPlayListener
    implements VHPlayerListener {
        private MyPlayListener() {
        }

        public void onStateChanged(Constants.State state) {
            switch (state) {
                case START: {
                    break;
                }
                case BUFFER: {
                    break;
                }
                case STOP: {
                    break;
                }
            }
        }

        public void onEvent(int event, String msg) {
            switch (event) {
                case -262: {
                    break;
                }
                case -260: {
                    break;
                }
                case -261: {
                    try {
                        JSONArray array = new JSONArray(msg);
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        for (int i = 0; i < array.length(); ++i) {
                            String dpi = (String)array.opt(i);
                            map.put(dpi, 1);
                        }
                        break;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                case -265: {
                    break;
                }
            }
        }

        public void onError(int errorCode, int innerCode, String msg) {
        }
    }
}

