/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.picture.service;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.CloudBasePresent;
import com.vhall.appui.baselib.net.CloudApiFactory;
import com.vhall.appui.baselib.net.CloudHttpManager;
import com.vhall.appui.baselib.service.pictureinpicture.IPictureInPictureListener;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureConstance;
import com.vhall.appui.baselib.service.watchlive.WatchVerticalLiveManager;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.data.InavGetRoomInfo;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.module.room.ProxyVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import com.vhall.appui.baselib.vss.utils.rxutils.ResponseTransformer;
import com.vhall.appui.baselib.vss.utils.schedulers.SchedulerProvider;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.vod.VodPlayerView;
import com.vhall.vod.VHVodPlayer;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class VodFloatingService
extends Service {
    private int displayStyle = 2;
    private WindowManager windowManager;
    private View view;
    private WindowManager.LayoutParams params;
    private View close;
    private VodPlayerView floating_video_view;
    private VHVodPlayer mPlayer;
    private ConstraintLayout.LayoutParams playerViewLayoutParams;
    private boolean isPlaying;
    private long seekPostion = 0L;
    private CountDownTimer countDownTimer;
    private boolean isInit;
    private IVssMessageListener vssMessageListener = new ProxyVssMessageListener(new IVssMessageListener(){

        @Override
        public void onMessage(MessageData msg) {
            switch (msg.getType()) {
                case "kick_out": 
                case "live_over": {
                    VodFloatingService.this.stopSelf();
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
            Log.d((String)"======zhx", (String)("onError: " + msg));
        }
    });

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        block3: {
            super.onCreate();
            Notification.Builder builder = new Notification.Builder((Context)this).setContentTitle((CharSequence)"").setContentText((CharSequence)"");
            if (Build.VERSION.SDK_INT >= 26) {
                String notificationId = "TgStartServiceId";
                String notificationName = "TgStartServiceName";
                NotificationChannel channel = new NotificationChannel(notificationId, (CharSequence)notificationName, 4);
                ((NotificationManager)this.getSystemService("notification")).createNotificationChannel(channel);
                builder.setChannelId(notificationId);
            }
            Notification notification = builder.build();
            this.startForeground(1, notification);
            PictureInPictureConstance.havePicture = true;
            VssRoomManager.getInstance().setVssMessageListener(this.vssMessageListener);
            this.windowManager = (WindowManager)this.getSystemService("window");
            this.view = LayoutInflater.from((Context)this).inflate(R.layout.vod_floating_view, null);
            this.close = this.view.findViewById(R.id.pip_close);
            this.floating_video_view = (VodPlayerView)this.view.findViewById(R.id.floating_video_view);
            this.params = this.initParams();
            Log.d((String)"=====test_1", (String)"floating_addView: ");
            try {
                this.windowManager.addView(this.view, (ViewGroup.LayoutParams)this.params);
            }
            catch (Exception e) {
                VHToast.showShortToast("fs/oncreate" + e);
                if (this.mPlayer == null) break block3;
                this.mPlayer.pause();
            }
        }
        this.playerViewLayoutParams = new ConstraintLayout.LayoutParams((ConstraintLayout.LayoutParams)this.floating_video_view.getLayoutParams());
        this.mPlayer = new VHVodPlayer((Context)this);
        this.mPlayer.setDrawMode(1);
        this.mPlayer.setDisplay(this.floating_video_view);
        this.mPlayer.setListener((VHPlayerListener)new MyPlayer());
        this.play();
        this.countDownTimer = new CountDownTimer(Long.MAX_VALUE, 500L){

            public void onTick(long millisUntilFinished) {
                if (VodFloatingService.this.isBackground((Context)M.context)) {
                    if (VodFloatingService.this.mPlayer != null) {
                        VodFloatingService.this.mPlayer.pause();
                    }
                    if (VodFloatingService.this.view != null) {
                        VodFloatingService.this.view.setVisibility(8);
                    }
                } else {
                    if (VodFloatingService.this.view != null) {
                        VodFloatingService.this.view.setVisibility(0);
                    }
                    if (VodFloatingService.this.mPlayer != null && !VodFloatingService.this.mPlayer.isPlaying()) {
                        VodFloatingService.this.mPlayer.resume();
                    }
                }
            }

            public void onFinish() {
            }
        };
        this.countDownTimer.start();
    }

    public boolean isBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(context.getPackageName())) continue;
            if (appProcess.importance != 100) {
                Log.i((String)(context.getPackageName() + "vhall"), (String)("\u5904\u4e8e\u540e\u53f0" + appProcess.processName));
                return true;
            }
            Log.i((String)(context.getPackageName() + "vhall"), (String)("\u5904\u4e8e\u524d\u53f0" + appProcess.processName));
            return false;
        }
        return false;
    }

    public void play() {
        if (PictureInPictureConstance.ROOMINFO == null) {
            return;
        }
        if (!this.isInit) {
            this.mPlayer.init(PictureInPictureConstance.ROOMINFO.getRecord_id(), PictureInPictureConstance.ROOMINFO.getPaas_access_token());
        } else if (this.isPlaying) {
            this.mPlayer.pause();
        } else if (this.mPlayer.getState() == Constants.State.END) {
            this.mPlayer.seekto(0L);
            this.mPlayer.start();
        } else if (this.mPlayer.getState() == Constants.State.STOP) {
            this.mPlayer.resume();
        } else {
            this.mPlayer.start();
        }
    }

    public WindowManager.LayoutParams initParams() {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        if (this.displayStyle == 1) {
            layoutParams.width = DensityUtils.dpToPxInt(272.0f);
            layoutParams.height = DensityUtils.dpToPxInt(153.0f);
        } else {
            layoutParams.width = DensityUtils.dpToPxInt(153.0f);
            layoutParams.height = DensityUtils.dpToPxInt(272.0f);
        }
        layoutParams.x = DensityUtils.dpToPxInt(20.0f);
        layoutParams.y = DensityUtils.dpToPxInt(20.0f);
        layoutParams.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        layoutParams.flags = 524328;
        layoutParams.gravity = 85;
        layoutParams.format = -2;
        return layoutParams;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            return super.onStartCommand(intent, flags, startId);
        }
        this.seekPostion = intent.getLongExtra("seekPostion", 0L);
        if (this.mPlayer != null) {
            this.mPlayer.seekto(this.seekPostion);
        }
        IPictureInPictureListener.getInstance().sendMessageToOut(true);
        this.showFloating();
        return super.onStartCommand(intent, flags, startId);
    }

    private void showFloating() {
        IPictureInPictureListener.getInstance().registListenerToNewRoom(new IPictureInPictureListener.EnterNewRoomSendMesssageToPip(){

            @Override
            public void sendMessage(boolean yes) {
                if (yes) {
                    VodFloatingService.this.stopSelf();
                    return;
                }
            }
        });
        this.view.setOnClickListener(v -> {
            long position = this.mPlayer.getPosition();
            this.FsEnterRoom(position);
            IPictureInPictureListener.getInstance().sendMessageToOut(false);
            this.stopSelf();
        });
        this.view.setBackgroundColor(-16777216);
        this.view.setOnTouchListener(new View.OnTouchListener(){
            int startX;
            int startY;
            long startTime = 0L;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        this.startX = (int)event.getRawX();
                        this.startY = (int)event.getRawY();
                        this.startTime = System.currentTimeMillis();
                        break;
                    }
                    case 2: {
                        int moveX = (int)event.getRawX();
                        int moveY = (int)event.getRawY();
                        int dx = moveX - this.startX;
                        int dy = moveY - this.startY;
                        ((VodFloatingService)VodFloatingService.this).params.x -= dx;
                        ((VodFloatingService)VodFloatingService.this).params.y -= dy;
                        VodFloatingService.this.windowManager.updateViewLayout(v, (ViewGroup.LayoutParams)VodFloatingService.this.params);
                        this.startX = moveX;
                        this.startY = moveY;
                        break;
                    }
                    case 1: {
                        if (System.currentTimeMillis() - this.startTime >= 300L || !(Math.abs(event.getRawX() - (float)this.startX) < 10.0f) || !(Math.abs(event.getRawY() - (float)this.startY) < 10.0f)) break;
                        v.performClick();
                    }
                }
                return true;
            }
        });
        this.close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VodFloatingService.this.stopSelf();
                IPictureInPictureListener.getInstance().sendMessageToOut(false);
            }
        });
    }

    private void FsEnterRoom(final long position) {
        HashMap<String, String> param = CloudBasePresent.getDefaultParam();
        param.put("il_id", PictureInPictureConstance.PIP_IL_ID);
        param.put("password", PictureInPictureConstance.PASSWORD);
        param.put("role_name", PictureInPictureConstance.ROLE_NAME);
        CloudApiFactory.getApiSingleton().getRoomInfo(CloudHttpManager.getRequestBody(param)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<InavGetRoomInfo>(){

            public void accept(InavGetRoomInfo inavGetRoomInfo) throws Exception {
                if (WatchVerticalLiveManager.getInstance().isLoaded()) {
                    Bundle bundle = new Bundle();
                    bundle.putSerializable("extra", (Serializable)inavGetRoomInfo);
                    bundle.putLong("position", position);
                    WatchVerticalLiveManager.getInstance().startWatchLiveActivity((Context)M.context, bundle);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                Log.e((String)"", (String)"");
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
        }
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        try {
            if (this.windowManager != null && this.view != null) {
                this.windowManager.removeView(this.view);
            }
        }
        catch (Exception e) {
            VhLog.d(e.getMessage());
        }
        VssRoomManager.getInstance().removeVssMessageListener(this.vssMessageListener);
    }

    class MyPlayer
    implements VHPlayerListener {
        MyPlayer() {
        }

        public void onStateChanged(Constants.State state) {
            int playState = -1;
            switch (state) {
                case IDLE: {
                    VodFloatingService.this.isPlaying = false;
                    playState = 1;
                    break;
                }
                case BUFFER: {
                    break;
                }
                case START: {
                    VodFloatingService.this.isPlaying = true;
                    playState = 0;
                    break;
                }
                case STOP: {
                    VodFloatingService.this.isPlaying = false;
                    playState = 1;
                    break;
                }
                case END: {
                    VodFloatingService.this.isPlaying = false;
                    playState = 2;
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            VodFloatingService.this.stopSelf();
                        }
                    }, 500L);
                    break;
                }
            }
        }

        public void onEvent(int event, String msg) {
            switch (event) {
                case -256: {
                    VodFloatingService.this.mPlayer.start();
                    VodFloatingService.this.isInit = true;
                    break;
                }
                case -265: {
                    try {
                        int width;
                        JSONObject jsonObject = new JSONObject(msg);
                        if (VodFloatingService.this.mPlayer == null) break;
                        int height = (Integer)jsonObject.opt("height");
                        if (height >= (width = ((Integer)jsonObject.opt("width")).intValue())) {
                            VodFloatingService.this.mPlayer.setDrawMode(2);
                            break;
                        }
                        VodFloatingService.this.mPlayer.setDrawMode(1);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case -261: {
                    break;
                }
                case -260: {
                    break;
                }
            }
        }

        public void onError(int errorCode, int i1, String msg) {
            VodFloatingService.this.isInit = false;
            switch (errorCode) {
                case -1: {
                    VhLog.d("\u521d\u59cb\u5316\u5931\u8d25");
                    break;
                }
                case -2: {
                    VhLog.d("\u8bf7\u5148\u521d\u59cb\u5316");
                    break;
                }
                default: {
                    VhLog.d(msg);
                }
            }
            VodFloatingService.this.isPlaying = false;
        }
    }
}

