/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.picture.service;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.VhSdk;
import com.vhall.appui.baselib.base.CloudBasePresent;
import com.vhall.appui.baselib.bean.User;
import com.vhall.appui.baselib.bean.UserInfo;
import com.vhall.appui.baselib.net.CloudApiFactory;
import com.vhall.appui.baselib.net.CloudHttpManager;
import com.vhall.appui.baselib.net.utils.CoreNetCallback;
import com.vhall.appui.baselib.network.CommonManagerNetWrapper;
import com.vhall.appui.baselib.service.pictureinpicture.IPictureInPictureListener;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureConstance;
import com.vhall.appui.baselib.service.watchlive.WatchVerticalLiveManager;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.utils.LogUtils;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.InavGetRoomInfo;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.module.room.ProxyVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import com.vhall.appui.baselib.vss.utils.rxutils.ResponseTransformer;
import com.vhall.appui.baselib.vss.utils.schedulers.SchedulerProvider;
import com.vhall.appui.loginview.UserManager;
import com.vhall.appui.main.network.MainListWrapper;
import com.vhall.lss.play.VHLivePlayer;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class FloatingService
extends Service {
    private String roomId;
    private ImageView progressBar;
    private WindowManager windowManager;
    private View view;
    private int displayStyle = 2;
    private WindowManager.LayoutParams params;
    private int startType = 0;
    private TextView try_watch_end_title;
    private long tryTime;
    private CountDownTimer tryWatchTimer;
    private int vodTryWatchTime;
    private boolean isTryWatch;
    private VHVideoPlayerView liveView;
    private VHLivePlayer player;
    private FrameLayout viewParent;
    private ImageView close;
    private ImageView pip_check;
    private VHLivePlayer mPlayer;
    private CountDownTimer countDownTimer;
    private VHVideoPlayerView mVideoPlayer;
    private String paas_access_token;
    private boolean isClose = false;
    private IVssMessageListener vssMessageListener = new ProxyVssMessageListener(new IVssMessageListener(){

        @Override
        public void onMessage(MessageData msg) {
            switch (msg.getType()) {
                case "kick_out": 
                case "live_over": {
                    FloatingService.this.isClose = true;
                    FloatingService.this.stopSelf();
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
            Log.d((String)"======zhx", (String)("onError: " + msg));
        }
    });
    private Handler handler = new Handler();

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        Notification.Builder builder = new Notification.Builder((Context)this).setContentTitle((CharSequence)"").setContentText((CharSequence)"");
        if (Build.VERSION.SDK_INT >= 26) {
            String notificationId = "TgStartServiceId";
            String notificationName = "TgStartServiceName";
            NotificationChannel channel = new NotificationChannel(notificationId, (CharSequence)notificationName, 4);
            ((NotificationManager)this.getSystemService("notification")).createNotificationChannel(channel);
            builder.setChannelId(notificationId);
        }
        Notification notification = builder.build();
        this.startForeground(1, notification);
        PictureInPictureConstance.havePicture = true;
        this.windowManager = (WindowManager)this.getSystemService("window");
        this.view = LayoutInflater.from((Context)this).inflate(R.layout.floating_view, null);
        this.params = this.initParams();
        Log.d((String)"=====test_1", (String)"floating_addView: ");
        try {
            this.windowManager.addView(this.view, (ViewGroup.LayoutParams)this.params);
        }
        catch (Exception e) {
            VHToast.showShortToast("fs/oncreate" + e);
        }
        this.viewParent = (FrameLayout)this.view.findViewById(R.id.floating_video_view);
        this.close = (ImageView)this.view.findViewById(R.id.pip_close);
        this.pip_check = (ImageView)this.view.findViewById(R.id.pip_check);
        this.mVideoPlayer = new VHVideoPlayerView((Context)this);
        this.mVideoPlayer.setWaterMark(null);
        this.mVideoPlayer.setDrawMode(1);
        this.mPlayer = new VHLivePlayer.Builder().videoPlayer((IVHVideoPlayer)this.mVideoPlayer).listener((VHPlayerListener)new MyPlayListener()).build();
        if (this.mVideoPlayer.getParent() != null && this.mVideoPlayer != null) {
            ((ViewGroup)this.mVideoPlayer.getParent()).removeView((View)this.mVideoPlayer);
            LogUtils.e("fs/removeView");
        }
        this.viewParent.addView((View)this.mVideoPlayer, -1, -1);
        this.view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("room_id", FloatingService.this.roomId + "");
                params.put("type", "1");
                CommonManagerNetWrapper.joinRoomStarrt(params, new CallBack<String>(){

                    @Override
                    public void onSuccess(String result) {
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            try {
                                JSONObject jsonObject = new JSONObject(result);
                                int data = jsonObject.optInt("data");
                                String msg = jsonObject.optString("msg");
                                if (data == 1) {
                                    FloatingService.this.FsEnterRoom();
                                    IPictureInPictureListener.getInstance().sendMessageToOut(false);
                                    FloatingService.this.isClose = true;
                                    FloatingService.this.stopSelf();
                                } else {
                                    Toast.makeText((Context)FloatingService.this, (CharSequence)("" + msg), (int)0).show();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                    }
                });
            }
        });
        this.countDownTimer = new CountDownTimer(Long.MAX_VALUE, 500L){

            public void onTick(long millisUntilFinished) {
                if (FloatingService.this.isBackground((Context)M.context)) {
                    if (FloatingService.this.view != null) {
                        FloatingService.this.view.setVisibility(8);
                        FloatingService.this.view.findViewById(R.id.bg).setVisibility(0);
                    }
                    if (FloatingService.this.mPlayer != null) {
                        FloatingService.this.mPlayer.pause();
                    }
                } else {
                    if (FloatingService.this.view != null) {
                        FloatingService.this.view.setVisibility(0);
                    }
                    if (FloatingService.this.mPlayer != null && FloatingService.this.mPlayer.resumeAble()) {
                        if (!FloatingService.this.mPlayer.isPlaying()) {
                            FloatingService.this.mPlayer.resume();
                        }
                    } else if (FloatingService.this.mPlayer != null && !FloatingService.this.mPlayer.isPlaying()) {
                        FloatingService.this.mPlayer.start(PictureInPictureConstance.PIP_ROOM_ID, PictureInPictureConstance.PIP_ACCESS_TOKEN);
                    }
                }
            }

            public void onFinish() {
            }
        };
        this.countDownTimer.start();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            return super.onStartCommand(intent, flags, startId);
        }
        if (this.mPlayer != null && this.mPlayer.resumeAble()) {
            this.mPlayer.resume();
        } else if (this.mPlayer != null) {
            this.mPlayer.start(PictureInPictureConstance.PIP_ROOM_ID, PictureInPictureConstance.PIP_ACCESS_TOKEN);
        }
        IPictureInPictureListener.getInstance().sendMessageToOut(true);
        this.showFloating();
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        if (this.mPlayer != null) {
            this.mPlayer.pause();
            this.mPlayer.release();
            this.mPlayer = null;
        }
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
        }
        try {
            if (this.windowManager != null && this.view != null) {
                this.windowManager.removeView(this.view);
            }
        }
        catch (Exception e) {
            VhLog.d(e.getMessage());
        }
        VssRoomManager.getInstance().removeVssMessageListener(this.vssMessageListener);
        super.onDestroy();
    }

    public WindowManager.LayoutParams initParams() {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        if (this.displayStyle == 1) {
            layoutParams.width = DensityUtils.dpToPxInt(272.0f);
            layoutParams.height = DensityUtils.dpToPxInt(153.0f);
        } else {
            layoutParams.width = DensityUtils.dpToPxInt(153.0f);
            layoutParams.height = DensityUtils.dpToPxInt(272.0f);
        }
        layoutParams.x = DensityUtils.dpToPxInt(20.0f);
        layoutParams.y = DensityUtils.dpToPxInt(20.0f);
        layoutParams.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        layoutParams.flags = 524328;
        layoutParams.gravity = 85;
        layoutParams.format = -2;
        return layoutParams;
    }

    private void showFloating() {
        IPictureInPictureListener.getInstance().registListenerToNewRoom(new IPictureInPictureListener.EnterNewRoomSendMesssageToPip(){

            @Override
            public void sendMessage(boolean yes) {
                if (yes) {
                    FloatingService.this.isClose = true;
                    FloatingService.this.stopSelf();
                    return;
                }
            }
        });
        this.view.setBackgroundColor(-16777216);
        this.view.setOnTouchListener(new View.OnTouchListener(){
            int startX;
            int startY;
            long startTime = 0L;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        this.startX = (int)event.getRawX();
                        this.startY = (int)event.getRawY();
                        this.startTime = System.currentTimeMillis();
                        break;
                    }
                    case 2: {
                        int moveX = (int)event.getRawX();
                        int moveY = (int)event.getRawY();
                        int dx = moveX - this.startX;
                        int dy = moveY - this.startY;
                        ((FloatingService)FloatingService.this).params.x -= dx;
                        ((FloatingService)FloatingService.this).params.y -= dy;
                        FloatingService.this.windowManager.updateViewLayout(v, (ViewGroup.LayoutParams)FloatingService.this.params);
                        this.startX = moveX;
                        this.startY = moveY;
                        break;
                    }
                    case 1: {
                        if (System.currentTimeMillis() - this.startTime >= 300L || !(Math.abs(event.getRawX() - (float)this.startX) < 10.0f) || !(Math.abs(event.getRawY() - (float)this.startY) < 10.0f)) break;
                        v.performClick();
                    }
                }
                return true;
            }
        });
        this.close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PictureInPictureConstance.activity == null) {
                    if (PictureInPictureConstance.INAVGETROOMINFO != null && PictureInPictureConstance.INAVGETROOMINFO.room_info != null) {
                        VssRoomManager.getInstance().leaveRoom(PictureInPictureConstance.INAVGETROOMINFO.room_info.channel_id, FloatingService.this.vssMessageListener);
                    } else {
                        VssRoomManager.getInstance().leaveRoom(null, FloatingService.this.vssMessageListener);
                    }
                }
                PictureInPictureConstance.havePicture = false;
                FloatingService.this.isClose = false;
                FloatingService.this.stopSelf();
                IPictureInPictureListener.getInstance().sendCloseMessage();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("room_id", FloatingService.this.roomId + "");
                params.put("type", "1");
                CommonManagerNetWrapper.joinRoomStarrt(params, new CallBack<String>(){

                    @Override
                    public void onSuccess(String result) {
                        VhLog.d(result);
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        VhLog.d(msg);
                    }
                });
            }
        });
        this.pip_check.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingService.this.isClose = true;
                FloatingService.this.stopSelf();
                IPictureInPictureListener.getInstance().sendMessageToOut(false);
            }
        });
    }

    private void FsEnterRoom() {
        if (VhSdk.getInstance().vhallCallback != null) {
            UserInfo userInfo = VhSdk.getInstance().vhallCallback.getUserInfo();
            if (userInfo != null) {
                VhLog.d(userInfo.toString());
            }
            if (userInfo != null && !TextUtils.isEmpty((CharSequence)userInfo.loginId)) {
                VhSdk.getInstance().setUserInfo(userInfo.loginId, userInfo.phone);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("il_id", PictureInPictureConstance.PIP_ROOM_ID);
                param.put("phone", userInfo.phone);
                param.put("member_id", userInfo.loginId);
                param.put("type", "2");
                this.loginEnterRoom(param);
            } else {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("il_id", PictureInPictureConstance.PIP_ROOM_ID);
                param.put("phone", "");
                VhSdk.getInstance();
                param.put("member_id", VhSdk.getUUID((Context)M.context));
                param.put("type", "3");
                this.loginEnterRoom(param);
            }
        } else {
            this.enterRoom();
        }
    }

    public void loginEnterRoom(HashMap<String, String> param) {
        MainListWrapper.visitorLogin(param, new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                VhLog.d(result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    JSONObject data = jsonObject.optJSONObject("data");
                    String nick_name = data.optString("nick_name");
                    String account_id = data.optString("account_id");
                    String token = data.optString("token");
                    User user = new User(account_id, nick_name, "", token);
                    UserManager.refreshUser(user);
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("il_id", PictureInPictureConstance.PIP_IL_ID);
                    param.put("role_name", "2");
                    MainListWrapper.getRoomInfo(param, new CoreNetCallback<InavGetRoomInfo>(new CallBack<InavGetRoomInfo>(){

                        @Override
                        public void onSuccess(InavGetRoomInfo inavGetRoomInfo) {
                            PictureInPictureConstance.INAVGETROOMINFO = inavGetRoomInfo;
                            if (WatchVerticalLiveManager.getInstance().isLoaded()) {
                                Bundle bundle = new Bundle();
                                bundle.putSerializable("extra", (Serializable)inavGetRoomInfo);
                                bundle.putBoolean("floatingClick", true);
                                WatchVerticalLiveManager.getInstance().startWatchLiveActivity((Context)M.context, bundle);
                            }
                        }

                        @Override
                        public void onError(int eventCode, String msg) {
                            VhLog.d(msg);
                            VHToast.showLongToast((Context)M.context, msg);
                        }
                    }, InavGetRoomInfo.class));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhLog.d(msg);
                VHToast.showLongToast((Context)M.context, msg);
            }
        }));
    }

    public void enterRoom() {
        HashMap<String, String> param = CloudBasePresent.getDefaultParam();
        param.put("il_id", PictureInPictureConstance.PIP_IL_ID);
        param.put("password", PictureInPictureConstance.PASSWORD);
        param.put("role_name", PictureInPictureConstance.ROLE_NAME);
        CloudApiFactory.getApiSingleton().getRoomInfo(CloudHttpManager.getRequestBody(param)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<InavGetRoomInfo>(){

            public void accept(InavGetRoomInfo inavGetRoomInfo) throws Exception {
                if (WatchVerticalLiveManager.getInstance().isLoaded()) {
                    Bundle bundle = new Bundle();
                    bundle.putSerializable("extra", (Serializable)inavGetRoomInfo);
                    bundle.putBoolean("floatingClick", true);
                    WatchVerticalLiveManager.getInstance().startWatchLiveActivity((Context)M.context, bundle);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                Log.e((String)"", (String)"");
            }
        });
    }

    public boolean isBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(context.getPackageName())) continue;
            return appProcess.importance != 100;
        }
        return false;
    }

    private class MyPlayListener
    implements VHPlayerListener {
        private MyPlayListener() {
        }

        public void onStateChanged(Constants.State state) {
            LogUtils.e(String.format("state %s", state.name()));
            switch (state) {
                case START: {
                    FloatingService.this.handler.removeCallbacksAndMessages(null);
                    FloatingService.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (FloatingService.this.view != null) {
                                FloatingService.this.view.findViewById(R.id.bg).setVisibility(8);
                            }
                        }
                    }, 800L);
                    break;
                }
                case BUFFER: {
                    break;
                }
                case STOP: {
                    break;
                }
            }
        }

        public void onEvent(int event, String msg) {
            switch (event) {
                case -262: {
                    break;
                }
                case -260: {
                    break;
                }
                case -261: {
                    break;
                }
                case -265: {
                    try {
                        int width;
                        JSONObject jsonObject = new JSONObject(msg);
                        if (FloatingService.this.mPlayer == null) break;
                        int height = (Integer)jsonObject.opt("height");
                        if (height >= (width = ((Integer)jsonObject.opt("width")).intValue())) {
                            FloatingService.this.mPlayer.setDrawMode(2);
                            break;
                        }
                        FloatingService.this.mPlayer.setDrawMode(1);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }

        public void onError(int errorCode, int innerCode, String msg) {
            switch (errorCode) {
                case -1: {
                    Log.e((String)"vhall_sdk", (String)("ERROR_CONNECT  " + msg));
                    break;
                }
            }
        }
    }
}

