/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.main.main.ui;

import android.content.Context;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.request.RequestOptions;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.BaseFragment;
import com.vhall.appui.baselib.base.MyBaseViewHolder;
import com.vhall.appui.baselib.core.service.IComponentEventListener;
import com.vhall.appui.baselib.service.createroom.CreateRoomManager;
import com.vhall.appui.baselib.utils.GlideRoundTransform;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.vss.data.RoomInfo;
import com.vhall.appui.baselib.widget.MyImageSpan;
import com.vhall.appui.main.main.dialog.CheckIdentityPopu;
import com.vhall.appui.main.main.dialog.EnterRoomDialog;
import com.vhall.appui.main.main.present.IMainFragmentContract;
import com.vhall.appui.main.main.present.MainFragmentPresent;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.List;

public class MainFragment
extends BaseFragment
implements IMainFragmentContract.IMainFragmentView {
    private RecyclerView recyclerView;
    private ImageView mEnterBtn;
    private SwipeRefreshLayout refreshLayout;
    private int page = 1;
    private IMainFragmentContract.IMainFragmentPresent present;
    private RoomListAdapter adapter;
    private View empty_container;
    private IComponentEventListener mComponentEventListener = new IComponentEventListener(){

        @Override
        public void onEvent(String method, String args, Bundle extra) {
            if (TextUtils.equals((CharSequence)"createRoomSuccess", (CharSequence)method)) {
                MainFragment.this.refreshPage(true);
            }
        }
    };
    private CheckIdentityPopu mCheckPopu;
    private EnterRoomDialog mEnterDialog;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View inflate = inflater.inflate(R.layout.main_list_fragment, null);
        this.recyclerView = (RecyclerView)inflate.findViewById(R.id.recycle_view);
        this.empty_container = inflate.findViewById(R.id.empty_container);
        this.mEnterBtn = (ImageView)inflate.findViewById(R.id.iv_enter);
        this.refreshLayout = (SwipeRefreshLayout)inflate.findViewById(R.id.refresh_layout);
        LinearLayoutManager mLayoutManager = new LinearLayoutManager((Context)this.mContext);
        mLayoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)mLayoutManager);
        this.adapter = new RoomListAdapter();
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        new MainFragmentPresent(this);
        CreateRoomManager.getInstance().registerComponentEventListener(this.mComponentEventListener);
        return inflate;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.present.getRoomList(this.page);
        this.mEnterBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MainFragment.this.showCheckPopu((View)MainFragment.this.mEnterBtn);
            }
        });
        this.refreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                MainFragment.this.refreshPage(false);
            }
        });
        this.adapter.setOnLoadMoreListener(new BaseQuickAdapter.RequestLoadMoreListener(){

            public void onLoadMoreRequested() {
                MainFragment.this.page++;
                MainFragment.this.present.getRoomList(MainFragment.this.page);
            }
        }, this.recyclerView);
        this.adapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

            public void onItemClick(final BaseQuickAdapter adapter, View view, final int position) {
                Disposable disposable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                    public void subscribe(ObservableEmitter<String> emitter) throws Exception {
                        if (InternalUtils.getPushPermission(2, (AppCompatActivity)MainFragment.this.getActivity())) {
                            emitter.onNext((Object)"success");
                        } else {
                            emitter.onComplete();
                        }
                    }
                }).doOnNext((Consumer)new Consumer<String>(){

                    public void accept(String s) throws Exception {
                        RoomInfo item = (RoomInfo)adapter.getItem(position);
                        if (item != null && !TextUtils.isEmpty((CharSequence)item.getIl_id())) {
                            MainFragment.this.present.getRoomInfo(false, item.getIl_id(), "", "1");
                        } else {
                            MainFragment.this.baseShowToast(M.getString(R.string.main_list_room_id_error));
                        }
                    }
                }).subscribe();
                MainFragment.this.addSubscribe(disposable);
            }
        });
        this.adapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener(){

            public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                int id2 = view.getId();
                RoomInfo item = (RoomInfo)adapter.getItem(position);
                if (id2 == R.id.room_setting) {
                    CreateRoomManager.getInstance().changeRoom(item, (Context)MainFragment.this.getActivity());
                }
            }
        });
    }

    private void refreshPage(boolean loading) {
        if (this.adapter.getData().size() == 0 && loading) {
            this.showLoadProgress();
        }
        this.page = 1;
        this.present.getRoomList(this.page);
    }

    @Override
    public void getRoomListFinish(List<RoomInfo> roomInfo, boolean isEnd) {
        this.hideLoadProgress();
        if (this.refreshLayout != null) {
            this.refreshLayout.setRefreshing(false);
        }
        if (this.page == 1) {
            this.adapter.setNewData(roomInfo);
            this.adapter.disableLoadMoreIfNotFullPage(this.recyclerView);
        } else if (roomInfo != null && roomInfo.size() > 0) {
            this.adapter.addData(roomInfo);
            this.adapter.loadMoreComplete();
        } else {
            this.adapter.loadMoreComplete();
        }
        this.empty_container.setVisibility(InternalUtils.isEmpty(this.adapter.getData()) ? 0 : 8);
    }

    @Override
    public void showEnterDialogError(String msg) {
        this.hideLoadProgress();
        if (this.mEnterDialog != null) {
            this.mEnterDialog.setError(msg);
        }
    }

    @Override
    public void dismissEnterDialog() {
        this.hideLoadProgress();
        if (this.mEnterDialog != null) {
            this.mEnterDialog.dismiss();
        }
    }

    @Override
    public void setPresenter(IMainFragmentContract.IMainFragmentPresent presenter) {
        this.present = presenter;
    }

    @Override
    public void showToast(String content) {
        this.hideLoadProgress();
        this.baseShowToast(content);
        if (this.refreshLayout != null) {
            this.refreshLayout.setRefreshing(false);
        }
        if (this.adapter.isLoading()) {
            this.adapter.loadMoreEnd(true);
        }
    }

    public void showCheckPopu(View mEnterBtn) {
        if (this.mCheckPopu == null) {
            this.mCheckPopu = new CheckIdentityPopu(this.getContext());
            this.mCheckPopu.setOnCheckListener(new CheckIdentityPopu.CheckListener(){

                @Override
                public void onChecked(int id2) {
                    MainFragment.this.mCheckPopu.dismiss();
                    MainFragment.this.showEnterDialog(id2);
                }
            });
        }
        this.mCheckPopu.show(mEnterBtn);
    }

    public void showEnterDialog(int iden) {
        if (this.mEnterDialog == null) {
            this.mEnterDialog = new EnterRoomDialog(this.getContext());
            this.mEnterDialog.setOnEnterBtnClickListener(new EnterRoomDialog.OnEnterBtnClickListener(){

                @Override
                public void onClick(final String roomId, final String code) {
                    Disposable disposable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                        public void subscribe(ObservableEmitter<String> emitter) throws Exception {
                            if (InternalUtils.getPushPermission(2, (AppCompatActivity)MainFragment.this.getActivity())) {
                                emitter.onNext((Object)"success");
                            } else {
                                emitter.onComplete();
                            }
                        }
                    }).subscribe((Consumer)new Consumer<String>(){

                        public void accept(String s) throws Exception {
                            MainFragment.this.present.getRoomInfo(true, roomId, code, TextUtils.isEmpty((CharSequence)code) ? "2" : "");
                        }
                    });
                    MainFragment.this.addSubscribe(disposable);
                }
            });
        }
        this.mEnterDialog.show(iden);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        CreateRoomManager.getInstance().unregisterComponentEventListener(this.mComponentEventListener);
    }

    @Override
    public void showProgress() {
        this.showLoadProgress();
    }

    @Override
    public void hideProgress() {
        this.hideLoadProgress();
    }

    class RoomListAdapter
    extends BaseQuickAdapter<RoomInfo, MyBaseViewHolder> {
        public RoomListAdapter() {
            super(R.layout.main_list_item_room);
        }

        protected void convert(@NonNull MyBaseViewHolder helper, RoomInfo info) {
            ImageView ivCover = (ImageView)helper.getView(R.id.cover_im);
            Glide.with((Context)this.mContext).load(InternalUtils.processImageUrl(info.getCover_image())).apply(((RequestOptions)((RequestOptions)new RequestOptions().transforms(new Transformation[]{new GlideRoundTransform(this.mContext, 10)})).placeholder(R.drawable.common_poster)).error(R.drawable.common_poster)).into(ivCover);
            if (info.getStatus() == 1) {
                helper.getView(R.id.tv_tag).setBackgroundResource(R.drawable.main_list_shape_list_live);
                MyImageSpan imageSpan = new MyImageSpan(this.mContext, R.drawable.main_list_icon_live);
                SpannableString string2 = new SpannableString((CharSequence)("  " + MainFragment.this.getString(R.string.main_list_live)));
                string2.setSpan((Object)imageSpan, 0, 1, 17);
                helper.setText(R.id.tv_tag, (CharSequence)string2);
            } else if (info.getStatus() == 0) {
                helper.setText(R.id.tv_tag, MainFragment.this.getString(R.string.main_list_preview));
                helper.getView(R.id.tv_tag).setBackgroundResource(R.drawable.main_list_shape_list_foreshow);
            } else if (info.getStatus() == 2) {
                helper.setText(R.id.tv_tag, MainFragment.this.getString(R.string.main_list_room_live_end));
                helper.getView(R.id.tv_tag).setBackgroundResource(R.drawable.main_list_shape_gray);
            }
            helper.setText(R.id.tv_time, info.getStart_time());
            helper.setText(R.id.tv_title, String.format("%s", info.getSubject()));
            helper.addOnClickListener(new int[]{R.id.room_setting});
        }
    }
}

