/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.main.main.present;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.bean.ListRoomInfo;
import com.vhall.appui.baselib.net.utils.CoreNetCallback;
import com.vhall.appui.baselib.service.livepreview.LivePreviewManager;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureConstance;
import com.vhall.appui.baselib.service.rtcLive.RtcVerticalManager;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.utils.ListUtils;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.InavGetRoomInfo;
import com.vhall.appui.baselib.vss.data.RoomInfo;
import com.vhall.appui.main.main.present.IMainFragmentContract;
import com.vhall.appui.main.network.MainListWrapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class MainFragmentPresent
implements IMainFragmentContract.IMainFragmentPresent {
    private IMainFragmentContract.IMainFragmentView mainFragmentView;

    public MainFragmentPresent(IMainFragmentContract.IMainFragmentView view) {
        this.mainFragmentView = view;
        this.mainFragmentView.setPresenter(this);
    }

    @Override
    public void getRoomList(final int page) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("page", String.valueOf(page));
        param.put("page_size", "10");
        this.mainFragmentView.showProgress();
        MainListWrapper.getRoomListOwn(param, new CoreNetCallback<ListRoomInfo>(new CallBack<ListRoomInfo>(){

            @Override
            public void onSuccess(ListRoomInfo s) {
                MainFragmentPresent.this.mainFragmentView.hideProgress();
                List<RoomInfo> roomInfoList = s.getList();
                if (ListUtils.isEmpty(roomInfoList)) {
                    if (page == 1) {
                        MainFragmentPresent.this.mainFragmentView.showToast(M.getString(R.string.main_list_no_more_data));
                    } else {
                        MainFragmentPresent.this.mainFragmentView.showToast(M.getString(R.string.main_list_load_data_finish));
                    }
                    MainFragmentPresent.this.mainFragmentView.getRoomListFinish(null, true);
                } else if (roomInfoList.size() == 1) {
                    if (TextUtils.isEmpty((CharSequence)roomInfoList.get(0).getIl_id())) {
                        MainFragmentPresent.this.mainFragmentView.getRoomListFinish(null, true);
                    } else {
                        MainFragmentPresent.this.mainFragmentView.getRoomListFinish(roomInfoList, false);
                    }
                } else {
                    MainFragmentPresent.this.mainFragmentView.getRoomListFinish(roomInfoList, false);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                MainFragmentPresent.this.mainFragmentView.hideProgress();
                MainFragmentPresent.this.mainFragmentView.showToast(msg);
            }
        }, ListRoomInfo.class));
    }

    @Override
    public void getRoomInfo(final boolean isDialog, final String ilid, final String password, final String role_name) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("il_id", ilid);
        param.put("password", password);
        param.put("role_name", role_name);
        MainListWrapper.getRoomInfo(param, new CoreNetCallback<InavGetRoomInfo>(new CallBack<InavGetRoomInfo>(){

            @Override
            public void onSuccess(final InavGetRoomInfo inavGetRoomInfo) {
                PictureInPictureConstance.INAVGETROOMINFO = inavGetRoomInfo;
                HashMap<String, String> onlineParams = new HashMap<String, String>();
                onlineParams.put("channel_id", inavGetRoomInfo.getRoom_info().getChannel_id());
                onlineParams.put("account_ids", AccountManager.getInstance().getUserId());
                MainListWrapper.checkOnline(onlineParams, new CoreNetCallback<String>(new CallBack<String>(){

                    @Override
                    public void onSuccess(String res) {
                        JSONObject s = JSON.parseObject((String)res);
                        String userId = AccountManager.getInstance().getUserId();
                        if (s != null && s.containsKey(userId)) {
                            inavGetRoomInfo.setHasConnected(InternalUtils.convertBoolean((Integer)s.get(userId)));
                        }
                        MainFragmentPresent.this.dealRoomResult(inavGetRoomInfo, isDialog, ilid, password, role_name);
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        Log.e((String)"checkOnline", (String)msg);
                        if (isDialog) {
                            MainFragmentPresent.this.mainFragmentView.showEnterDialogError(msg);
                        } else {
                            MainFragmentPresent.this.mainFragmentView.showToast(msg);
                        }
                    }
                }, String.class));
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (isDialog) {
                    MainFragmentPresent.this.mainFragmentView.showEnterDialogError(msg);
                } else {
                    MainFragmentPresent.this.mainFragmentView.showToast(msg);
                }
            }
        }, InavGetRoomInfo.class));
    }

    public void dealRoomResult(InavGetRoomInfo s, boolean isDialog, String ilid, String password, String role_name) {
        RoomInfo info = s.getRoom_info();
        if (s.getIs_kick_out() == 1) {
            if (isDialog) {
                this.mainFragmentView.showEnterDialogError(M.getString(R.string.main_list_kicked_out_room));
            } else {
                this.mainFragmentView.showToast(M.getString(R.string.main_list_kicked_out_room));
            }
            return;
        }
        if (isDialog) {
            this.mainFragmentView.dismissEnterDialog();
        }
        Bundle bundle = new Bundle();
        bundle.putSerializable("extra", (Serializable)s);
        bundle.putString("room_id", ilid);
        bundle.putString("password", password);
        bundle.putString("role_name", role_name);
        if (!"1".equals(role_name)) {
            if (LivePreviewManager.getInstance().isLoaded()) {
                LivePreviewManager.getInstance().showPreview(this.mainFragmentView.getContext(), bundle);
            }
        } else if (s.hasConnected) {
            this.mainFragmentView.showToast(M.getString(R.string.main_list_host_has_connected));
        } else {
            RtcVerticalManager.getInstance().startBroadCast(this.mainFragmentView.getContext(), bundle);
        }
    }
}

