/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.main.main.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.utils.DrawableUtils;
import com.vhall.appui.baselib.utils.VHToast;

public class EnterRoomDialog
extends Dialog
implements View.OnClickListener {
    public static final int IDEN_NORMAL = 0;
    public static final int IDEN_MVP = 1;
    EditText mRoomNoView;
    EditText mRoomCodeView;
    TextView mIdenView;
    TextView mErrorView;
    TextView mCancelView;
    TextView mEnterView;
    Context mContext;
    OnEnterBtnClickListener mListener;
    private int mIdentity = 0;

    public void setOnEnterBtnClickListener(OnEnterBtnClickListener listener) {
        this.mListener = listener;
    }

    public EnterRoomDialog(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public EnterRoomDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        this.mContext = context;
        this.init();
    }

    public EnterRoomDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.setContentView(R.layout.main_list_dialog_enter_room);
        this.initView();
        this.initListener();
        Window dialogWindow = this.getWindow();
        dialogWindow.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.main_list_dialog_window_bg));
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        DisplayMetrics d = this.mContext.getResources().getDisplayMetrics();
        lp.width = (int)((double)d.widthPixels * 0.8);
        dialogWindow.setAttributes(lp);
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                EnterRoomDialog.this.mErrorView.setVisibility(8);
            }
        });
        this.mErrorView.setVisibility(8);
        this.config();
    }

    private void initListener() {
        this.mCancelView.setOnClickListener((View.OnClickListener)this);
        this.mEnterView.setOnClickListener((View.OnClickListener)this);
    }

    private void initView() {
        this.mRoomNoView = (EditText)this.findViewById(R.id.et_room_number);
        this.mCancelView = (TextView)this.findViewById(R.id.btn_cancel);
        this.mEnterView = (TextView)this.findViewById(R.id.btn_join);
        this.mIdenView = (TextView)this.findViewById(R.id.tv_identity);
        this.mRoomCodeView = (EditText)this.findViewById(R.id.et_room_code);
        this.mErrorView = (TextView)this.findViewById(R.id.tv_error);
    }

    private void config() {
        float[] right = new float[]{0.0f, 0.0f, 0.0f, 0.0f, DensityUtils.dpToPx(this.getContext(), 15.0f), DensityUtils.dpToPx(this.getContext(), 15.0f), 0.0f, 0.0f};
        float[] left = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, DensityUtils.dpToPx(this.getContext(), 15.0f), DensityUtils.dpToPx(this.getContext(), 15.0f)};
        this.mCancelView.setBackground(DrawableUtils.getPressShape(0, 0, 0, left, Color.parseColor((String)"#EFEFEF")));
        this.mEnterView.setBackground(DrawableUtils.getPressShape(0, 0, 0, right, Color.parseColor((String)"#EFEFEF")));
    }

    public void show() {
        super.show();
        if (this.mRoomNoView != null) {
            this.mRoomNoView.setFocusable(true);
            this.mRoomNoView.setFocusableInTouchMode(true);
            this.mRoomNoView.requestFocus();
        }
        this.mRoomCodeView.setText((CharSequence)"");
        this.mRoomNoView.setText((CharSequence)"");
    }

    public void onClick(View v) {
        if (v == this.mCancelView) {
            this.dismiss();
        } else if (v == this.mEnterView) {
            this.attemptJoin();
        }
    }

    public void show(int iden) {
        this.mIdentity = iden;
        switch (this.mIdentity) {
            case 0: {
                this.mRoomCodeView.setVisibility(8);
                this.mIdenView.setText(R.string.main_list_viewer);
                break;
            }
            case 1: {
                this.mRoomCodeView.setVisibility(0);
                this.mIdenView.setText(R.string.main_list_assistant_guest);
                break;
            }
        }
        this.show();
    }

    private void attemptJoin() {
        String roomNo = this.mRoomNoView.getText().toString();
        if (TextUtils.isEmpty((CharSequence)roomNo)) {
            VHToast.showShortToast(M.getString(R.string.main_list_please_input_room_id));
            this.mRoomNoView.requestFocus();
            return;
        }
        if (this.mIdentity == 0) {
            if (this.mListener != null) {
                this.mListener.onClick(roomNo, "");
            }
            return;
        }
        String code = this.mRoomCodeView.getText().toString();
        if (this.mIdentity == 1 && TextUtils.isEmpty((CharSequence)code)) {
            VHToast.showShortToast(M.getString(R.string.main_list_please_input_pwd));
            this.mRoomCodeView.requestFocus();
            return;
        }
        if (this.mListener != null) {
            this.mListener.onClick(roomNo, code);
        }
    }

    public void setError(String msg) {
        this.mErrorView.setVisibility(0);
        this.mErrorView.setText((CharSequence)msg);
    }

    public void dismiss() {
        this.mRoomNoView.clearFocus();
        InputMethodManager imp = (InputMethodManager)this.mContext.getSystemService("input_method");
        imp.hideSoftInputFromWindow(this.mRoomNoView.getWindowToken(), 0);
        super.dismiss();
    }

    public static interface OnEnterBtnClickListener {
        public void onClick(String var1, String var2);
    }
}

