/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.loginview.present;

import com.vhall.appui.baselib.bean.User;
import com.vhall.appui.baselib.net.utils.BaseNetwork;
import com.vhall.appui.baselib.net.utils.CoreNetCallback;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.loginview.UserManager;
import com.vhall.appui.loginview.bean.RequestCodeBean;
import com.vhall.appui.loginview.bean.RequestLoginBean;
import com.vhall.appui.loginview.present.ILoginContract;
import com.vhall.httpclient.api.VHNetApi;

public class LoginPresent
implements ILoginContract.ILoginPresent {
    private ILoginContract.ILoginView loginView;

    public LoginPresent(ILoginContract.ILoginView loginView) {
        this.loginView = loginView;
        this.loginView.setPresenter(this);
    }

    @Override
    public void getVerificationCode(String phone) {
        RequestCodeBean requestCodeBean = new RequestCodeBean(phone);
        VHNetApi.getNetApi().doPost(BaseNetwork.getBaseRequest(requestCodeBean.fieldsToMap(), "api/code/send"), new CoreNetCallback(new CallBack(){

            public void onSuccess(Object result) {
                LoginPresent.this.loginView.getVerificationCodeFinish();
            }

            @Override
            public void onError(int eventCode, String msg) {
                LoginPresent.this.loginView.showToast(msg);
            }
        }));
    }

    @Override
    public void userLogin(String nickname, String phone, String code) {
        RequestLoginBean requestLoginBean = new RequestLoginBean(nickname, phone, code, "1");
        VHNetApi.getNetApi().doPost(BaseNetwork.getBaseRequest(requestLoginBean.fieldsToMap(), "console/auth/login"), new CoreNetCallback<User>(new CallBack<User>(){

            @Override
            public void onSuccess(User user) {
                UserManager.refreshUser(user);
                LoginPresent.this.loginView.userLoginFinish();
            }

            @Override
            public void onError(int eventCode, String msg) {
                LoginPresent.this.loginView.showToast(msg);
            }
        }, User.class));
    }
}

