/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.loginview;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.vhall.appui.baselib.bean.User;
import com.vhall.appui.baselib.service.app.AppManager;
import com.vhall.appui.baselib.service.login.IUser;
import com.vhall.appui.baselib.vss.VssSdk;
import com.vhall.appui.baselib.vss.data.UserInfoData;

public class UserManager {
    public static IUser mUser;
    public static Context mApp;

    public static void onCreate(Context context) {
        mApp = context;
        mUser = User.getFromLocal(context);
    }

    public static void refreshUser(IUser user) {
        if (user == null) {
            return;
        }
        if (mUser != null && !TextUtils.isEmpty((CharSequence)mUser.getAccountId()) && mUser.getAccountId().equals(user.getAccountId())) {
            VssSdk.getInstance().updateUserInfo(new UserInfoData(user.getAccountId(), "2", user.getNickName()));
        } else {
            VssSdk.getInstance().setUserInfo(new UserInfoData(user.getAccountId(), "2", user.getNickName()));
        }
        mUser = user;
        User.saveToLocal(mUser, mApp);
    }

    public static void updateUser(IUser user) {
        if (user == null) {
            return;
        }
        VssSdk.getInstance().updateUserInfo(new UserInfoData(user.getAccountId(), "2", user.getNickName()));
        mUser = user;
        User.saveToLocal(mUser, mApp);
    }

    public static String getUserId() {
        return mUser == null ? "" : mUser.getAccountId();
    }

    public static String getNickname() {
        return mUser == null ? "" : mUser.getNickName();
    }

    public static String getUserToken() {
        return mUser == null ? "" : mUser.getToken();
    }

    public static void exit() {
        mUser = null;
    }

    public static void clearLogin() {
        AppManager.getInstance().startMain(mApp, new Bundle());
    }
}

