/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.loginview;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.service.app.AppManager;
import com.vhall.appui.baselib.utils.DialogUtils;
import com.vhall.appui.loginview.present.ILoginContract;
import com.vhall.appui.loginview.present.LoginPresent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoginView
extends FrameLayout
implements ILoginContract.ILoginView {
    private static final String TAG = "LoginView";
    private EditText mNicknameView;
    private EditText mPhoneView;
    private EditText mCodeView;
    private View mDivider;
    private TextView mSignInBtn;
    private TextView mGetCodeBtn;
    private GetCodeCount mCount;
    private boolean isPhoneEnable = false;
    private boolean isCounting = false;
    private ILoginContract.ILoginPresent mLoginPresent;
    private Context mContext;
    private Dialog dialog;
    private static final String mNicknameRegex = "^[A-Za-z0-9\u4e00-\u9fa5]+$";
    private static final int mNicknameMaxLength = 16;
    private static final String mPhoneRegex = "^(1[3-9])\\d{9}$";

    public LoginView(@NonNull Context context) {
        super(context);
        this.mContext = context;
        this.initView();
    }

    public LoginView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView();
    }

    public LoginView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initView();
    }

    private void showLoadProgress() {
        try {
            if (this.dialog == null) {
                this.dialog = DialogUtils.showLoadingProgress(this.mContext, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void hideLoadProgress() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    private void initView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.login_view, (ViewGroup)this);
        new LoginPresent(this);
        this.mNicknameView = (EditText)this.findViewById(R.id.nickname);
        this.mPhoneView = (EditText)this.findViewById(R.id.phone);
        this.mCodeView = (EditText)this.findViewById(R.id.code);
        this.mSignInBtn = (TextView)this.findViewById(R.id.btn_signin);
        this.mGetCodeBtn = (TextView)this.findViewById(R.id.btn_getcode);
        this.mDivider = this.findViewById(R.id.divider);
        this.mPhoneView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String text = s.toString();
                if (LoginView.this.isPhoneValid(text, false)) {
                    LoginView.this.isPhoneEnable = true;
                } else {
                    LoginView.this.isPhoneEnable = false;
                }
                LoginView.this.setGetCodeBtnStatus();
            }
        });
        this.mCodeView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int id2, KeyEvent keyEvent) {
                if (id2 == 6 || id2 == 0) {
                    LoginView.this.attemptLogin();
                    return true;
                }
                return false;
            }
        });
        this.mSignInBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginView.this.attemptLogin();
            }
        });
        this.mGetCodeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LoginView.this.attemptGetCode();
            }
        });
    }

    private void setGetCodeBtnStatus() {
        if (this.isPhoneEnable && !this.isCounting) {
            this.mGetCodeBtn.setEnabled(true);
            this.mDivider.setVisibility(8);
        } else {
            this.mGetCodeBtn.setEnabled(false);
            this.mDivider.setVisibility(0);
        }
    }

    private void attemptLogin() {
        String nickname = this.mNicknameView.getText().toString();
        String phone = this.mPhoneView.getText().toString();
        String code = this.mCodeView.getText().toString();
        if (!this.isNicknameValid(nickname)) {
            return;
        }
        if (!this.isPhoneValid(phone, true)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)code)) {
            this.showToast(M.getString(R.string.login_view_error_invalid_code_empty));
            return;
        }
        this.showLoadProgress();
        this.mLoginPresent.userLogin(nickname, phone, code);
    }

    private void attemptGetCode() {
        String phone = this.mPhoneView.getText().toString();
        if (this.isPhoneValid(phone, true)) {
            this.mLoginPresent.getVerificationCode(phone);
            this.startCountDown();
        } else {
            this.mPhoneView.requestFocus();
        }
    }

    private boolean isNicknameValid(String nickname) {
        if (TextUtils.isEmpty((CharSequence)nickname)) {
            this.showToast(M.getString(R.string.login_view_error_invalid_nickname_empty));
            return false;
        }
        if (nickname.length() > 16) {
            this.showToast(M.getString(R.string.login_view_error_invalid_nickname_length));
            return false;
        }
        Pattern pattern = Pattern.compile(mNicknameRegex);
        Matcher matcher = pattern.matcher(nickname);
        if (!matcher.matches()) {
            this.showToast(M.getString(R.string.login_view_error_invalid_nickname));
            return false;
        }
        return true;
    }

    private boolean isPhoneValid(String phone, boolean showError) {
        if (TextUtils.isEmpty((CharSequence)phone)) {
            if (showError) {
                this.showToast(M.getString(R.string.login_view_error_invalid_phone_empty));
            }
            return false;
        }
        Pattern pattern = Pattern.compile(mPhoneRegex);
        Matcher matcher = pattern.matcher(phone);
        if (!matcher.matches()) {
            if (showError) {
                this.showToast(M.getString(R.string.login_view_error_invalid_phone));
            }
            return false;
        }
        return true;
    }

    private boolean isCodeValid(String code) {
        if (TextUtils.isEmpty((CharSequence)code)) {
            this.showToast(M.getString(R.string.login_view_error_invalid_code_empty));
            return false;
        }
        return true;
    }

    private void startCountDown() {
        this.mGetCodeBtn.setEnabled(false);
        this.mDivider.setVisibility(0);
        if (this.mCount == null) {
            this.mCount = new GetCodeCount(60000L, 1000L);
        }
        this.mCount.start();
    }

    @Override
    public void getVerificationCodeFinish() {
        this.showToast(M.getString(R.string.login_view_send_msg_success));
    }

    @Override
    public void userLoginFinish() {
        this.hideLoadProgress();
        AppManager.getInstance().startMain(this.mContext, new Bundle());
        Activity activity = (Activity)this.mContext;
        if (this.mCount != null) {
            this.mCount.cancel();
        }
        activity.finish();
    }

    @Override
    public void setPresenter(ILoginContract.ILoginPresent presenter) {
        this.mLoginPresent = presenter;
    }

    @Override
    public void showToast(String content) {
        this.hideLoadProgress();
        Toast.makeText((Context)this.mContext, (CharSequence)content, (int)0).show();
    }

    class GetCodeCount
    extends CountDownTimer {
        GetCodeCount(long millisInFuture, long countDownInterval) {
            super(millisInFuture, countDownInterval);
        }

        public void onTick(long millisUntilFinished) {
            LoginView.this.isCounting = true;
            LoginView.this.mGetCodeBtn.setText((CharSequence)String.format("%ss", millisUntilFinished / 1000L));
        }

        public void onFinish() {
            LoginView.this.isCounting = false;
            LoginView.this.setGetCodeBtnStatus();
            LoginView.this.mGetCodeBtn.setText((CharSequence)LoginView.this.getResources().getString(R.string.login_view_action_get_code));
        }
    }
}

