/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.loginview;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import com.vhall.appui.baselib.core.BaseServiceImpl;
import com.vhall.appui.baselib.service.login.IAccountListener;
import com.vhall.appui.baselib.service.login.IAccountService;
import com.vhall.appui.baselib.service.login.IUser;
import com.vhall.appui.baselib.service.loginmodule.LoginModuleManager;
import com.vhall.appui.loginview.LoginView;
import com.vhall.appui.loginview.UserManager;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;

public class AccountImpl
extends BaseServiceImpl
implements IAccountService {
    private List<IAccountListener> mAccountListeners = new ArrayList<IAccountListener>();

    @Override
    public void startLogin(Context activity, Bundle bundle) {
        if (LoginModuleManager.getInstance().isLoaded()) {
            LoginModuleManager.getInstance().startLogin(activity, bundle);
        }
    }

    @Override
    public View loginView(Context activity, Bundle bundle) {
        return new LoginView(activity);
    }

    @Override
    public String getUserId() {
        return UserManager.getUserId();
    }

    @Override
    public boolean isLogin() {
        return !TextUtils.isEmpty((CharSequence)UserManager.getUserToken());
    }

    @Override
    public String getToken() {
        return UserManager.getUserToken();
    }

    @Override
    public String getNickName() {
        return UserManager.getNickname();
    }

    @Override
    public void logOut(Bundle bundle) {
        UserManager.exit();
        this.notifyAccountLogoutInternalImpl(bundle);
    }

    @Override
    public Disposable logOutByNet(Bundle bundle) {
        this.logOut(new Bundle());
        return null;
    }

    @Override
    public IUser getUser() {
        return UserManager.mUser;
    }

    @Override
    public void refreshUser(IUser user) {
        UserManager.refreshUser(user);
    }

    @Override
    public String getVersion() {
        return "1.2.9";
    }

    @Override
    public void addAccountListener(IAccountListener iAccountListener) {
        this.mAccountListeners.add(iAccountListener);
    }

    @Override
    public void unRegisterListener(IAccountListener iAccountListener) {
        this.mAccountListeners.remove(iAccountListener);
    }

    private void notifyAccountLogoutInternalImpl(Bundle bundle) {
        for (int i = this.mAccountListeners.size() - 1; i >= 0; --i) {
            this.mAccountListeners.get(i).loginOut(bundle);
        }
    }
}

