/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.livepreview;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.VhSdk;
import com.vhall.appui.baselib.base.BaseActivity;
import com.vhall.appui.baselib.network.CommonManagerNetWrapper;
import com.vhall.appui.baselib.service.countdown.ICountDownTimeCallBack;
import com.vhall.appui.baselib.service.countdown.ICountViewPanelView;
import com.vhall.appui.baselib.service.pictureinpicture.IPictureInPictureListener;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureConstance;
import com.vhall.appui.baselib.service.pictureinpicture.PictureInPictureManager;
import com.vhall.appui.baselib.service.watchlive.WatchVerticalLiveManager;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.InavGetRoomInfo;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.data.RoomInfo;
import com.vhall.appui.baselib.vss.module.room.ProxyVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class LivePreviewActivity
extends BaseActivity {
    private TextView preview_countdown_day;
    private TextView preview_countdown_finish_tv;
    private TextView preview_countdown_finish_tv1;
    private TextView preview_notification_tv;
    private TextView live_tips;
    private String mOriginChannel;
    private InavGetRoomInfo inavGetRoomInfo;
    private RoomInfo roomInfo;
    private ImageView ivCover;
    private ICountViewPanelView preview_countdown_time;
    private Bundle bundle;
    private boolean leaveRoom = true;
    private ConstraintLayout premission_layout;
    private ConstraintLayout layout;
    private boolean isCounting = true;
    public static final String TIME_PATTERN3 = "yyyy-MM-dd HH:mm:ss";
    private IVssMessageListener vssMessageListener = new ProxyVssMessageListener(new IVssMessageListener(){

        @Override
        public void onMessage(MessageData msg) {
            switch (msg.getType()) {
                case "record_default_set": {
                    LivePreviewActivity.this.refreshPageData();
                    break;
                }
                case "live_start": {
                    LivePreviewActivity.this.showStatus(3);
                    LivePreviewActivity.this.refreshPageData();
                    break;
                }
                case "live_over": {
                    LivePreviewActivity.this.showStatus(4);
                    LivePreviewActivity.this.refreshPageData();
                    VhSdk.getInstance().closePIPView((Context)LivePreviewActivity.this);
                    if (LivePreviewActivity.this.preview_countdown_time == null) break;
                    LivePreviewActivity.this.preview_countdown_time.onDestroy();
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
        }
    });

    public static void startActivity(Context context, Bundle bundle) {
        Intent intent = new Intent(context, LivePreviewActivity.class);
        intent.putExtra("extra", bundle);
        context.startActivity(intent);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.activity_live_preview_activity;
    }

    @Override
    protected void onResume() {
        ConstraintLayout.LayoutParams layoutParams;
        super.onResume();
        if (this.roomInfo != null && this.roomInfo.status == 0 && !this.isCounting) {
            if (VhSdk.getInstance().vhallCallback != null && VhSdk.getInstance().vhallCallback.checkNotifyPermissions(this)) {
                this.preview_notification_tv.setVisibility(8);
            } else {
                this.preview_notification_tv.setText((CharSequence)"\u8bf7\u6253\u5f00\u63a8\u9001\u901a\u77e5\u6743\u9650\uff0c\u4ee5\u514d\u9519\u8fc7\u5f00\u64ad\u63d0\u9192");
                this.preview_notification_tv.getPaint().setFlags(8);
            }
            layoutParams = (ConstraintLayout.LayoutParams)this.preview_notification_tv.getLayoutParams();
            layoutParams.topMargin = DensityUtils.dpToPxInt(22.0f);
            this.preview_notification_tv.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else if (this.roomInfo != null && this.roomInfo.status == 0 && this.isCounting) {
            if (VhSdk.getInstance().vhallCallback != null && VhSdk.getInstance().vhallCallback.checkNotifyPermissions(this)) {
                this.preview_notification_tv.setText((CharSequence)"\u4f60\u5c06\u5728\u5f00\u64ad\u65f6\u6536\u5230\u63a8\u9001\u63d0\u9192");
                this.preview_notification_tv.getPaint().setFlags(0);
            } else {
                this.preview_notification_tv.setText((CharSequence)"\u8bf7\u6253\u5f00\u63a8\u9001\u901a\u77e5\u6743\u9650\uff0c\u4ee5\u514d\u9519\u8fc7\u5f00\u64ad\u63d0\u9192");
                this.preview_notification_tv.getPaint().setFlags(8);
            }
            layoutParams = (ConstraintLayout.LayoutParams)this.preview_notification_tv.getLayoutParams();
            layoutParams.topMargin = DensityUtils.dpToPxInt(22.0f);
            this.preview_notification_tv.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (this.inavGetRoomInfo != null) {
            RoomInfo roomInfo;
            if (!PictureInPictureConstance.havePicture) {
                roomInfo = this.inavGetRoomInfo.getRoom_info();
                if (null != roomInfo) {
                    this.mOriginChannel = roomInfo.getChannel_id();
                    roomInfo.setChannel_id(roomInfo.nify_channel);
                    this.inavGetRoomInfo.setRoom_info(roomInfo);
                }
            } else if (this.inavGetRoomInfo != null) {
                roomInfo = this.inavGetRoomInfo.getRoom_info();
                if (roomInfo != null && !TextUtils.isEmpty((CharSequence)this.mOriginChannel)) {
                    roomInfo.setChannel_id(this.mOriginChannel);
                }
                this.inavGetRoomInfo.setRoom_info(roomInfo);
            }
            if (this.inavGetRoomInfo.room_info != null) {
                VssRoomManager.getInstance().leaveRoom(this.inavGetRoomInfo.room_info.channel_id, this.vssMessageListener);
            } else {
                VssRoomManager.getInstance().leaveRoom(null, this.vssMessageListener);
            }
            VssRoomManager.getInstance().removeVssMessageListener(this.vssMessageListener);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    VssRoomManager.getInstance().enterRoom(LivePreviewActivity.this.inavGetRoomInfo, new CallBack<ResponseRoomInfo>(){

                        @Override
                        public void onSuccess(ResponseRoomInfo result) {
                            VssRoomManager.getInstance().setVssMessageListener(LivePreviewActivity.this.vssMessageListener);
                            LivePreviewActivity.this.refreshPageData();
                        }

                        @Override
                        public void onError(int eventCode, String msg) {
                        }
                    });
                }
            }, 800L);
        }
    }

    @Override
    protected void initView() {
        Glide.with((Context)M.context).resumeRequests();
        this.ivCover = (ImageView)this.findViewById(R.id.iv_cover);
        this.premission_layout = (ConstraintLayout)this.findViewById(R.id.premission_layout);
        this.findViewById(R.id.back_live_preview).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LivePreviewActivity.this.finish();
            }
        });
        this.layout = (ConstraintLayout)this.findViewById(R.id.layout);
        this.layout.setVisibility(0);
        this.preview_countdown_day = (TextView)this.findViewById(R.id.preview_countdown_day);
        this.preview_notification_tv = (TextView)this.findViewById(R.id.preview_notification_tv);
        this.live_tips = (TextView)this.findViewById(R.id.live_tips);
        this.preview_countdown_time = (ICountViewPanelView)this.findViewById(R.id.preview_countdown_time);
        this.preview_countdown_finish_tv = (TextView)this.findViewById(R.id.preview_countdown_finish_tv);
        this.preview_countdown_finish_tv1 = (TextView)this.findViewById(R.id.preview_countdown_finish_tv1);
        this.preview_countdown_time.setCountDownTimeCallBack(new ICountDownTimeCallBack(){

            @Override
            public void onFinish() {
                LivePreviewActivity.this.isCounting = false;
                LivePreviewActivity.this.preview_countdown_day.setVisibility(8);
                LivePreviewActivity.this.preview_countdown_time.setVisibility(8);
                LivePreviewActivity.this.preview_notification_tv.setVisibility(8);
                LivePreviewActivity.this.preview_countdown_finish_tv.setVisibility(0);
                LivePreviewActivity.this.preview_countdown_finish_tv1.setVisibility(0);
                if (LivePreviewActivity.this.roomInfo != null && ((LivePreviewActivity)LivePreviewActivity.this).roomInfo.status == 1) {
                    LivePreviewActivity.this.showStatus(3);
                }
                if (LivePreviewActivity.this.preview_countdown_time != null) {
                    LivePreviewActivity.this.preview_countdown_time.onDestroy();
                }
            }

            @Override
            public void setDayText(long day) {
                LivePreviewActivity.this.isCounting = true;
                if (LivePreviewActivity.this.roomInfo != null && ((LivePreviewActivity)LivePreviewActivity.this).roomInfo.status == 1) {
                    LivePreviewActivity.this.showStatus(3);
                }
                if (day == 0L) {
                    LivePreviewActivity.this.preview_countdown_day.setText((CharSequence)"\u8ddd\u79bb\u5f00\u59cb Today");
                } else if (!TextUtils.equals((CharSequence)LivePreviewActivity.this.preview_countdown_day.getText().toString(), (CharSequence)("\u8ddd\u79bb\u5f00\u59cb " + day + " days"))) {
                    LivePreviewActivity.this.preview_countdown_day.setText((CharSequence)("\u8ddd\u79bb\u5f00\u59cb " + day + " days"));
                }
            }
        });
        this.initListener();
    }

    public void showStatus(int status) {
        this.preview_notification_tv.getPaint().setFlags(8);
        this.preview_countdown_day.setVisibility(8);
        this.preview_countdown_time.setVisibility(8);
        this.preview_countdown_finish_tv.setVisibility(0);
        this.preview_countdown_finish_tv1.setVisibility(0);
        switch (status) {
            case 1: {
                this.preview_countdown_finish_tv.setText((CharSequence)"\u8bf7\u7a0d\u540e");
                this.preview_countdown_finish_tv1.setText((CharSequence)"\u76f4\u64ad\u9a6c\u4e0a\u5f00\u59cb");
                this.preview_notification_tv.setVisibility(4);
                break;
            }
            case 2: {
                this.preview_countdown_finish_tv.setText((CharSequence)"\u76f4\u64ad\u4e2d");
                this.preview_countdown_finish_tv1.setText((CharSequence)"\u60a8\u5df2\u88ab\u8e22\u51fa");
                this.preview_notification_tv.setVisibility(8);
                this.live_tips.setVisibility(0);
                this.live_tips.setText((CharSequence)"\u7acb\u5373\u89c2\u770b\u76f4\u64ad");
                break;
            }
            case 3: {
                this.preview_countdown_finish_tv1.setVisibility(8);
                this.preview_countdown_finish_tv.setText((CharSequence)"\u76f4\u64ad\u4e2d");
                this.preview_notification_tv.setVisibility(8);
                this.live_tips.setVisibility(0);
                this.live_tips.setText((CharSequence)"\u7acb\u5373\u89c2\u770b\u76f4\u64ad");
                break;
            }
            case 4: {
                this.preview_notification_tv.getPaint().setFlags(0);
                this.preview_countdown_finish_tv.setText((CharSequence)"\u76f4\u64ad\u5df2\u7ed3\u675f");
                this.preview_countdown_finish_tv1.setText((CharSequence)"\u6b63\u5728\u4e3a\u60a8\u51c6\u5907\u76f4\u64ad\u56de\u653e");
                this.preview_notification_tv.setText((CharSequence)"\u7a0d\u540e\u53ef\u89c2\u770b\u76f4\u64ad\u7cbe\u5f69\u56de\u653e");
                this.live_tips.setVisibility(8);
                this.preview_notification_tv.setVisibility(0);
                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.preview_notification_tv.getLayoutParams();
                layoutParams.topMargin = DensityUtils.dpToPxInt(8.0f);
                this.preview_notification_tv.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                break;
            }
            case 5: {
                this.preview_countdown_finish_tv.setText((CharSequence)"\u76f4\u64ad\u5df2\u7ed3\u675f");
                this.preview_countdown_finish_tv1.setVisibility(8);
                this.preview_notification_tv.setVisibility(8);
                this.live_tips.setVisibility(0);
                this.live_tips.setText((CharSequence)"\u89c2\u770b\u76f4\u64ad\u56de\u653e");
            }
        }
    }

    private void initListener() {
        this.premission_layout.findViewById(R.id.premission_close).setOnClickListener(v -> {
            this.premission_layout.setVisibility(8);
            this.layout.setVisibility(0);
        });
        this.premission_layout.findViewById(R.id.start_permission).setOnClickListener(v -> {
            this.premission_layout.setVisibility(8);
            this.layout.setVisibility(0);
            if (VhSdk.getInstance().vhallCallback != null) {
                VhSdk.getInstance().vhallCallback.openNotifyPermissions(this);
            }
        });
        this.live_tips.setOnClickListener(v -> {
            if (this.inavGetRoomInfo != null) {
                RoomInfo roomInfo = this.inavGetRoomInfo.getRoom_info();
                if (roomInfo != null && !TextUtils.isEmpty((CharSequence)this.mOriginChannel)) {
                    roomInfo.setChannel_id(this.mOriginChannel);
                }
                this.inavGetRoomInfo.setRoom_info(roomInfo);
            }
            HashMap<String, String> param = new HashMap<String, String>();
            if (this.inavGetRoomInfo != null && this.inavGetRoomInfo.room_info != null) {
                param.put("room_id", this.inavGetRoomInfo.room_info.room_id + "");
                param.put("il_id", this.inavGetRoomInfo.room_info.il_id + "");
            }
            param.put("role_name", this.bundle.getString("role_name"));
            CommonManagerNetWrapper.getRoomInfo(param, new CallBack<InavGetRoomInfo>(){

                @Override
                public void onSuccess(InavGetRoomInfo result) {
                    try {
                        if (LivePreviewActivity.this.inavGetRoomInfo != null && ((LivePreviewActivity)LivePreviewActivity.this).inavGetRoomInfo.room_info != null) {
                            VssRoomManager.getInstance().leaveRoom(((LivePreviewActivity)LivePreviewActivity.this).inavGetRoomInfo.room_info.channel_id, LivePreviewActivity.this.vssMessageListener);
                        } else {
                            VssRoomManager.getInstance().leaveRoom(null, LivePreviewActivity.this.vssMessageListener);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LivePreviewActivity.this.inavGetRoomInfo = result;
                    if (TextUtils.equals((CharSequence)LivePreviewActivity.this.live_tips.getText().toString(), (CharSequence)"\u7acb\u5373\u89c2\u770b\u76f4\u64ad")) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("room_id", ((LivePreviewActivity)LivePreviewActivity.this).inavGetRoomInfo.room_info.room_id + "");
                        params.put("type", "1");
                        CommonManagerNetWrapper.joinRoomStarrt(params, new CallBack<String>(){

                            @Override
                            public void onSuccess(String result) {
                                if (!TextUtils.isEmpty((CharSequence)result)) {
                                    try {
                                        JSONObject jsonObject = new JSONObject(result);
                                        int data = jsonObject.optInt("data");
                                        String msg = jsonObject.optString("msg");
                                        if (data == 1) {
                                            if (WatchVerticalLiveManager.getInstance().isLoaded()) {
                                                LivePreviewActivity.this.fixChannelId();
                                                Bundle bundle = new Bundle();
                                                bundle.putSerializable("extra", (Serializable)LivePreviewActivity.this.inavGetRoomInfo);
                                                WatchVerticalLiveManager.getInstance().startWatchLiveActivity((Context)LivePreviewActivity.this, bundle);
                                                LivePreviewActivity.this.leaveRoom = false;
                                            }
                                        } else {
                                            LivePreviewActivity.this.baseShowToast("\u5f53\u524d\u6d3b\u52a8\u592a\u706b\u7206\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                                        }
                                    }
                                    catch (JSONException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                LivePreviewActivity.this.baseShowToast(msg);
                            }
                        });
                    } else if (TextUtils.equals((CharSequence)LivePreviewActivity.this.live_tips.getText().toString(), (CharSequence)"\u89c2\u770b\u76f4\u64ad\u56de\u653e")) {
                        Bundle bundle = new Bundle();
                        bundle.putSerializable("extra", (Serializable)LivePreviewActivity.this.inavGetRoomInfo);
                        WatchVerticalLiveManager.getInstance().startWatchLiveActivity(LivePreviewActivity.this.mContext, bundle);
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    VHToast.showShortToast(msg);
                }
            });
        });
        this.preview_notification_tv.setOnClickListener(v -> {
            if (TextUtils.equals((CharSequence)this.preview_notification_tv.getText().toString(), (CharSequence)"\u8bf7\u6253\u5f00\u63a8\u9001\u901a\u77e5\u6743\u9650\uff0c\u4ee5\u514d\u9519\u8fc7\u5f00\u64ad\u63d0\u9192")) {
                if (VhSdk.getInstance().vhallCallback != null && VhSdk.getInstance().vhallCallback.checkNotifyPermissions(this)) {
                    VhLog.d("\u5df2\u5f00\u542fpush\u6743\u9650");
                    return;
                }
                this.premission_layout.setVisibility(0);
                this.layout.setVisibility(8);
            }
        });
    }

    @Override
    protected void initData() {
        if (PictureInPictureManager.getInstance().isLoaded()) {
            IPictureInPictureListener.getInstance().registCloseListenerToPip(new IPictureInPictureListener.CloseCallback(){

                @Override
                public void callback() {
                    if (LivePreviewActivity.this.inavGetRoomInfo != null) {
                        RoomInfo roomInfo = LivePreviewActivity.this.inavGetRoomInfo.getRoom_info();
                        if (null != roomInfo) {
                            LivePreviewActivity.this.mOriginChannel = roomInfo.getChannel_id();
                            roomInfo.setChannel_id(roomInfo.nify_channel);
                            LivePreviewActivity.this.inavGetRoomInfo.setRoom_info(roomInfo);
                        }
                        if (((LivePreviewActivity)LivePreviewActivity.this).inavGetRoomInfo.room_info != null) {
                            VssRoomManager.getInstance().leaveRoom(((LivePreviewActivity)LivePreviewActivity.this).inavGetRoomInfo.room_info.channel_id, LivePreviewActivity.this.vssMessageListener);
                        } else {
                            VssRoomManager.getInstance().leaveRoom(null, LivePreviewActivity.this.vssMessageListener);
                        }
                        VssRoomManager.getInstance().removeVssMessageListener(LivePreviewActivity.this.vssMessageListener);
                        VssRoomManager.getInstance().enterRoom(LivePreviewActivity.this.inavGetRoomInfo, new CallBack<ResponseRoomInfo>(){

                            @Override
                            public void onSuccess(ResponseRoomInfo result) {
                                VssRoomManager.getInstance().setVssMessageListener(LivePreviewActivity.this.vssMessageListener);
                                LivePreviewActivity.this.refreshPageData();
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                            }
                        });
                    }
                }
            });
        }
        this.bundle = this.getIntent().getBundleExtra("extra");
        if (this.bundle == null) {
            return;
        }
        this.inavGetRoomInfo = (InavGetRoomInfo)this.bundle.getSerializable("extra");
        if (this.refreshUI()) {
            return;
        }
        RoomInfo roomInfo = this.inavGetRoomInfo.getRoom_info();
        if (null != roomInfo) {
            this.mOriginChannel = roomInfo.getChannel_id();
            roomInfo.setChannel_id(roomInfo.nify_channel);
            this.inavGetRoomInfo.setRoom_info(roomInfo);
        }
        VssRoomManager.getInstance().enterRoom(this.inavGetRoomInfo, new CallBack<ResponseRoomInfo>(){

            @Override
            public void onSuccess(ResponseRoomInfo result) {
                VssRoomManager.getInstance().setVssMessageListener(LivePreviewActivity.this.vssMessageListener);
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }

    private boolean refreshUI() {
        if (this.inavGetRoomInfo == null || this.inavGetRoomInfo.getRoom_info() == null) {
            return true;
        }
        this.roomInfo = this.inavGetRoomInfo.getRoom_info();
        this.mOriginChannel = this.roomInfo.getChannel_id();
        RequestListener mRequestListener = new RequestListener(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target target, boolean isFirstResource) {
                VhLog.d(e.getMessage());
                return false;
            }

            public boolean onResourceReady(Object resource, Object model, Target target, DataSource dataSource, boolean isFirstResource) {
                VhLog.d(model + "   ----   success");
                return false;
            }
        };
        ((RequestBuilder)Glide.with((Context)M.context).load(this.roomInfo.getCover_image()).dontAnimate()).apply((BaseRequestOptions)new RequestOptions()).listener(mRequestListener).into(this.ivCover);
        if (this.inavGetRoomInfo != null && this.inavGetRoomInfo.is_kick_out == 1) {
            this.showStatus(2);
        }
        if (this.roomInfo != null && this.roomInfo.status == 0) {
            if (this.preview_countdown_time != null && !TextUtils.isEmpty((CharSequence)this.roomInfo.start_time)) {
                this.preview_countdown_time.setShowTime(LivePreviewActivity.stringToDate(this.roomInfo.start_time));
                this.preview_countdown_time.onStart();
                this.isCounting = true;
            }
        } else if (this.roomInfo != null && this.roomInfo.status == 1) {
            if (this.preview_countdown_time != null && !TextUtils.isEmpty((CharSequence)this.roomInfo.start_time)) {
                this.preview_countdown_time.setShowTime(LivePreviewActivity.stringToDate(this.roomInfo.start_time));
                this.preview_countdown_time.onStart();
                this.isCounting = true;
            }
        } else if (this.roomInfo != null && this.roomInfo.status == 2) {
            if (VhSdk.getInstance().lastActivity) {
                VhSdk.getInstance().closePIPView((Context)this);
            }
            if (this.roomInfo != null && !TextUtils.isEmpty((CharSequence)this.roomInfo.record_id)) {
                this.showStatus(5);
            } else {
                this.showStatus(4);
            }
        }
        return false;
    }

    private void fixChannelId() {
        if (!TextUtils.isEmpty((CharSequence)this.mOriginChannel)) {
            this.roomInfo.setChannel_id(this.mOriginChannel);
            this.inavGetRoomInfo.setRoom_info(this.roomInfo);
        }
    }

    public static Date stringToDate(String time) {
        Date result = new Date();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(TIME_PATTERN3);
            result = sdf.parse(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Glide.with((Context)M.context).pauseRequests();
        if (!PictureInPictureConstance.havePicture) {
            if (this.inavGetRoomInfo != null && this.inavGetRoomInfo.room_info != null) {
                VssRoomManager.getInstance().leaveRoom(this.inavGetRoomInfo.room_info.channel_id, this.vssMessageListener);
            } else {
                VssRoomManager.getInstance().leaveRoom(null, this.vssMessageListener);
            }
        }
        VssRoomManager.getInstance().removeVssMessageListener(this.vssMessageListener);
        this.preview_countdown_time.onDestroy();
    }

    private void refreshPageData() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("room_id", this.bundle.getString("room_id"));
        param.put("role_name", this.bundle.getString("role_name"));
        CommonManagerNetWrapper.getRoomInfo(param, new CallBack<InavGetRoomInfo>(){

            @Override
            public void onSuccess(InavGetRoomInfo result) {
                LivePreviewActivity.this.inavGetRoomInfo = result;
                LivePreviewActivity.this.refreshUI();
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhLog.d(msg);
            }
        });
    }
}

