/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.like.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.vhall.appui.baselib.service.like.ITouchLikeCallBack;
import com.vhall.appui.baselib.service.like.ITouchLikeView;
import com.vhall.appui.baselib.service.like.LikeManager;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.vss.CallBack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class PressLikeTouchView
extends RelativeLayout
implements ITouchLikeView {
    private int clickLikeNumber = 0;
    private String room_id;
    private CountDownTimer likeNumTimer = new CountDownTimer(2000L, 1000L){

        public void onTick(long millisUntilFinished) {
        }

        public void onFinish() {
            PressLikeTouchView.this.pushLikeNum(PressLikeTouchView.this.clickLikeNumber, PressLikeTouchView.this.room_id);
            PressLikeTouchView.this.clickLikeNumber = 0;
        }
    };
    private Context mContext;
    private String assetsName = "vhlike.svga";
    private float[] mRandomAngle = new float[]{-25.0f, 0.0f, -15.0f, 0.0f, 15.0f, 0.0f, 25.0f};
    private SVGAParser mSVGAParse;
    private int DRAWABLE_SIZE = 12;
    private List<SVGADrawable> svgaDrawableList = new ArrayList<SVGADrawable>();
    private int mWidth = 800;
    private int mHeight = 800;
    private static boolean mBackKeyPressed = false;
    private int num = 0;
    private ITouchLikeCallBack touchLikeCallBack;

    public void setRoom_id(String room_id) {
        this.room_id = room_id;
    }

    private void pushLikeNum(int num, String room_id) {
        LikeManager.getInstance().sendLike(String.valueOf(num), room_id, new CallBack(){

            public void onSuccess(Object result) {
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public PressLikeTouchView(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public PressLikeTouchView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public PressLikeTouchView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @Override
    public void changeImage(String assetsName) {
        if (!TextUtils.isEmpty((CharSequence)assetsName)) {
            this.assetsName = assetsName;
            this.initDrawable();
        }
    }

    private void initView(Context context) {
        this.mContext = context;
        this.mSVGAParse = new SVGAParser(this.mContext);
        this.initDrawable();
    }

    private void initDrawable() {
        this.svgaDrawableList.clear();
        this.mSVGAParse.parse(this.assetsName, new SVGAParser.ParseCompletion(){

            public void onComplete(SVGAVideoEntity mSVGAVideoEntity) {
                for (int i = 0; i < PressLikeTouchView.this.DRAWABLE_SIZE; ++i) {
                    PressLikeTouchView.this.svgaDrawableList.add(new SVGADrawable(mSVGAVideoEntity));
                }
            }

            public void onError() {
            }
        });
    }

    @Override
    public void setTouchLikeCallBack(ITouchLikeCallBack touchLikeCallBack) {
        this.touchLikeCallBack = touchLikeCallBack;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!mBackKeyPressed) {
            mBackKeyPressed = true;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    mBackKeyPressed = false;
                }
            }, 800L);
        } else {
            final SVGAImageView imageView = new SVGAImageView(this.mContext);
            imageView.setImageDrawable((Drawable)this.svgaDrawableList.get(this.num % this.DRAWABLE_SIZE));
            ++this.num;
            imageView.setLoops(1);
            imageView.startAnimation();
            imageView.setCallback(new SVGACallback(){

                public void onPause() {
                }

                public void onFinished() {
                    PressLikeTouchView.this.removeViewInLayout((View)imageView);
                }

                public void onRepeat() {
                }

                public void onStep(int i, double v) {
                }
            });
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.mWidth, this.mHeight);
            int xLeft = (int)event.getX() - this.mWidth / 2;
            int yTop = (int)event.getY() - this.mHeight / 2;
            layoutParams.setMargins(xLeft, yTop, 0, 0);
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            imageView.setRotation(this.mRandomAngle[new Random().nextInt(this.mRandomAngle.length)]);
            this.addView((View)imageView);
            ++this.clickLikeNumber;
            if (this.touchLikeCallBack != null) {
                this.touchLikeCallBack.touchLike();
            }
            this.likeNumTimer.cancel();
            this.likeNumTimer.start();
        }
        return super.onTouchEvent(event);
    }
}

