/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.countdown;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.service.countdown.ICountDown;
import com.vhall.appui.baselib.service.countdown.ICountDownTimeCallBack;
import java.util.Date;
import java.util.Locale;

class CountDownView
extends RelativeLayout
implements ICountDown {
    private Context mContext;
    private Date date;
    int baseColor;
    private String topString;
    private int topStringVisibility;
    private int topStringColor;
    private int topStringSize;
    private int timeNumColor;
    private int timeTextColor;
    private LinearLayout llTimeShow;
    private CountDownTimer countDownTimer;
    private View day;
    private View hour;
    private View minute;
    private View second;
    private ICountDownTimeCallBack countDownTimeCallBack;
    private String endShowText;

    @Override
    public void setCountDownTimeCallBack(ICountDownTimeCallBack countDownTimeCallBack) {
        this.countDownTimeCallBack = countDownTimeCallBack;
    }

    public CountDownView(@NonNull Context context) {
        super(context);
        this.topStringColor = this.baseColor = Color.parseColor((String)"#ffffff");
        this.timeNumColor = this.baseColor;
        this.timeTextColor = this.baseColor;
        this.init(context, null, 0);
    }

    public CountDownView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.topStringColor = this.baseColor = Color.parseColor((String)"#ffffff");
        this.timeNumColor = this.baseColor;
        this.timeTextColor = this.baseColor;
        this.init(context, attrs, 0);
    }

    public CountDownView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.topStringColor = this.baseColor = Color.parseColor((String)"#ffffff");
        this.timeNumColor = this.baseColor;
        this.timeTextColor = this.baseColor;
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this.mContext = context;
        this.initView();
        this.initData(attrs);
    }

    private void initData(AttributeSet attrs) {
        TypedArray ta = this.mContext.obtainStyledAttributes(attrs, R.styleable.CountDownView);
        this.topString = ta.getString(R.styleable.CountDownView_topText);
        this.topStringVisibility = ta.getInt(R.styleable.CountDownView_topTextVisibility, 0);
        this.topStringColor = ta.getColor(R.styleable.CountDownView_topTextColor, this.baseColor);
        this.topStringSize = ta.getDimensionPixelSize(R.styleable.CountDownView_topTextSize, R.dimen.top_text_size);
        this.timeNumColor = ta.getColor(R.styleable.CountDownView_timeNumColor, this.baseColor);
        this.timeTextColor = ta.getColor(R.styleable.CountDownView_timeTextColor, this.baseColor);
    }

    private void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.count_down_view_layout, (ViewGroup)this);
        this.llTimeShow = (LinearLayout)this.findViewById(R.id.ll_time_show);
        this.day = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.count_down_time_item, null);
        this.hour = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.count_down_time_item, null);
        this.minute = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.count_down_time_item, null);
        this.second = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.count_down_time_item, null);
        this.llTimeShow.removeAllViews();
        this.llTimeShow.setOrientation(0);
        this.llTimeShow.addView(this.day);
        this.llTimeShow.addView(this.hour);
        this.llTimeShow.addView(this.minute);
        this.llTimeShow.addView(this.second);
    }

    @Override
    public void setShowTime(Date date) {
        this.date = date;
    }

    @Override
    public void onStart() {
        if (this.date == null) {
            return;
        }
        this.initTask();
    }

    private void setTimeShow(View view, String textNum, String text) {
        TextView tvNum = (TextView)view.findViewById(R.id.tv_num);
        TextView tvText = (TextView)view.findViewById(R.id.tv_text);
        tvNum.setTextColor(this.timeNumColor);
        tvNum.setText((CharSequence)textNum);
        tvText.setTextColor(this.timeTextColor);
        tvText.setText((CharSequence)text);
    }

    @Override
    public void onDestroy() {
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
        }
    }

    private void initTask() {
        long millisInFuture = this.getMillisInFuture();
        if (millisInFuture < 1000L) {
            if (this.countDownTimeCallBack != null) {
                this.countDownTimeCallBack.onFinish();
            }
            return;
        }
        this.countDownTimer = new CountDownTimer(millisInFuture, 1000L){

            public void onTick(long millisUntilFinished) {
                CountDownView.this.countTime(millisUntilFinished);
            }

            public void onFinish() {
                if (CountDownView.this.countDownTimeCallBack != null) {
                    CountDownView.this.countDownTimeCallBack.onFinish();
                }
            }
        };
        if (this.countDownTimer != null) {
            this.countDownTimer.start();
        }
    }

    private long getMillisInFuture() {
        Date now = new Date(System.currentTimeMillis());
        return Math.max(this.date.getTime() - now.getTime(), 0L);
    }

    private void countTime(long millisUntilFinished) {
        long days = millisUntilFinished / 86400000L;
        if (this.countDownTimeCallBack != null) {
            this.countDownTimeCallBack.setDayText(days);
        }
        long hours = millisUntilFinished % 86400000L / 3600000L;
        long minutes = millisUntilFinished % 3600000L / 60000L;
        long seconds = millisUntilFinished % 60000L / 1000L;
        this.setTimeShow(this.hour, String.format(Locale.CHINA, "%02d", hours), ":");
        this.setTimeShow(this.minute, String.format(Locale.CHINA, "%02d", minutes), ":");
        this.setTimeShow(this.second, String.format(Locale.CHINA, "%02d", seconds), "");
    }
}

