/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat.widget;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.style.ReplacementSpan;

public class RadiusBackgroundSpan
extends ReplacementSpan {
    private int mSize;
    private int mColor;
    private int mRadius;
    private boolean mCircle;

    public RadiusBackgroundSpan(int color2, int radius) {
        this.mColor = color2;
        this.mRadius = radius;
    }

    public RadiusBackgroundSpan(int color2, int radius, boolean circle) {
        this.mColor = color2;
        this.mRadius = radius;
        this.mCircle = circle;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        this.mSize = (int)(paint.measureText(text, start, end) + (float)(2 * this.mRadius));
        return this.mSize;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        int color2 = paint.getColor();
        paint.setColor(this.mColor);
        paint.setAntiAlias(true);
        RectF oval = new RectF(x, (float)y + paint.ascent(), x + (float)this.mSize, (float)y + paint.descent());
        if (this.mCircle) {
            this.mRadius = (int)Math.min(oval.right - oval.left, oval.bottom - oval.top) / 2;
            canvas.drawCircle((oval.right - oval.left) / 2.0f, (oval.bottom - oval.top) / 2.0f, (float)this.mRadius, paint);
        } else {
            canvas.drawRoundRect(oval, (float)this.mRadius, (float)this.mRadius, paint);
        }
        paint.setColor(color2);
        canvas.drawText(text, start, end, x + (float)this.mRadius, (float)y, paint);
    }
}

