/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat.widget;

import android.app.Activity;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.fragment.app.Fragment;
import com.vhall.appui.chat.widget.KeyBoardManager;

public class KeyboardStatusDetector {
    KeyboardVisibilityListener visibilityListener;
    boolean keyboardVisible = false;

    public KeyboardStatusDetector registerFragment(Fragment f) {
        return this.registerView(f.getView());
    }

    public KeyboardStatusDetector registerActivity(Activity a) {
        return this.registerView(a.getWindow().getDecorView().findViewById(0x1020002));
    }

    public KeyboardStatusDetector registerView(final View v) {
        v.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Rect r = new Rect();
                v.getWindowVisibleDisplayFrame(r);
                int heightDiff = v.getRootView().getHeight() - (r.bottom - r.top);
                int virtualButtonHeight = KeyBoardManager.getVirtualButtonHeight(v.getContext());
                int statusBarHeight = KeyBoardManager.getStatusBarHeight(v.getContext());
                int statusHeight = virtualButtonHeight + statusBarHeight + 10;
                if (heightDiff > statusHeight) {
                    if (!KeyboardStatusDetector.this.keyboardVisible) {
                        KeyboardStatusDetector.this.keyboardVisible = true;
                        if (KeyboardStatusDetector.this.visibilityListener != null) {
                            KeyboardStatusDetector.this.visibilityListener.onVisibilityChanged(KeyboardStatusDetector.this.keyboardVisible);
                        }
                    }
                } else if (KeyboardStatusDetector.this.keyboardVisible) {
                    KeyboardStatusDetector.this.keyboardVisible = false;
                    if (KeyboardStatusDetector.this.visibilityListener != null) {
                        KeyboardStatusDetector.this.visibilityListener.onVisibilityChanged(KeyboardStatusDetector.this.keyboardVisible);
                    }
                }
            }
        });
        return this;
    }

    public KeyboardStatusDetector setVisibilityListener(KeyboardVisibilityListener listener) {
        this.visibilityListener = listener;
        return this;
    }

    public static interface KeyboardVisibilityListener {
        public void onVisibilityChanged(boolean var1);
    }
}

