/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat.widget;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.lang.reflect.Method;

public class KeyBoardManager {
    public static void openKeyboard(EditText mEditText, Context mContext) {
        InputMethodManager imm = (InputMethodManager)mContext.getSystemService("input_method");
        imm.showSoftInput((View)mEditText, 1);
    }

    public static int getKeyboardHeight(Context context) {
        SharedPreferences sp = context.getSharedPreferences("vhall", 0);
        return sp.getInt("keyboard_height", 0);
    }

    public static void setKeyboardHeight(Context context, int height) {
        SharedPreferences sp = context.getSharedPreferences("vhall", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("keyboard_height", height);
        editor.commit();
    }

    public static int getKeyboardHeightLandspace(Context context) {
        SharedPreferences sp = context.getSharedPreferences("vhall", 0);
        return sp.getInt("keyboard_height_landspace", 0);
    }

    public static void setKeyboardHeightLandspace(Context context, int height) {
        SharedPreferences sp = context.getSharedPreferences("vhall", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("keyboard_height_landspace", height);
        editor.commit();
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelOffset(resourceId);
        }
        return result;
    }

    public static void closeKeyboard(EditText mEditText, Context mContext) {
        InputMethodManager imm = (InputMethodManager)mContext.getSystemService("input_method");
        imm.hideSoftInputFromWindow(mEditText.getWindowToken(), 0);
    }

    public static int getVirtualButtonHeight(Context context) {
        int vh = 0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        try {
            Class<?> c = Class.forName("android.view.Display");
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, dm);
            vh = dm.heightPixels - display.getHeight();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vh;
    }

    public static boolean hasVirtualButton(Context context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("config_showNavigationBar", "bool", "android");
        if (resourceId != 0) {
            boolean hasVirtral = res.getBoolean(resourceId);
            String navBarOverride = KeyBoardManager.getNavBarOverride();
            if (navBarOverride.equals(1)) {
                hasVirtral = false;
            } else if (navBarOverride.equals(0)) {
                hasVirtral = true;
            }
            return hasVirtral;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    public static boolean isVirtualButtonVisible(Activity activity) {
        boolean visible = false;
        if (Build.VERSION.SDK_INT >= 19) {
            Display display = activity.getWindow().getWindowManager().getDefaultDisplay();
            Point point = new Point();
            display.getRealSize(point);
            View decorView = activity.getWindow().getDecorView();
            Configuration conf = activity.getResources().getConfiguration();
            if (2 == conf.orientation) {
                View contentView = decorView.findViewById(0x1020002);
                visible = point.x != contentView.getWidth();
            } else {
                Rect rect = new Rect();
                decorView.getWindowVisibleDisplayFrame(rect);
                visible = rect.bottom != point.y;
            }
        }
        return visible;
    }

    private static String getNavBarOverride() {
        String sNavBarOverride = null;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method m = c.getDeclaredMethod("get", String.class);
                m.setAccessible(true);
                sNavBarOverride = (String)m.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sNavBarOverride;
    }
}

