/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.widget.emoji.EmojiUtils;
import com.vhall.appui.chat.widget.EmojiPagerAdapter;
import com.vhall.appui.chat.widget.KeyBoardManager;
import com.vhall.appui.chat.widget.KeyboardStatusDetector;
import java.util.ArrayList;
import java.util.List;

public class InputView {
    private static final String TAG = "InputView";
    private boolean showEmoji = false;
    private View contentView;
    private View viewBg;
    private ImageView iv_emoji;
    private EditText et_content;
    private TextView tv_send;
    private ViewPager vp_emoji;
    Context context;
    Activity activity;
    private boolean hasVirtual = false;
    private int virtualHeight = 0;
    private int keyboardHeight = 0;
    private int limitNo = 280;
    private ClickCallback mCallback;
    private int keyboardHeight_portrait = 0;
    private int keyboardHeight_landspace = 0;
    SendMsgClickListener onSendClickListener;
    KeyboardHeightListener onHeightReceivedListener;

    public InputView(Context context, int protraitHeight, int landspaceHeight) {
        this.context = context;
        this.keyboardHeight_portrait = protraitHeight;
        this.keyboardHeight_landspace = landspaceHeight;
        this.initView();
        this.initEmoji();
        this.hasVirtual = KeyBoardManager.hasVirtualButton(context);
        if (this.hasVirtual) {
            this.virtualHeight = KeyBoardManager.getVirtualButtonHeight(context);
        }
    }

    public void setClickCallback(ClickCallback clickCallback) {
        this.mCallback = clickCallback;
    }

    public int getLimitNo() {
        return this.limitNo;
    }

    public void setLimitNo(int limitNo) {
        this.limitNo = limitNo;
    }

    public EditText getEt_content() {
        return this.et_content;
    }

    public void setEt_content(EditText et_content) {
        this.et_content = et_content;
    }

    public View getContentView() {
        return this.contentView;
    }

    public void setOnSendClickListener(SendMsgClickListener onSendClickListener) {
        this.onSendClickListener = onSendClickListener;
    }

    public void setOnHeightReceivedListener(KeyboardHeightListener onHeightReceivedListener) {
        this.onHeightReceivedListener = onHeightReceivedListener;
    }

    public void initView() {
        this.contentView = View.inflate((Context)this.context, (int)R.layout.chat_emoji_inputview_layout, null);
        this.viewBg = this.contentView.findViewById(R.id.view_bg);
        this.iv_emoji = (ImageView)this.contentView.findViewById(R.id.iv_emoji);
        this.et_content = (EditText)this.contentView.findViewById(R.id.et_content);
        this.tv_send = (TextView)this.contentView.findViewById(R.id.tv_send);
        this.vp_emoji = (ViewPager)this.contentView.findViewById(R.id.vp_emoji);
        this.contentView.setVisibility(8);
        this.viewBg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InputView.this.dismiss();
            }
        });
        this.iv_emoji.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InputView.this.showEmoji = !InputView.this.showEmoji;
                InputView.this.show(InputView.this.showEmoji);
            }
        });
        this.et_content.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InputView.this.showEmoji = false;
                InputView.this.show(InputView.this.showEmoji);
            }
        });
        this.tv_send.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (InputView.this.onSendClickListener != null) {
                    String msg = InputView.this.et_content.getText().toString();
                    InputView.this.onSendClickListener.onSendClick(msg);
                    InputView.this.et_content.setText((CharSequence)"");
                    InputView.this.dismiss();
                }
            }
        });
        this.et_content.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView arg0, int arg1, KeyEvent arg2) {
                if (arg1 == 4 || arg2 != null && arg2.getKeyCode() == 66) {
                    InputView.this.tv_send.performClick();
                    return true;
                }
                return false;
            }
        });
        this.et_content.setHint((CharSequence)"\u8f93\u5165\u8ba8\u8bba");
    }

    public void initEmoji() {
        List<String> emoji = EmojiUtils.getExpressionRes(90);
        ArrayList<View> views = new ArrayList<View>();
        for (int i = 1; i <= 5; ++i) {
            View view = EmojiUtils.getGridChildView(this.context, i, emoji, this.et_content);
            views.add(view);
        }
        this.vp_emoji.setAdapter((PagerAdapter)new EmojiPagerAdapter(views));
    }

    public void add2Window(Activity activity) {
        this.activity = activity;
        FrameLayout layout2 = (FrameLayout)activity.getWindow().getDecorView().findViewById(0x1020002);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        params.gravity = 80;
        layout2.addView(this.contentView, (ViewGroup.LayoutParams)params);
        this.observeSoftKeyboard(activity);
        new KeyboardStatusDetector().registerActivity(activity).setVisibilityListener(new KeyboardStatusDetector.KeyboardVisibilityListener(){

            @Override
            public void onVisibilityChanged(boolean keyboardVisible) {
                if (!keyboardVisible && !InputView.this.showEmoji) {
                    InputView.this.dismiss();
                }
            }
        });
    }

    public void show(boolean isShowEmoji) {
        this.et_content.requestFocus();
        this.showEmoji = isShowEmoji;
        if (isShowEmoji) {
            this.showEmoji();
        } else {
            this.showKeyboard();
        }
    }

    private void showEmoji() {
        if (null != this.mCallback) {
            this.mCallback.onEmojiClick();
        }
        final FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.contentView.getLayoutParams();
        KeyBoardManager.closeKeyboard(this.et_content, (Context)this.activity);
        if (this.keyboardHeight > 0) {
            this.vp_emoji.getLayoutParams().height = this.keyboardHeight;
        }
        this.contentView.setVisibility(0);
        new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                params.setMargins(0, 0, 0, 0);
                InputView.this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
                InputView.this.iv_emoji.setImageResource(R.mipmap.baselib_icon_keyboard);
                InputView.this.vp_emoji.setVisibility(0);
            }
        }.sendEmptyMessageDelayed(1, 200L);
    }

    private void showKeyboard() {
        final FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.contentView.getLayoutParams();
        if (this.activity.getResources().getConfiguration().orientation == 1) {
            if (this.keyboardHeight_portrait == 0) {
                params.setMargins(0, 0, 0, 800);
                this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
                KeyBoardManager.openKeyboard(this.et_content, (Context)this.activity);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        params.setMargins(0, 0, 0, InputView.this.keyboardHeight_portrait);
                        InputView.this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
                        InputView.this.iv_emoji.setImageResource(R.mipmap.vhall_class_chat_em_button_default);
                        InputView.this.vp_emoji.setVisibility(8);
                        InputView.this.contentView.setVisibility(0);
                    }
                }, 300L);
                return;
            }
            params.setMargins(0, 0, 0, this.keyboardHeight_portrait);
        } else {
            if (this.keyboardHeight_landspace == 0) {
                this.keyboardHeight_landspace = 840;
            }
            params.setMargins(0, 0, 0, this.keyboardHeight_landspace);
        }
        if (this.contentView.getVisibility() == 0) {
            this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.iv_emoji.setImageResource(R.mipmap.vhall_class_chat_em_button_default);
            this.vp_emoji.setVisibility(8);
            this.contentView.setVisibility(0);
            KeyBoardManager.openKeyboard(this.et_content, (Context)this.activity);
            KeyBoardManager.openKeyboard(this.et_content, (Context)this.activity);
        } else {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    InputView.this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
                    InputView.this.iv_emoji.setImageResource(R.mipmap.vhall_class_chat_em_button_default);
                    InputView.this.vp_emoji.setVisibility(8);
                    InputView.this.contentView.setVisibility(0);
                    KeyBoardManager.openKeyboard(InputView.this.et_content, (Context)InputView.this.activity);
                }
            }, 300L);
        }
    }

    public void dismiss() {
        if (this.contentView.getVisibility() == 8) {
            return;
        }
        KeyBoardManager.closeKeyboard(this.et_content, (Context)this.activity);
        this.showEmoji = false;
        new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)InputView.this.contentView.getLayoutParams();
                params.setMargins(0, 0, 0, 0);
                InputView.this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
                InputView.this.iv_emoji.setImageResource(R.mipmap.vhall_class_chat_em_button_default);
                InputView.this.vp_emoji.setVisibility(8);
                InputView.this.contentView.setVisibility(8);
            }
        }.sendEmptyMessageDelayed(1, 200L);
    }

    public void observeSoftKeyboard(final Activity activity) {
        final View decorView = activity.getWindow().getDecorView();
        decorView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){
            int previousKeyboardHeight = -1;

            public void onGlobalLayout() {
                Rect rect = new Rect();
                decorView.getWindowVisibleDisplayFrame(rect);
                int displayHeight = rect.bottom - rect.top;
                int height = decorView.getHeight();
                if (InputView.this.hasVirtual && InputView.this.virtualHeight > 0) {
                    InputView.this.keyboardHeight = height - displayHeight - rect.top - InputView.this.virtualHeight;
                } else {
                    InputView.this.keyboardHeight = height - displayHeight - rect.top;
                }
                if (this.previousKeyboardHeight != InputView.this.keyboardHeight) {
                    boolean hide;
                    boolean bl = hide = (double)displayHeight / (double)height > 0.8;
                    if (!hide || !InputView.this.showEmoji) {
                        // empty if block
                    }
                    if (!hide) {
                        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)InputView.this.contentView.getLayoutParams();
                        if (activity.getResources().getConfiguration().orientation == 1) {
                            InputView.this.keyboardHeight_portrait = InputView.this.keyboardHeight;
                            if (InputView.this.onHeightReceivedListener != null) {
                                InputView.this.onHeightReceivedListener.onHeightReceived(1, InputView.this.keyboardHeight_portrait);
                            }
                            params.setMargins(0, 0, 0, InputView.this.keyboardHeight);
                        } else if (activity.getResources().getConfiguration().orientation == 2) {
                            InputView.this.keyboardHeight_landspace = InputView.this.keyboardHeight;
                            if (InputView.this.onHeightReceivedListener != null) {
                                InputView.this.onHeightReceivedListener.onHeightReceived(2, InputView.this.keyboardHeight_landspace);
                            }
                            params.setMargins(0, 0, 0, InputView.this.keyboardHeight);
                        }
                        InputView.this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
                    }
                }
                this.previousKeyboardHeight = InputView.this.keyboardHeight;
            }
        });
    }

    public static interface ClickCallback {
        public void onEmojiClick();
    }

    public static interface KeyboardHeightListener {
        public void onHeightReceived(int var1, int var2);
    }

    public static interface SendMsgClickListener {
        public void onSendClick(String var1);
    }
}

