/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.vhall.appui.baselib.R;
import com.vhall.appui.watchverticallive.network.bean.ResponsePushGoodsScreenBean;
import java.text.DecimalFormat;

public class GoodsPushView
extends FrameLayout {
    private Context mContext;
    private TextView goods_push_desc;
    private TextView goods_push_title;
    private TextView goods_push_num;
    private TextView history_price;
    private TextView current_price;
    private ImageView goods_push_img;
    private View view;
    private ResponsePushGoodsScreenBean goodsInfo;

    public ResponsePushGoodsScreenBean getGoodsInfo() {
        return this.goodsInfo;
    }

    public GoodsPushView(@NonNull Context context) {
        this(context, null);
    }

    public GoodsPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GoodsPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.initView();
    }

    private void initView() {
        this.view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.goods_push_view, null);
        this.goods_push_desc = (TextView)this.view.findViewById(R.id.goods_push_desc);
        this.goods_push_title = (TextView)this.view.findViewById(R.id.goods_push_title);
        this.goods_push_num = (TextView)this.view.findViewById(R.id.goods_push_num);
        this.goods_push_img = (ImageView)this.view.findViewById(R.id.goods_push_img);
        this.history_price = (TextView)this.view.findViewById(R.id.history_price);
        this.current_price = (TextView)this.view.findViewById(R.id.current_price);
        this.history_price.getPaint().setFlags(17);
        this.view.findViewById(R.id.close).setOnClickListener(v -> this.setVisibility(8));
        this.addView(this.view);
    }

    public void setText(TextView view, String str) {
        view.setText((CharSequence)str);
        if (view.getLineCount() > 1) {
            int lineEndIndex = view.getLayout().getLineEnd(1);
            String text = view.getText().subSequence(0, lineEndIndex - 1) + "...";
            view.setText((CharSequence)text);
        }
    }

    public void setBackGround(int resId) {
        try {
            this.view.findViewById(R.id.layout_bg).setBackgroundResource(resId);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void setGoodsInfo(final ResponsePushGoodsScreenBean goodsInfo) {
        this.goodsInfo = goodsInfo;
        this.setText(this.goods_push_desc, goodsInfo.getSub_title() + "");
        this.setText(this.goods_push_title, goodsInfo.getArticle_name() + "");
        DecimalFormat df = new DecimalFormat("0.00");
        this.setText(this.current_price, "\u00a5 " + df.format(Double.parseDouble(goodsInfo.getDiscount_price())) + "");
        this.setText(this.history_price, "\u00a5 " + df.format(Double.parseDouble(goodsInfo.getSale_price())) + "");
        if (TextUtils.equals((CharSequence)goodsInfo.getDiscount_price(), (CharSequence)goodsInfo.getSale_price())) {
            this.history_price.setVisibility(8);
            this.current_price.setTextColor(Color.parseColor((String)"#000000"));
        } else {
            this.history_price.setVisibility(0);
            this.current_price.setTextColor(Color.parseColor((String)"#D83F56"));
            this.history_price.setTextColor(Color.parseColor((String)"#000000"));
        }
        Glide.with((Context)this.mContext).load(goodsInfo.getImage_url() + "").listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                GoodsPushView.this.goods_push_num.setVisibility(0);
                if (Integer.parseInt(goodsInfo.getNumber()) < 10) {
                    GoodsPushView.this.goods_push_num.setText((CharSequence)(goodsInfo.getNumber() + ""));
                } else {
                    GoodsPushView.this.goods_push_num.setText((CharSequence)(" " + goodsInfo.getNumber() + " "));
                }
                return false;
            }
        }).into(this.goods_push_img);
    }
}

