/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat.widget;

import android.content.Context;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.IBaseViewImpl;
import com.vhall.appui.baselib.service.chat.ChatManager;
import com.vhall.appui.baselib.service.chat.IChatBottomControl;
import com.vhall.appui.baselib.service.chat.IChatPanel;
import com.vhall.appui.baselib.service.chat.IMessageMenuListener;
import com.vhall.appui.baselib.service.chat.OnItemChildClickListener;
import com.vhall.appui.baselib.service.chat.OnItemChildLongClickListener;
import com.vhall.appui.baselib.service.chat.OnItemClickListener;
import com.vhall.appui.baselib.service.chat.processor.IChatProcessor;
import com.vhall.appui.baselib.service.chat.processor.IVHChatInterceptor;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.service.sensitivewords.IFilterSensitiveWordsListener;
import com.vhall.appui.baselib.service.sensitivewords.SensitiveWordsManager;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.utils.ListUtils;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.service.IMessage;
import com.vhall.appui.baselib.widget.FadingEdgeTopRecyclerView;
import com.vhall.appui.baselib.widget.pushView.PushViewUtils;
import com.vhall.appui.chat.ChatAdapter;
import com.vhall.appui.chat.TopMessageManager;
import java.util.ArrayList;
import java.util.List;

public class ChatPanelView
extends IBaseViewImpl
implements IChatPanel,
SwipeRefreshLayout.OnRefreshListener,
View.OnClickListener {
    private FadingEdgeTopRecyclerView chat_list;
    private ChatAdapter chatAdapter;
    private LinearLayoutManager mLayoutManager;
    private PopupWindow mItemMenu;
    private SwipeRefreshLayout refresh_layout;
    private PushViewUtils pushViewUtils;
    private TextView push_view;
    private OnItemChildClickListener onItemChildClickListener;
    private TopMessageManager mTopMessageManager;
    private TextView tv_top1;
    private TextView tv_top2;
    int lastItemPosition;
    private IFilterSensitiveWordsListener mSensitiveWordsListener;
    private RecyclerView.OnScrollListener mOnScrollListener;
    private int currentPage = 1;
    private NewMessageCallback newMessageCallback;
    private List<IVHChatInterceptor> mInterceptors = ChatManager.getInstance().getVHChatInterceptors();
    private int count;
    private OnItemClickListener mListener;
    private OnItemChildLongClickListener onItemChildLongClickListener;
    private IMessageMenuListener messageMenuListener;
    private IChatBottomControl mChatBottomControl;

    public ChatPanelView(@NonNull Context context) {
        super(context);
    }

    public ChatPanelView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ChatPanelView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void init() {
        super.init();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.chat_panel_layout, (ViewGroup)this);
        this.initView();
        this.initData();
    }

    private void initData() {
        this.mLayoutManager = new LinearLayoutManager(this.getContext());
        this.mLayoutManager.setOrientation(1);
        this.mLayoutManager.setStackFromEnd(true);
        this.chat_list.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.chatAdapter = new ChatAdapter(R.layout.chat_item_layout, this.getContext());
        this.chat_list.setAdapter((RecyclerView.Adapter)this.chatAdapter);
        this.lastItemPosition = this.mLayoutManager.findLastVisibleItemPosition();
        int firstVisibleItem = this.mLayoutManager.findFirstVisibleItemPosition();
        this.chatAdapter.setCurrentPosition(firstVisibleItem, this.lastItemPosition);
        this.chatAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                if (ChatPanelView.this.mListener != null) {
                    ChatPanelView.this.mListener.onItemClick((RecyclerView.Adapter)adapter, view, position);
                }
            }
        });
        this.chatAdapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener(){

            public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                if (ChatPanelView.this.onItemChildClickListener != null && view.getId() == R.id.tv_avatar) {
                    ChatPanelView.this.onItemChildClickListener.onItemClick(adapter, view, position);
                }
            }
        });
        this.configListener();
        this.chat_list.setOnScrollListener(this.mOnScrollListener);
        SensitiveWordsManager.getInstance().addOnFilterSensitiveWordsListener(this.mSensitiveWordsListener);
        ArrayList<TextView> views = new ArrayList<TextView>();
        views.add(this.tv_top1);
        views.add(this.tv_top2);
        this.tv_top1.setMovementMethod(LinkMovementMethod.getInstance());
        this.tv_top2.setMovementMethod(LinkMovementMethod.getInstance());
        this.mTopMessageManager = new TopMessageManager(views);
    }

    private void configListener() {
        this.mOnScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                if (layoutManager instanceof LinearLayoutManager) {
                    LinearLayoutManager linearManager = (LinearLayoutManager)layoutManager;
                    ChatPanelView.this.lastItemPosition = linearManager.findLastVisibleItemPosition();
                    int firstVisibleItem = ChatPanelView.this.mLayoutManager.findFirstVisibleItemPosition();
                    ChatPanelView.this.chatAdapter.setCurrentPosition(firstVisibleItem, ChatPanelView.this.lastItemPosition);
                    if (ChatPanelView.this.lastItemPosition >= ChatPanelView.this.chatAdapter.getData().size() - 1) {
                        ChatPanelView.this.hideNewMsg();
                    }
                }
            }
        };
        this.mSensitiveWordsListener = new IFilterSensitiveWordsListener.SimpleFilterSensitiveWordsListener(){

            @Override
            public void onPreFilterMessage(IMessage fakeMessage) {
                ChatPanelView.this.addMessage(fakeMessage);
            }
        };
    }

    public void onRefresh() {
        this.hideProgress();
    }

    private void notifyDataChanged() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ChatPanelView.this.mLayoutManager.scrollToPositionWithOffset(ChatPanelView.this.chatAdapter.getData().size() - 1, 0);
            }
        });
    }

    private void hideProgress() {
        this.refresh_layout.setRefreshing(false);
    }

    private void handleMessage(String format, IMessage message) {
        this.mItemMenu.dismiss();
        this.mChatBottomControl.showKeyboard();
        this.mChatBottomControl.setSendMessage(String.format(format, message.getUserId()));
    }

    private void initView() {
        this.chat_list = (FadingEdgeTopRecyclerView)this.findViewById(R.id.chat_list);
        this.refresh_layout = (SwipeRefreshLayout)this.findViewById(R.id.refresh_layout);
        this.tv_top1 = (TextView)this.findViewById(R.id.tv_top1);
        this.tv_top2 = (TextView)this.findViewById(R.id.tv_top2);
        this.refresh_layout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.refresh_layout.setEnabled(false);
        this.push_view = (TextView)this.findViewById(R.id.push_view);
        this.pushViewUtils = new PushViewUtils(this.getContext());
        this.pushViewUtils.setDismissCallBack(new PushViewUtils.DismissCallBack(){

            @Override
            public void viewDismiss() {
                ChatPanelView.this.push_view.setVisibility(8);
            }
        });
        this.pushViewUtils.setShowCallBack(new PushViewUtils.ShowCallBack(){

            @Override
            public void viewShow(View view, Object showData) {
                ChatPanelView.this.push_view.setText((CharSequence)((String)showData));
            }
        });
    }

    public void onClick(View v) {
    }

    @Override
    public void click() {
        this.newMessageCallback.click();
        this.notifyDataChanged();
        this.hideNewMsg();
    }

    @Override
    public void setNewMessage(NewMessageCallback newMessageCallback) {
        this.newMessageCallback = newMessageCallback;
    }

    @Override
    public void addSpecialMessage(MessageData info) {
        for (IVHChatInterceptor interceptor : this.mInterceptors) {
            if (!interceptor.onMessage(info)) continue;
            this.processSpecialImpl(info, interceptor);
        }
    }

    private void processSpecialImpl(MessageData info, IVHChatInterceptor interceptor) {
        List<IChatProcessor> processors = interceptor.getChatProcessor(info);
        if (InternalUtils.isNotEmpty(processors)) {
            for (IChatProcessor processor : processors) {
                if (processor == null) continue;
                if (processor.isShowInTop()) {
                    this.mTopMessageManager.addMessage(new TopMessageManager.TopMsg(processor.getShowDuration(), processor.getShowText(), processor));
                    continue;
                }
                IMessage message = processor.getChatMessage();
                if (message == null) continue;
                this.addMessage(message);
            }
        }
    }

    @Override
    public void addMessage(IMessage message) {
        boolean refreshList;
        this.lastItemPosition = this.mLayoutManager.findLastVisibleItemPosition();
        boolean bl = refreshList = InternalUtils.isEmpty(this.chatAdapter.getData()) || TextUtils.equals((CharSequence)message.getUserId(), (CharSequence)AccountManager.getInstance().getUserId()) || this.lastItemPosition == this.chatAdapter.getData().size() - 1;
        if (!ListUtils.isEmpty(this.chatAdapter.getData()) && this.chatAdapter.getData().size() >= 200) {
            this.chatAdapter.remove(0);
        }
        this.chatAdapter.addData(message);
        this.processAtOrReplyMessage(message);
        if (refreshList) {
            this.notifyDataChanged();
            this.hideNewMsg();
        } else {
            this.showNewMsg();
            String content = String.valueOf(this.count);
            if (this.count > 99) {
                content = String.format("%s+", 99);
            }
        }
        int firstVisibleItem = this.mLayoutManager.findFirstVisibleItemPosition();
        this.chatAdapter.setCurrentPosition(firstVisibleItem, this.lastItemPosition);
    }

    private void processAtOrReplyMessage(IMessage message) {
        if (message instanceof VssMessageChatData) {
            VssMessageChatData vssMessageChatData = (VssMessageChatData)message;
            if (message.getMsgType() == 1) {
                if (vssMessageChatData.getReceiver_id().contains("*" + AccountManager.getInstance().getUserId() + "*")) {
                    this.pushViewUtils.intoShowEnter((View)this.push_view, String.format("%s @\u4e86\u4f60", message.getNickname()));
                }
            } else if (message.getMsgType() == 2 && vssMessageChatData.getReplyMsg() != null && TextUtils.equals((CharSequence)AccountManager.getInstance().getUserId(), (CharSequence)vssMessageChatData.getReplyMsg().getSendId())) {
                this.pushViewUtils.intoShowEnter((View)this.push_view, String.format("%s \u56de\u590d\u4e86\u4f60", message.getNickname()));
            }
        }
    }

    private void hideNewMsg() {
        if (this.newMessageCallback != null) {
            this.count = 0;
            this.lastItemPosition = this.chatAdapter.getData().size() - 1;
            this.newMessageCallback.hide();
        }
    }

    private void showNewMsg() {
        if (this.newMessageCallback != null) {
            ++this.count;
            this.newMessageCallback.show(this.count);
        }
    }

    @Override
    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mListener = onItemClickListener;
    }

    @Override
    public void setOnItemChildLongClickListener(OnItemChildLongClickListener onItemChildLongClickListener) {
        this.onItemChildLongClickListener = onItemChildLongClickListener;
    }

    @Override
    public void OnItemChildClickListener(OnItemChildClickListener onItemChildClickListener) {
        this.onItemChildClickListener = onItemChildClickListener;
    }

    @Override
    public void addMessage(List<IMessage> messages) {
    }

    @Override
    public void removeMessage(IMessage message) {
        if (InternalUtils.isNotEmpty(this.chatAdapter.getData())) {
            int index = this.chatAdapter.getData().indexOf(message);
            if (message != null && index >= 0) {
                this.chatAdapter.notifyItemRemoved(index);
            }
        }
    }

    @Override
    public void setVisible(boolean show) {
        this.setVisibility(show ? 0 : 8);
    }

    @Override
    public void setMessageMenuListener(IMessageMenuListener messageMenuListener) {
        this.messageMenuListener = messageMenuListener;
    }

    @Override
    public void setBottomControl(IChatBottomControl chatBottomControl) {
        this.mChatBottomControl = chatBottomControl;
    }

    @Override
    public void unSubscribe() {
        super.unSubscribe();
        SensitiveWordsManager.getInstance().removeFilterSensitiveWordsListener(this.mSensitiveWordsListener);
    }

    public static interface NewMessageCallback {
        public void hide();

        public void show(int var1);

        public void click();
    }
}

