/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.chat.ChatAdapter;
import com.vhall.appui.chat.widget.InputView;
import com.vhall.appui.chat.widget.KeyBoardManager;

public class Chat2View
extends RelativeLayout
implements View.OnClickListener {
    private static final String TAG = "ChatView";
    private Context context;
    private RecyclerView mChatList;
    private ChatAdapter chatAdapter;
    private InputView inputView;
    private TextView tvContent;
    private TextView tvSend;
    private SwipeRefreshLayout swipeRefresh;
    private LinearLayout mView;
    private Handler handler = new Handler(Looper.getMainLooper());
    private boolean chatAble = true;
    private Activity activity;
    private int curPage = 1;
    private int pageSize = 10;
    private int totalPage = 0;
    private String hintContent = "";
    private LinearLayoutManager mLayoutManager;

    public Chat2View(Context context) {
        this(context, null);
    }

    public Chat2View(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Chat2View(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init((Activity)context);
    }

    public void init(Activity activity) {
        this.activity = activity;
        View root = LayoutInflater.from((Context)this.context).inflate(R.layout.chat_view2, (ViewGroup)this, true);
        this.mView = (LinearLayout)root.findViewById(R.id.widget_layout_softboard);
        this.mView.setOnClickListener((View.OnClickListener)this);
        this.tvContent = (TextView)root.findViewById(R.id.tv_class_content);
        this.tvSend = (TextView)root.findViewById(R.id.tv_chat_view_send);
        this.tvSend.setOnClickListener((View.OnClickListener)this);
        root.findViewById(R.id.widget_layout_emo).setOnClickListener((View.OnClickListener)this);
        this.swipeRefresh = (SwipeRefreshLayout)this.findViewById(R.id.swipeRefresh);
        this.swipeRefresh.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                Chat2View.this.swipeRefresh.setRefreshing(false);
            }
        });
        this.mChatList = (RecyclerView)root.findViewById(R.id.lv_chat);
        this.mLayoutManager = new LinearLayoutManager(this.context);
        this.mLayoutManager.setOrientation(1);
        this.mChatList.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.chatAdapter = new ChatAdapter(R.layout.item_chat_layout2, this.context);
        this.mChatList.setAdapter((RecyclerView.Adapter)this.chatAdapter);
        this.inputView = new InputView(this.context, KeyBoardManager.getKeyboardHeight(this.context), KeyBoardManager.getKeyboardHeightLandspace(this.context));
        this.inputView.add2Window(activity);
        this.inputView.setLimitNo(280);
        this.inputView.setOnSendClickListener(new InputView.SendMsgClickListener(){

            @Override
            public void onSendClick(String msg) {
                if (Chat2View.this.chatAble) {
                    if (TextUtils.isEmpty((CharSequence)msg.trim())) {
                        Toast.makeText((Context)Chat2View.this.context, (CharSequence)"\u8bf7\u8f93\u5165\u60a8\u8981\u53d1\u9001\u7684\u5185\u5bb9", (int)0).show();
                    } else {
                        Chat2View.this.sendMsg(msg);
                    }
                } else {
                    if (TextUtils.isEmpty((CharSequence)Chat2View.this.hintContent)) {
                        Chat2View.this.hintContent = Chat2View.this.context.getString(R.string.disable_chat);
                    } else if (Chat2View.this.hintContent.equals(Chat2View.this.context.getString(R.string.disable_chat_all))) {
                        Chat2View.this.hintContent = Chat2View.this.context.getString(R.string.disable_chat_all1);
                    }
                    Toast.makeText((Context)Chat2View.this.context, (CharSequence)Chat2View.this.hintContent, (int)0).show();
                }
            }
        });
        this.inputView.setOnHeightReceivedListener(new InputView.KeyboardHeightListener(){

            @Override
            public void onHeightReceived(int screenOri, int height) {
                if (screenOri == 1) {
                    KeyBoardManager.setKeyboardHeight(Chat2View.this.context, height);
                } else {
                    KeyBoardManager.setKeyboardHeightLandspace(Chat2View.this.context, height);
                }
            }
        });
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public void onClick(View v) {
        int i = v.getId();
        if (this.chatAble) {
            if (i == R.id.widget_layout_softboard) {
                this.inputView.show(false);
            } else if (i == R.id.widget_layout_emo) {
                this.inputView.show(true);
            } else if (i == R.id.tv_chat_view_send) {
                if (TextUtils.isEmpty((CharSequence)this.tvContent.getText().toString().trim())) {
                    Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.input_content_to_send), (int)0).show();
                } else {
                    this.sendMsg(this.tvContent.getText().toString().trim());
                    this.tvContent.setText((CharSequence)"");
                }
            }
        } else {
            if (TextUtils.isEmpty((CharSequence)this.hintContent)) {
                this.hintContent = this.context.getString(R.string.disable_chat);
            } else if (this.hintContent.equals(this.context.getString(R.string.disable_chat_all))) {
                this.hintContent = this.context.getString(R.string.disable_chat_all1);
            }
            Toast.makeText((Context)this.context, (CharSequence)this.hintContent, (int)0).show();
        }
    }

    private void loadHistoryMsg() {
    }

    public void showMsg(VssMessageChatData msg) {
        this.chatAdapter.addData(msg);
    }

    private void sendMsg(String msg) {
        if (!VssRoomManager.enter) {
            Toast.makeText((Context)this.context, (CharSequence)"\u8bf7\u521d\u59cb\u5316\u623f\u95f4\u4fe1\u606f", (int)0).show();
            return;
        }
        VssRoomManager.getInstance().sendMsg(msg, "", new CallBack(){

            public void onSuccess(Object result) {
            }

            @Override
            public void onError(int eventCode, String msg) {
                Toast.makeText((Context)Chat2View.this.context, (CharSequence)msg, (int)0).show();
            }
        });
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        switch (event.getKeyCode()) {
            default: 
        }
        return super.dispatchKeyEvent(event);
    }

    public void setChatAble(boolean chatAble, String hintContent) {
        this.chatAble = chatAble;
        this.hintContent = hintContent;
        if (!TextUtils.isEmpty((CharSequence)hintContent)) {
            this.tvContent.setHint((CharSequence)hintContent);
        } else {
            this.tvContent.setHint((CharSequence)this.context.getString(R.string.input_content_to_send));
        }
    }

    public void dismissInputView() {
        this.inputView.dismiss();
    }

    public void showInputView(boolean isShowEmoji) {
        this.inputView.show(isShowEmoji);
    }
}

