/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.service.chat.processor.IChatProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TopMessageManager {
    Handler mUIHandler;
    private List<TextView> uiViews;
    List<TopMsg> mTopMsgs = new ArrayList<TopMsg>(){

        @Override
        public boolean remove(@Nullable Object o) {
            boolean flag = super.remove(o);
            TopMessageManager.this.notifyDataChanged(TopMessageManager.this.mTopMsgs);
            return flag;
        }

        @Override
        public TopMsg remove(int index) {
            TopMsg flag = (TopMsg)super.remove(index);
            TopMessageManager.this.notifyDataChanged(TopMessageManager.this.mTopMsgs);
            return flag;
        }
    };

    public TopMessageManager(List<TextView> views) {
        this.uiViews = views;
        this.mUIHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                ArrayList<TopMsg> temp = new ArrayList<TopMsg>(TopMessageManager.this.mTopMsgs);
                for (TopMsg m : temp) {
                    if (m.messageId.hashCode() != msg.what) continue;
                    TopMessageManager.this.mTopMsgs.remove(m);
                }
            }
        };
    }

    public void addMessage(TopMsg msg) {
        this.mTopMsgs.add(msg);
        if (this.mTopMsgs.size() > 2) {
            this.mTopMsgs.remove(0);
        } else {
            this.notifyDataChanged(this.mTopMsgs);
        }
        this.mUIHandler.sendEmptyMessageDelayed(msg.messageId.hashCode(), msg.duration);
    }

    public void notifyDataChanged(List<TopMsg> topMsgs) {
        for (View view : this.uiViews) {
            view.setVisibility(8);
        }
        for (int i = 0; i < Math.min(topMsgs.size(), this.uiViews.size()); ++i) {
            final TopMsg topMsg = topMsgs.get(i);
            TextView textView = this.uiViews.get(i);
            textView.setText(topMsg.message);
            textView.setVisibility(0);
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (topMsg.processor != null) {
                        topMsg.processor.doAction(v);
                    }
                }
            });
        }
    }

    public static class TopMsg {
        public long duration;
        public CharSequence message;
        public String messageId;
        public IChatProcessor processor;

        public TopMsg(long duration, CharSequence message, IChatProcessor processor) {
            this.duration = duration;
            this.message = message;
            this.messageId = UUID.randomUUID().toString();
            this.processor = processor;
        }
    }
}

