/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.core.BaseServiceImpl;
import com.vhall.appui.baselib.service.chat.IChatBottomControl;
import com.vhall.appui.baselib.service.chat.IChatPanel;
import com.vhall.appui.baselib.service.chat.IChatService;
import com.vhall.appui.baselib.service.chat.processor.IVHChatInterceptor;
import com.vhall.appui.baselib.utils.ListUtils;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.widget.ChatBottomControlView;
import com.vhall.appui.chat.biz.ChatActivity;
import com.vhall.appui.chat.network.ChatNetWrapper;
import com.vhall.appui.chat.widget.ChatPanelView;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatServiceImpl
extends BaseServiceImpl
implements IChatService {
    private Set<String> mInteractiveChatServiceNames = new HashSet<String>();
    private Set<IVHChatInterceptor> mVHChatInterceptors = new HashSet<IVHChatInterceptor>();

    @Override
    public void startChatActivity(Context activity, Bundle bundle) {
        Intent intent = new Intent(activity, ChatActivity.class);
        if (!(activity instanceof Activity)) {
            intent.setFlags(0x10000000);
        }
        intent.putExtra("extra", bundle);
        activity.startActivity(intent);
    }

    @Override
    public String getVersion() {
        return "1.2.9";
    }

    @Override
    public IChatPanel createChatPanel(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        ChatPanelView panel = new ChatPanelView(context, attrs, defStyleAttr);
        return panel;
    }

    @Override
    public IChatBottomControl createChatView(Context activityContext, @Nullable AttributeSet attrs, int defStyleAttr) {
        ChatBottomControlView chat = new ChatBottomControlView(activityContext, attrs, defStyleAttr);
        return chat;
    }

    @Override
    public void uploadImage(final List<String> images, final CallBack<List<String>> callBack) {
        final ArrayList urls = new ArrayList();
        if (ListUtils.isEmpty(images)) {
            return;
        }
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final @NonNull ObservableEmitter<String> emitter) {
                String ext = "jpg";
                for (int i = 0; i < images.size(); ++i) {
                    String[] split;
                    String image = (String)images.get(i);
                    if (image.contains(".") && (split = image.split(".")).length > 0) {
                        ext = split[split.length - 1];
                    }
                    ChatNetWrapper.chatUpload(image, ext, new CallBack<String>(){

                        @Override
                        public void onSuccess(String s) {
                            block6: {
                                try {
                                    JSONObject jsonObject = new JSONObject(s);
                                    String url = jsonObject.optString("url");
                                    if (!TextUtils.isEmpty((CharSequence)url)) {
                                        urls.add(url);
                                    } else if (callBack != null) {
                                        emitter.onError((Throwable)new Exception("empty url"));
                                        callBack.onError(-1, "empty url");
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                    emitter.onError((Throwable)e);
                                    if (callBack == null) break block6;
                                    callBack.onError(((Object)((Object)e)).hashCode(), e.getMessage());
                                }
                            }
                            if (urls.size() == images.size()) {
                                emitter.onComplete();
                            }
                        }

                        @Override
                        public void onError(int eventCode, String msg) {
                            emitter.onError((Throwable)new Exception(msg));
                        }
                    });
                }
            }
        }).subscribe((Observer)new Observer<String>(){

            public void onSubscribe(@NonNull Disposable d) {
            }

            public void onNext(@NonNull String s) {
            }

            public void onError(@NonNull Throwable e) {
                e.printStackTrace();
                if (callBack != null) {
                    callBack.onError(e.hashCode(), e.getMessage());
                }
            }

            public void onComplete() {
                if (callBack != null) {
                    callBack.onSuccess(urls);
                }
            }
        });
    }

    @Override
    public void addVHChatInterceptor(IVHChatInterceptor interceptor) {
        if (null != interceptor) {
            this.mInteractiveChatServiceNames.add(interceptor.getServiceName());
            this.mVHChatInterceptors.add(interceptor);
        }
    }

    @Override
    public List<IVHChatInterceptor> getVHChatInterceptors() {
        return new ArrayList<IVHChatInterceptor>(this.mVHChatInterceptors);
    }

    @Override
    public boolean isAddedChatEventInterceptor(String event) {
        return this.mInteractiveChatServiceNames.contains(event);
    }
}

