/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.chat;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.TextAppearanceSpan;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.MyBaseViewHolder;
import com.vhall.appui.baselib.bean.JudgeBean;
import com.vhall.appui.baselib.service.chat.processor.IChatProcessor;
import com.vhall.appui.baselib.service.exam.ExamManager;
import com.vhall.appui.baselib.service.question.QuestionManager;
import com.vhall.appui.baselib.service.vote.VoteManager;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.EnumRoleName;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.service.IMessage;
import com.vhall.appui.baselib.webview.VhallWebviewActivity;
import com.vhall.appui.baselib.widget.VhClickSpan;
import com.vhall.appui.baselib.widget.emoji.EmojiUtils;

public class ChatAdapter
extends BaseQuickAdapter<IMessage, MyBaseViewHolder> {
    private Context context;
    private int firstVisibleItem = 0;
    private int lastItemPosition = 0;

    public ChatAdapter(int layoutResId, Context context) {
        super(layoutResId);
        this.context = context;
    }

    protected void convert(@NonNull MyBaseViewHolder helper, IMessage item) {
        int position = helper.getPosition();
        try {
            if (this.firstVisibleItem <= position && position <= this.lastItemPosition) {
                if (position == this.lastItemPosition) {
                    helper.setBackgroundRes(R.id.item_main, R.drawable.shape_transparent_bg_cc);
                    helper.setTextColor(R.id.msg_content, Color.parseColor((String)"#FFFFFFFF"));
                }
                if (position == this.lastItemPosition - 1) {
                    helper.setBackgroundRes(R.id.item_main, R.drawable.shape_transparent_bg_b3);
                    helper.setTextColor(R.id.msg_content, Color.parseColor((String)"#E6FFFFFF"));
                }
                if (position == this.lastItemPosition - 2) {
                    helper.setBackgroundRes(R.id.item_main, R.drawable.shape_transparent_bg_66);
                    helper.setTextColor(R.id.msg_content, Color.parseColor((String)"#CCFFFFFF"));
                }
                if (position == this.lastItemPosition - 3) {
                    helper.setBackgroundRes(R.id.item_main, R.drawable.shape_transparent_bg_66);
                    helper.setTextColor(R.id.msg_content, Color.parseColor((String)"#CCFFFFFF"));
                }
                if (position == this.lastItemPosition - 4) {
                    helper.setBackgroundRes(R.id.item_main, R.drawable.shape_transparent_bg_99);
                    helper.setTextColor(R.id.msg_content, Color.parseColor((String)"#B3FFFFFF"));
                }
                if (position == this.firstVisibleItem) {
                    helper.setBackgroundRes(R.id.item_main, R.drawable.shape_transparent_bg);
                    helper.setTextColor(R.id.msg_content, Color.parseColor((String)"#FFFFFFFF"));
                }
                if (this.firstVisibleItem == this.lastItemPosition) {
                    helper.setBackgroundRes(R.id.item_main, R.drawable.shape_transparent_bg_cc);
                    helper.setTextColor(R.id.msg_content, Color.parseColor((String)"#FFFFFFFF"));
                }
            }
            if (position == this.getData().size() - 1) {
                helper.setBackgroundRes(R.id.item_main, R.drawable.shape_transparent_bg_cc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TextView msg_content = (TextView)helper.getView(R.id.msg_content);
        if (msg_content != null) {
            msg_content.setMaxWidth((int)((double)DensityUtils.getScreenWidth() / 2.25));
        }
        if ("notice_tips".equals(item.getMsgId())) {
            helper.getView(R.id.tv_avatar).setVisibility(8);
            msg_content.setText((CharSequence)("\u3010\u516c\u544a\u3011\n" + item.getText_content()));
        }
        if (item == null || TextUtils.isEmpty((CharSequence)item.getUserId())) {
            return;
        }
        helper.addOnClickListener(new int[]{R.id.tv_avatar});
        EnumRoleName role = EnumRoleName.getRole(item.getRoleName());
        String showRoleText = this.getRoleNameStr(item.getRoleName());
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        String nick_name = item.getNickname();
        if (TextUtils.isEmpty((CharSequence)nick_name)) {
            nick_name = this.mContext.getString(R.string.chat_empty_name);
        }
        msg_content.setMovementMethod(LinkMovementMethod.getInstance());
        msg_content.setHintTextColor(this.context.getResources().getColor(17170445));
        if (TextUtils.equals((CharSequence)item.getRoleName(), (CharSequence)"3")) {
            helper.getView(R.id.tv_avatar).setVisibility(8);
            Resources resources = this.mContext.getResources();
            SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)" ");
            Drawable managerDrawable = this.mContext.getResources().getDrawable(R.drawable.chat_zhushou);
            managerDrawable.setBounds(0, 0, DensityUtils.dpToPxInt(35.0f), DensityUtils.dpToPxInt(18.0f));
            ImageSpan managerImageSpan = new ImageSpan(managerDrawable);
            ssb.setSpan((Object)managerImageSpan, 0, 1, 17);
            spannableStringBuilder.insert(0, (CharSequence)ssb);
            spannableStringBuilder.append((CharSequence)" ");
        }
        if (TextUtils.equals((CharSequence)item.getRoleName(), (CharSequence)"2")) {
            helper.getView(R.id.tv_avatar).setVisibility(8);
        }
        if (item.getMsgType() == 3) {
            VssMessageChatData.JumpMsgBean jumpMsgBean;
            final IChatProcessor processor = item.getChatProcessor();
            if (processor != null) {
                msg_content.setText((CharSequence)EmojiUtils.getEmojiText(this.context, processor.getShowText()));
                msg_content.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        processor.doAction(v);
                    }
                });
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)item.getText_content())) {
                int start = spannableStringBuilder.length();
                spannableStringBuilder.append((CharSequence)item.getText_content());
                spannableStringBuilder.setSpan((Object)new TextAppearanceSpan(this.context, R.style.style1), start, spannableStringBuilder.length(), 17);
            }
            if ((jumpMsgBean = item.getJumpMsgBean()) != null) {
                int start = spannableStringBuilder.length();
                spannableStringBuilder.append((CharSequence)jumpMsgBean.jumpMsg);
                spannableStringBuilder.setSpan((Object)new VhClickSpan(this.context, this.context.getResources().getColor(R.color.color_F0BE1C), false){

                    @Override
                    public void onClick(@NonNull View widget) {
                        final Bundle web = new Bundle();
                        web.putString("load_url", jumpMsgBean.url);
                        Bundle bundle = new Bundle();
                        bundle.putString("id", jumpMsgBean.id);
                        if (jumpMsgBean.msgType == 1) {
                            QuestionManager.getInstance().judgeQuestion(ChatAdapter.this.context, bundle, new CallBack<Boolean>(){

                                @Override
                                public void onSuccess(Boolean result) {
                                    if (result.booleanValue()) {
                                        VHToast.showShortToast(R.string.chat_msg_question);
                                    } else {
                                        VhallWebviewActivity.startActivity(ChatAdapter.this.context, web);
                                    }
                                }

                                @Override
                                public void onError(int eventCode, String msg) {
                                    VHToast.showShortToast(msg);
                                }
                            });
                        } else if (jumpMsgBean.msgType == 4) {
                            ExamManager.getInstance().judgeExam(ChatAdapter.this.context, bundle, new CallBack<JudgeBean>(){

                                @Override
                                public void onSuccess(JudgeBean result) {
                                    if (result != null) {
                                        if (result.is_finish) {
                                            VHToast.showShortToast(R.string.chat_msg_exam_finish);
                                            return;
                                        }
                                        if (result.is_answer) {
                                            VHToast.showShortToast(R.string.chat_msg_exam);
                                            return;
                                        }
                                        VhallWebviewActivity.startActivity(ChatAdapter.this.context, web);
                                    } else {
                                        VHToast.showShortToast("empty data");
                                    }
                                }

                                @Override
                                public void onError(int eventCode, String msg) {
                                    VHToast.showShortToast(msg);
                                }
                            });
                        } else if (jumpMsgBean.msgType == 3) {
                            VoteManager.getInstance().judgeVote(ChatAdapter.this.context, bundle, new CallBack<JudgeBean>(){

                                @Override
                                public void onSuccess(JudgeBean result) {
                                    if (result != null) {
                                        if (result.is_finish) {
                                            VHToast.showShortToast(R.string.chat_msg_vote_finish);
                                            return;
                                        }
                                        if (result.is_answer) {
                                            VHToast.showShortToast(R.string.chat_msg_vote);
                                            return;
                                        }
                                        VhallWebviewActivity.startActivity(ChatAdapter.this.context, web);
                                    } else {
                                        VHToast.showShortToast("empty data");
                                    }
                                }

                                @Override
                                public void onError(int eventCode, String msg) {
                                    VHToast.showShortToast(msg);
                                }
                            });
                        }
                    }
                }, start, spannableStringBuilder.length(), 17);
            }
            msg_content.setText((CharSequence)EmojiUtils.getEmojiText(this.context, (CharSequence)spannableStringBuilder));
            return;
        }
        if (item.getMsgType() == 0) {
            if (!TextUtils.isEmpty((CharSequence)item.getText_content())) {
                int start = spannableStringBuilder.length();
                spannableStringBuilder.append((CharSequence)item.getText_content());
                spannableStringBuilder.setSpan((Object)new TextAppearanceSpan(this.context, R.style.style1), start, spannableStringBuilder.length(), 17);
            }
        } else {
            String operateNickName = item.getOperateNickName();
            if (item.getMsgType() == 1) {
                String atMsg = item.getText_content();
                SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)atMsg);
                if (!TextUtils.isEmpty((CharSequence)operateNickName)) {
                    String[] split = operateNickName.split("@");
                    for (int i = 0; i < split.length; ++i) {
                        String insertString = "@" + split[i];
                        if (TextUtils.isEmpty((CharSequence)insertString) || !atMsg.contains(insertString)) continue;
                        int start = atMsg.indexOf(insertString);
                        ForegroundColorSpan span = new ForegroundColorSpan(Color.parseColor((String)"#1E90FF"));
                        ssb.setSpan((Object)span, start, start + insertString.length(), 17);
                    }
                }
                spannableStringBuilder.append((CharSequence)ssb);
            }
        }
        if (helper.getView(R.id.tv_avatar).getVisibility() == 0) {
            msg_content.setText((CharSequence)("" + EmojiUtils.getEmojiText(this.context, (CharSequence)spannableStringBuilder) + " "));
        } else {
            msg_content.setText((CharSequence)spannableStringBuilder);
        }
    }

    private String getRoleNameStr(String roleName) {
        EnumRoleName enumRoleName = EnumRoleName.getRole(roleName);
        if (enumRoleName == null || enumRoleName == EnumRoleName.viewer) {
            return "";
        }
        return enumRoleName.getName();
    }

    public void setCurrentPosition(int firstVisibleItem, int lastItemPosition) {
        this.firstVisibleItem = firstVisibleItem;
        this.lastItemPosition = lastItemPosition;
        this.notifyDataSetChanged();
    }
}

