/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget.pushView.base;

import android.os.Handler;
import android.os.Looper;
import com.vhall.appui.baselib.widget.pushView.base.TaskCallable;
import com.vhall.appui.baselib.widget.pushView.base.TaskThreadPoolExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TinyTaskExecutor {
    private static volatile TinyTaskExecutor sTinyTaskExecutor;
    private ExecutorService mExecutor;
    private volatile Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private static HashMap<Callable, Runnable> sDelayTasks;
    private static List futureList;
    public static final int PRIORITY_HIGH = 0;
    public static final int PRIORITY_NORMAL = 10;
    public static final int PRIORITY_LOWEST = 19;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TinyTaskExecutor getInstance() {
        if (sTinyTaskExecutor != null) return sTinyTaskExecutor;
        Class<TinyTaskExecutor> clazz = TinyTaskExecutor.class;
        synchronized (TinyTaskExecutor.class) {
            sTinyTaskExecutor = new TinyTaskExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sTinyTaskExecutor;
        }
    }

    public TinyTaskExecutor() {
        this.mExecutor = new TaskThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), Long.MAX_VALUE, TimeUnit.NANOSECONDS, new PriorityBlockingQueue<Runnable>(), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    private static ExecutorService getExecutor() {
        return TinyTaskExecutor.getInstance().mExecutor;
    }

    public static Handler getMainThreadHandler() {
        return TinyTaskExecutor.getInstance().mMainThreadHandler;
    }

    public static void execute(TaskCallable callable) {
        TinyTaskExecutor.execute(callable, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(final Callable callable, long delayMillisecond) {
        if (callable == null) {
            return;
        }
        if (delayMillisecond < 0L) {
            return;
        }
        if (!TinyTaskExecutor.getExecutor().isShutdown()) {
            if (delayMillisecond > 0L) {
                Runnable delayRunnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashMap hashMap = sDelayTasks;
                        synchronized (hashMap) {
                            sDelayTasks.remove(callable);
                        }
                        TinyTaskExecutor.realExecute(callable);
                    }
                };
                HashMap<Callable, Runnable> hashMap = sDelayTasks;
                synchronized (hashMap) {
                    sDelayTasks.put(callable, delayRunnable);
                }
                TinyTaskExecutor.getMainThreadHandler().postDelayed(delayRunnable, delayMillisecond);
            } else {
                TinyTaskExecutor.realExecute(callable);
            }
        }
    }

    private static void realExecute(Callable callable) {
        Future future = TinyTaskExecutor.getExecutor().submit(callable);
        futureList.add(future);
        System.out.println("[TinyTaskExecutor] realExecute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTask(Callable callable) {
        Runnable delayRunnable;
        if (callable == null) {
            return;
        }
        HashMap<Callable, Runnable> hashMap = sDelayTasks;
        synchronized (hashMap) {
            delayRunnable = sDelayTasks.remove(callable);
        }
        if (delayRunnable != null) {
            TinyTaskExecutor.getMainThreadHandler().removeCallbacks(delayRunnable);
        }
    }

    public static void check() {
        Iterator it = futureList.iterator();
        while (it.hasNext()) {
            FutureTask ft = (FutureTask)it.next();
            if (ft.isDone()) continue;
            try {
                System.out.println("[TinyTaskExecutor] the check result is: " + ft.get());
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            it.remove();
        }
    }

    public static void postToMainThread(Runnable task) {
        TinyTaskExecutor.postToMainThread(task, 0L);
    }

    public static void postToMainThread(Runnable task, long delayMillis) {
        if (task == null) {
            return;
        }
        TinyTaskExecutor.getMainThreadHandler().postDelayed(task, delayMillis);
    }

    public static void removeMainThreadRunnable(Runnable task) {
        if (task == null) {
            return;
        }
        TinyTaskExecutor.getMainThreadHandler().removeCallbacks(task);
    }

    static {
        sDelayTasks = new HashMap();
        futureList = new ArrayList();
    }
}

