/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget.pushView;

import android.content.Context;
import android.os.Handler;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.widget.pushView.base.BaseSyncTask;
import com.vhall.appui.baselib.widget.pushView.base.EnterSyncExecutor;

public class PushViewUtils {
    private View enterView;
    private Handler handlerEnter = new Handler();
    private Runnable runnableEnter;
    private Context mContext;
    private DismissCallBack dismissCallBack;
    private ShowCallBack showCallBack;
    private long enterExecuteTime = 1000L;
    private long lastEnterExecuteTime = 3000L;
    private EnterSyncExecutor enterSyncExecutor;

    public void setDismissCallBack(DismissCallBack dismissCallBack) {
        this.dismissCallBack = dismissCallBack;
    }

    public void setShowCallBack(ShowCallBack showCallBack) {
        this.showCallBack = showCallBack;
    }

    public PushViewUtils(Context context) {
        this.mContext = context;
        this.enterSyncExecutor = new EnterSyncExecutor();
    }

    public PushViewUtils(Context context, long enterExecuteTime, long lastEnterExecuteTime) {
        this.mContext = context;
        this.enterExecuteTime = enterExecuteTime;
        this.enterSyncExecutor = new EnterSyncExecutor();
        this.lastEnterExecuteTime = lastEnterExecuteTime;
    }

    public void intoShowEnter(View enterView, final Object data) {
        this.enterView = enterView;
        if (this.enterSyncExecutor.isLastTaskRunning()) {
            this.enterSyncExecutor.setLastTaskRunning(false);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    PushViewUtils.this.handlerEnter.removeCallbacks(PushViewUtils.this.runnableEnter);
                    PushViewUtils.this.dismissEnter();
                    PushViewUtils.this.addEnterToQueue(data);
                }
            }, 1000L);
        } else {
            this.addEnterToQueue(data);
        }
    }

    public void intoShowEnter(View enterView, Object data, long showTime) {
        this.lastEnterExecuteTime = showTime;
        this.intoShowEnter(enterView, data);
    }

    private void addEnterToQueue(final Object data) {
        BaseSyncTask task = new BaseSyncTask(){

            @Override
            public void doTask(boolean isLastTask, Object enterTxt) {
                if (isLastTask) {
                    PushViewUtils.this.showEnter(PushViewUtils.this.lastEnterExecuteTime, data);
                } else {
                    PushViewUtils.this.showEnter(PushViewUtils.this.enterExecuteTime, data);
                }
            }
        };
        task.setEnterData(data);
        this.enterSyncExecutor.enqueue(task);
    }

    private void showEnter(final long showTime, Object data) {
        if (this.enterView == null) {
            return;
        }
        this.enterView.setVisibility(0);
        if (this.showCallBack != null) {
            this.showCallBack.viewShow(this.enterView, data);
        }
        this.enterView.clearAnimation();
        Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.translate_user_enter);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                PushViewUtils.this.handlerEnter.postDelayed(PushViewUtils.this.runnableEnter = new Runnable(){

                    @Override
                    public void run() {
                        PushViewUtils.this.dismissEnter();
                    }
                }, showTime);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.enterView.startAnimation(animation);
    }

    private void dismissEnter() {
        if (this.enterView == null) {
            return;
        }
        if (this.enterView.getVisibility() == 8) {
            return;
        }
        this.enterView.clearAnimation();
        Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.translate_user_out);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (PushViewUtils.this.enterSyncExecutor.isLastTaskRunning()) {
                    PushViewUtils.this.enterView.setVisibility(8);
                } else {
                    PushViewUtils.this.enterView.setVisibility(4);
                }
                PushViewUtils.this.enterView.clearAnimation();
                PushViewUtils.this.enterSyncExecutor.finish();
                if (PushViewUtils.this.dismissCallBack != null) {
                    PushViewUtils.this.dismissCallBack.viewDismiss();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.enterView.startAnimation(animation);
    }

    public void dismissTask() {
        this.handlerEnter.removeCallbacks(this.runnableEnter);
        this.dismissEnter();
        this.enterView.setVisibility(8);
    }

    public void onDestroy() {
        this.enterSyncExecutor.clear();
    }

    public static interface ShowCallBack {
        public void viewShow(View var1, Object var2);
    }

    public static interface DismissCallBack {
        public void viewDismiss();
    }
}

