/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget.emoji;

import android.content.Context;
import android.text.Editable;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.widget.emoji.EmojiAdapter;
import com.vhall.appui.baselib.widget.emoji.EmojiGridView;
import com.vhall.logmanager.L;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmojiUtils {
    private static final String delete_name = "delete_expression";
    public static final String f000 = "[\u5fae\u7b11]";
    public static final String f001 = "[\u6487\u5634]";
    public static final String f002 = "[\u8272]";
    public static final String f003 = "[\u53d1\u5446]";
    public static final String f004 = "[\u5f97\u610f]";
    public static final String f005 = "[\u6d41\u6cea]";
    public static final String f006 = "[\u5bb3\u7f9e]";
    public static final String f007 = "[\u95ed\u5634]";
    public static final String f008 = "[\u7761]";
    public static final String f009 = "[\u54ed]";
    public static final String f010 = "[\u5c34\u5c2c]";
    public static final String f011 = "[\u53d1\u6012]";
    public static final String f012 = "[\u8c03\u76ae]";
    public static final String f013 = "[\u5472\u7259]";
    public static final String f014 = "[\u60ca\u8bb6]";
    public static final String f015 = "[\u96be\u8fc7]";
    public static final String f016 = "[\u9177]";
    public static final String f017 = "[\u6c57]";
    public static final String f018 = "[\u6293\u72c2]";
    public static final String f019 = "[\u5410]";
    public static final String f020 = "[\u5077\u7b11]";
    public static final String f021 = "[\u6109\u5feb]";
    public static final String f022 = "[\u767d\u773c]";
    public static final String f023 = "[\u50b2\u6162]";
    public static final String f024 = "[\u9965\u997f]";
    public static final String f025 = "[\u56f0]";
    public static final String f026 = "[\u60ca\u6050]";
    public static final String f027 = "[\u6d41\u6c57]";
    public static final String f028 = "[\u61a8\u7b11]";
    public static final String f029 = "[\u60a0\u95f2]";
    public static final String f030 = "[\u594b\u6597]";
    public static final String f031 = "[\u5492\u9a82]";
    public static final String f032 = "[\u7591\u95ee]";
    public static final String f033 = "[\u5618]";
    public static final String f034 = "[\u6655]";
    public static final String f035 = "[\u75af\u4e86]";
    public static final String f036 = "[\u8870]";
    public static final String f037 = "[\u9ab7\u9ac5]";
    public static final String f038 = "[\u6572\u6253]";
    public static final String f039 = "[\u518d\u89c1]";
    public static final String f040 = "[\u64e6\u6c57]";
    public static final String f041 = "[\u62a0\u9f3b]";
    public static final String f042 = "[\u9f13\u638c]";
    public static final String f043 = "[\u7cd7\u5927\u4e86]";
    public static final String f044 = "[\u574f\u7b11]";
    public static final String f045 = "[\u5de6\u54fc\u54fc]";
    public static final String f046 = "[\u53f3\u54fc\u54fc]";
    public static final String f047 = "[\u54c8\u6b20]";
    public static final String f048 = "[\u9119\u89c6]";
    public static final String f049 = "[\u59d4\u5c48]";
    public static final String f050 = "[\u5feb\u54ed\u4e86]";
    public static final String f051 = "[\u9634\u9669]";
    public static final String f052 = "[\u4eb2\u4eb2]";
    public static final String f053 = "[\u5413]";
    public static final String f054 = "[\u53ef\u601c]";
    public static final String f055 = "[\u83dc\u5200]";
    public static final String f056 = "[\u897f\u74dc]";
    public static final String f057 = "[\u5564\u9152]";
    public static final String f058 = "[\u7bee\u7403]";
    public static final String f059 = "[\u4e52\u4e53]";
    public static final String f060 = "[\u5496\u5561]";
    public static final String f061 = "[\u996d]";
    public static final String f062 = "[\u732a\u5934]";
    public static final String f063 = "[\u73ab\u7470]";
    public static final String f064 = "[\u51cb\u8c22]";
    public static final String f065 = "[\u5634\u5507]";
    public static final String f066 = "[\u7231\u5fc3]";
    public static final String f067 = "[\u5fc3\u788e]";
    public static final String f068 = "[\u86cb\u7cd5]";
    public static final String f069 = "[\u95ea\u7535]";
    public static final String f070 = "[\u70b8\u5f39]";
    public static final String f071 = "[\u5200]";
    public static final String f072 = "[\u8db3\u7403]";
    public static final String f073 = "[\u74e2\u866b]";
    public static final String f074 = "[\u4fbf\u4fbf]";
    public static final String f075 = "[\u6708\u4eae]";
    public static final String f076 = "[\u592a\u9633]";
    public static final String f077 = "[\u793c\u7269]";
    public static final String f078 = "[\u62e5\u62b1]";
    public static final String f079 = "[\u5f3a]";
    public static final String f080 = "[\u5f31]";
    public static final String f081 = "[\u63e1\u624b]";
    public static final String f082 = "[\u80dc\u5229]";
    public static final String f083 = "[\u62b1\u62f3]";
    public static final String f084 = "[\u52fe\u5f15]";
    public static final String f085 = "[\u62f3\u5934]";
    public static final String f086 = "[\u5dee\u52b2]";
    public static final String f087 = "[\u7231\u4f60]";
    public static final String f088 = "[NO]";
    public static final String f089 = "[OK]";
    private static final Spannable.Factory spannableFactory = Spannable.Factory.getInstance();
    private static final Map<Pattern, Integer> emoticons = new HashMap<Pattern, Integer>();

    private static void addPattern(Map<Pattern, Integer> map, String smile, int resource) {
        map.put(Pattern.compile(Pattern.quote(smile)), resource);
    }

    public static boolean addEmoji(Context context, Spannable spannable) {
        boolean hasChanges = false;
        for (Map.Entry<Pattern, Integer> entry : emoticons.entrySet()) {
            Matcher matcher = entry.getKey().matcher((CharSequence)spannable);
            while (matcher.find()) {
                boolean set = true;
                for (ImageSpan span : (ImageSpan[])spannable.getSpans(matcher.start(), matcher.end(), ImageSpan.class)) {
                    if (spannable.getSpanStart((Object)span) < matcher.start() || spannable.getSpanEnd((Object)span) > matcher.end()) {
                        set = false;
                        break;
                    }
                    spannable.removeSpan((Object)span);
                }
                if (!set) continue;
                hasChanges = true;
                spannable.setSpan((Object)new ImageSpan(context, entry.getValue().intValue()), matcher.start(), matcher.end(), 33);
            }
        }
        return hasChanges;
    }

    public static Spannable getEmojiText(Context context, CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        Spannable spannable = spannableFactory.newSpannable(text);
        EmojiUtils.addEmoji(context, spannable);
        return spannable;
    }

    public static boolean containsKey(String key) {
        boolean b = false;
        for (Map.Entry<Pattern, Integer> entry : emoticons.entrySet()) {
            Matcher matcher = entry.getKey().matcher(key);
            if (!matcher.find()) continue;
            b = true;
            break;
        }
        return b;
    }

    public static List<String> getExpressionRes(int getSum) {
        ArrayList<String> reslist = new ArrayList<String>();
        for (int x = 0; x < getSum; ++x) {
            String filename = String.format("f%03d", x);
            reslist.add(filename);
        }
        return reslist;
    }

    public static View getGridChildView(final Context context, int i, List<String> reslist, final EditText et_chat) {
        View view = View.inflate((Context)context, (int)R.layout.emoji_grid, null);
        WindowManager wm = (WindowManager)context.getSystemService("window");
        int width = wm.getDefaultDisplay().getWidth();
        int height = wm.getDefaultDisplay().getHeight();
        int screenWidth = width;
        EmojiGridView gv = (EmojiGridView)view.findViewById(R.id.gv_emoji);
        ArrayList<String> list = new ArrayList<String>();
        if (i == 4) {
            list.addAll(reslist.subList((i - 1) * 23, reslist.size()));
        } else {
            list.addAll(reslist.subList((i - 1) * 23, i * 23));
        }
        gv.setSelector(17170445);
        gv.setNumColumns(6);
        int spacing = DensityUtils.dpToPxInt(context, 10);
        gv.setPadding(spacing, spacing, spacing, spacing);
        int itemWidth = (screenWidth - spacing * 8) / 6;
        list.add(delete_name);
        final EmojiAdapter expressionAdapter = new EmojiAdapter(context, 1, list, itemWidth);
        gv.setAdapter((ListAdapter)expressionAdapter);
        gv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String filename = (String)expressionAdapter.getItem(position);
                try {
                    int selectionStart;
                    if (filename != EmojiUtils.delete_name) {
                        Class<EmojiUtils> clz = EmojiUtils.class;
                        Field field = clz.getField(filename);
                        int index = et_chat.getSelectionStart();
                        Spannable text = EmojiUtils.getEmojiText(context, (String)field.get(null));
                        Editable edit = et_chat.getEditableText();
                        if (index < 0 || index >= edit.length()) {
                            edit.append((CharSequence)text);
                        } else {
                            edit.insert(index, (CharSequence)text);
                        }
                    } else if (!TextUtils.isEmpty((CharSequence)et_chat.getText()) && (selectionStart = et_chat.getSelectionStart()) > 0) {
                        String body = et_chat.getText().toString();
                        String tempStr = body.substring(0, selectionStart);
                        int i = tempStr.lastIndexOf("[");
                        if (i != -1) {
                            String cs = tempStr.substring(i, selectionStart);
                            if (EmojiUtils.containsKey(cs.toString())) {
                                et_chat.getEditableText().delete(i, selectionStart);
                            } else {
                                et_chat.getEditableText().delete(selectionStart - 1, selectionStart);
                            }
                        } else {
                            et_chat.getEditableText().delete(selectionStart - 1, selectionStart);
                        }
                    }
                }
                catch (Exception e) {
                    L.e((String)"EmojiUtils", (String)e.getMessage());
                }
            }
        });
        return view;
    }

    static {
        EmojiUtils.addPattern(emoticons, f000, R.mipmap.f000);
        EmojiUtils.addPattern(emoticons, f001, R.mipmap.f001);
        EmojiUtils.addPattern(emoticons, f002, R.mipmap.f002);
        EmojiUtils.addPattern(emoticons, f003, R.mipmap.f003);
        EmojiUtils.addPattern(emoticons, f004, R.mipmap.f004);
        EmojiUtils.addPattern(emoticons, f005, R.mipmap.f005);
        EmojiUtils.addPattern(emoticons, f006, R.mipmap.f006);
        EmojiUtils.addPattern(emoticons, f007, R.mipmap.f007);
        EmojiUtils.addPattern(emoticons, f008, R.mipmap.f008);
        EmojiUtils.addPattern(emoticons, f009, R.mipmap.f009);
        EmojiUtils.addPattern(emoticons, f010, R.mipmap.f010);
        EmojiUtils.addPattern(emoticons, f011, R.mipmap.f011);
        EmojiUtils.addPattern(emoticons, f012, R.mipmap.f012);
        EmojiUtils.addPattern(emoticons, f013, R.mipmap.f013);
        EmojiUtils.addPattern(emoticons, f014, R.mipmap.f014);
        EmojiUtils.addPattern(emoticons, f015, R.mipmap.f015);
        EmojiUtils.addPattern(emoticons, f016, R.mipmap.f016);
        EmojiUtils.addPattern(emoticons, f017, R.mipmap.f017);
        EmojiUtils.addPattern(emoticons, f018, R.mipmap.f018);
        EmojiUtils.addPattern(emoticons, f019, R.mipmap.f019);
        EmojiUtils.addPattern(emoticons, f020, R.mipmap.f020);
        EmojiUtils.addPattern(emoticons, f021, R.mipmap.f021);
        EmojiUtils.addPattern(emoticons, f022, R.mipmap.f022);
        EmojiUtils.addPattern(emoticons, f023, R.mipmap.f023);
        EmojiUtils.addPattern(emoticons, f024, R.mipmap.f024);
        EmojiUtils.addPattern(emoticons, f025, R.mipmap.f025);
        EmojiUtils.addPattern(emoticons, f026, R.mipmap.f026);
        EmojiUtils.addPattern(emoticons, f027, R.mipmap.f027);
        EmojiUtils.addPattern(emoticons, f028, R.mipmap.f028);
        EmojiUtils.addPattern(emoticons, f029, R.mipmap.f029);
        EmojiUtils.addPattern(emoticons, f030, R.mipmap.f030);
        EmojiUtils.addPattern(emoticons, f031, R.mipmap.f031);
        EmojiUtils.addPattern(emoticons, f032, R.mipmap.f032);
        EmojiUtils.addPattern(emoticons, f033, R.mipmap.f033);
        EmojiUtils.addPattern(emoticons, f034, R.mipmap.f034);
        EmojiUtils.addPattern(emoticons, f035, R.mipmap.f035);
        EmojiUtils.addPattern(emoticons, f036, R.mipmap.f036);
        EmojiUtils.addPattern(emoticons, f037, R.mipmap.f037);
        EmojiUtils.addPattern(emoticons, f038, R.mipmap.f038);
        EmojiUtils.addPattern(emoticons, f039, R.mipmap.f039);
        EmojiUtils.addPattern(emoticons, f040, R.mipmap.f040);
        EmojiUtils.addPattern(emoticons, f041, R.mipmap.f041);
        EmojiUtils.addPattern(emoticons, f042, R.mipmap.f042);
        EmojiUtils.addPattern(emoticons, f043, R.mipmap.f043);
        EmojiUtils.addPattern(emoticons, f044, R.mipmap.f044);
        EmojiUtils.addPattern(emoticons, f045, R.mipmap.f045);
        EmojiUtils.addPattern(emoticons, f046, R.mipmap.f046);
        EmojiUtils.addPattern(emoticons, f047, R.mipmap.f047);
        EmojiUtils.addPattern(emoticons, f048, R.mipmap.f048);
        EmojiUtils.addPattern(emoticons, f049, R.mipmap.f049);
        EmojiUtils.addPattern(emoticons, f050, R.mipmap.f050);
        EmojiUtils.addPattern(emoticons, f051, R.mipmap.f051);
        EmojiUtils.addPattern(emoticons, f052, R.mipmap.f052);
        EmojiUtils.addPattern(emoticons, f053, R.mipmap.f053);
        EmojiUtils.addPattern(emoticons, f054, R.mipmap.f054);
        EmojiUtils.addPattern(emoticons, f055, R.mipmap.f055);
        EmojiUtils.addPattern(emoticons, f056, R.mipmap.f056);
        EmojiUtils.addPattern(emoticons, f057, R.mipmap.f057);
        EmojiUtils.addPattern(emoticons, f058, R.mipmap.f058);
        EmojiUtils.addPattern(emoticons, f059, R.mipmap.f059);
        EmojiUtils.addPattern(emoticons, f060, R.mipmap.f060);
        EmojiUtils.addPattern(emoticons, f061, R.mipmap.f061);
        EmojiUtils.addPattern(emoticons, f062, R.mipmap.f062);
        EmojiUtils.addPattern(emoticons, f063, R.mipmap.f063);
        EmojiUtils.addPattern(emoticons, f064, R.mipmap.f064);
        EmojiUtils.addPattern(emoticons, f065, R.mipmap.f065);
        EmojiUtils.addPattern(emoticons, f066, R.mipmap.f066);
        EmojiUtils.addPattern(emoticons, f067, R.mipmap.f067);
        EmojiUtils.addPattern(emoticons, f068, R.mipmap.f068);
        EmojiUtils.addPattern(emoticons, f069, R.mipmap.f069);
        EmojiUtils.addPattern(emoticons, f070, R.mipmap.f070);
        EmojiUtils.addPattern(emoticons, f071, R.mipmap.f071);
        EmojiUtils.addPattern(emoticons, f072, R.mipmap.f072);
        EmojiUtils.addPattern(emoticons, f073, R.mipmap.f073);
        EmojiUtils.addPattern(emoticons, f074, R.mipmap.f074);
        EmojiUtils.addPattern(emoticons, f075, R.mipmap.f075);
        EmojiUtils.addPattern(emoticons, f076, R.mipmap.f076);
        EmojiUtils.addPattern(emoticons, f077, R.mipmap.f077);
        EmojiUtils.addPattern(emoticons, f078, R.mipmap.f078);
        EmojiUtils.addPattern(emoticons, f079, R.mipmap.f079);
        EmojiUtils.addPattern(emoticons, f080, R.mipmap.f080);
        EmojiUtils.addPattern(emoticons, f081, R.mipmap.f081);
        EmojiUtils.addPattern(emoticons, f082, R.mipmap.f082);
        EmojiUtils.addPattern(emoticons, f083, R.mipmap.f083);
        EmojiUtils.addPattern(emoticons, f084, R.mipmap.f084);
        EmojiUtils.addPattern(emoticons, f085, R.mipmap.f085);
        EmojiUtils.addPattern(emoticons, f086, R.mipmap.f086);
        EmojiUtils.addPattern(emoticons, f087, R.mipmap.f087);
        EmojiUtils.addPattern(emoticons, f088, R.mipmap.f088);
        EmojiUtils.addPattern(emoticons, f089, R.mipmap.f089);
    }
}

