/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.VhSdk;
import com.vhall.appui.baselib.base.BaseBottomDialog;
import com.vhall.appui.baselib.base.MyBaseViewHolder;
import com.vhall.appui.baselib.net.bean.GoodsResultBean;
import com.vhall.appui.baselib.net.utils.CoreNetCallback;
import com.vhall.appui.baselib.network.CommonManagerNetWrapper;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.main.network.MainListWrapper;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;

public class VhGoodsListView
extends BaseBottomDialog {
    private RecyclerView goods_recycler_view;
    private ImageView none_data_bg;
    private GoodsAdapter adapter;
    private ResponseRoomInfo roomInfo;
    private FragmentActivity activity;
    private NumCallback callback;
    private SmartRefreshLayout refresh_layout;
    private int page = 1;

    public VhGoodsListView(Context context, ResponseRoomInfo roomInfo, FragmentActivity activity) {
        super(context);
        this.roomInfo = roomInfo;
        this.activity = activity;
    }

    public BaseBottomDialog setNumCallBack(NumCallback numCallBack) {
        this.callback = numCallBack;
        return this;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.setContentView(R.layout.good_lisst_dialog);
        this.findViewById(R.id.view_top).setOnClickListener(v -> this.dismiss());
        this.goods_recycler_view = (RecyclerView)this.findViewById(R.id.goods_recycler_view);
        this.none_data_bg = (ImageView)this.findViewById(R.id.none_data_bg);
        this.refresh_layout = (SmartRefreshLayout)this.findViewById(R.id.refresh_layout);
        this.goods_recycler_view.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.adapter = new GoodsAdapter();
        this.goods_recycler_view.setAdapter((RecyclerView.Adapter)this.adapter);
        this.refresh_layout.setOnRefreshLoadMoreListener(new OnRefreshLoadMoreListener(){

            public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
                VhGoodsListView.this.page++;
                VhGoodsListView.this.getData();
            }

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                VhGoodsListView.this.page = 1;
                VhGoodsListView.this.getData();
            }
        });
        this.adapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                GoodsResultBean.ListBean item = (GoodsResultBean.ListBean)adapter.getItem(position);
                if (VhGoodsListView.this.callback != null) {
                    VhGoodsListView.this.callback.openFloat(item);
                    VhGoodsListView.this.goodsClick(item.getArticle_id());
                    VhGoodsListView.this.dismiss();
                }
            }
        });
        this.adapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener(){

            public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                GoodsResultBean.ListBean item;
                if (view.getId() == R.id.goods_pay && (item = (GoodsResultBean.ListBean)adapter.getItem(position)) != null && !TextUtils.isEmpty((CharSequence)item.getArticle_id()) && VhSdk.getInstance().vhallCallback != null && VhGoodsListView.this.activity != null && null != VhGoodsListView.this.activity && VhGoodsListView.this.callback != null) {
                    VhGoodsListView.this.callback.openFloat(item);
                    VhGoodsListView.this.goodsClick(item.getArticle_id());
                    VhGoodsListView.this.dismiss();
                }
            }
        });
        this.refresh_layout.autoRefresh();
    }

    private void goodsClick(String article_id) {
        if (this.roomInfo == null) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("room_id", this.roomInfo.getRoom_id());
        param.put("article_id", article_id);
        MainListWrapper.getGoodsClick(param, new CoreNetCallback(new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                VhLog.d(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhLog.d(msg);
            }
        }));
    }

    private void getData() {
        if (this.roomInfo == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", this.roomInfo.getRoom_id());
        params.put("page", this.page + "");
        params.put("page_size", "10");
        CommonManagerNetWrapper.getGoodsList(params, new CallBack<GoodsResultBean>(){

            @Override
            public void onSuccess(GoodsResultBean result) {
                VhGoodsListView.this.refresh_layout.finishRefresh();
                VhGoodsListView.this.refresh_layout.finishLoadMore();
                AlphaAnimation disappearAnimation = new AlphaAnimation(1.0f, 0.4f);
                disappearAnimation.setDuration(500L);
                if (VhGoodsListView.this.none_data_bg.getVisibility() == 0) {
                    VhGoodsListView.this.none_data_bg.startAnimation((Animation)disappearAnimation);
                }
                disappearAnimation.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        VhGoodsListView.this.refresh_layout.setVisibility(0);
                        VhGoodsListView.this.none_data_bg.setVisibility(8);
                        VhGoodsListView.this.refresh_layout.setVisibility(0);
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
                if (result != null && result.getList() != null && result.getList().size() > 0) {
                    if (VhGoodsListView.this.callback != null) {
                        VhGoodsListView.this.callback.callback(result.getTotal());
                    }
                    List<GoodsResultBean.ListBean> data = result.getList();
                    if (VhGoodsListView.this.page == 1) {
                        VhGoodsListView.this.adapter.setNewData(data);
                    } else {
                        VhGoodsListView.this.adapter.addData(data);
                    }
                } else if (VhGoodsListView.this.page > 1) {
                    VhGoodsListView.this.page--;
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhLog.d(msg);
                VhGoodsListView.this.refresh_layout.finishRefresh();
                VhGoodsListView.this.refresh_layout.finishLoadMore();
                VHToast.showLongToast((Context)M.context, msg);
            }
        });
    }

    public class GoodsAdapter
    extends BaseQuickAdapter<GoodsResultBean.ListBean, MyBaseViewHolder> {
        public GoodsAdapter() {
            super(R.layout.goods_item);
        }

        protected void convert(final @NonNull MyBaseViewHolder helper, GoodsResultBean.ListBean item) {
            TextView histroy_price = (TextView)helper.getView(R.id.histroy_price);
            histroy_price.getPaint().setFlags(17);
            if (item.getNumber() < 10) {
                helper.setText(R.id.goods_num, "  " + item.getNumber() + "  ");
            } else if (item.getNumber() >= 10 && item.getNumber() < 100) {
                helper.setText(R.id.goods_num, " " + item.getNumber() + " ");
            } else {
                helper.setText(R.id.goods_num, " " + item.getNumber() + " ");
            }
            DecimalFormat df = new DecimalFormat("0.00");
            helper.setText(R.id.goods_titile, item.getArticle_name() + "");
            helper.setText(R.id.goods_desc, item.getSub_title() + "");
            helper.setText(R.id.current_price, "\u00a5 " + df.format(Double.parseDouble(item.getDiscount_price())) + "");
            helper.setText(R.id.histroy_price, "\u00a5 " + df.format(Double.parseDouble(item.getSale_price())) + "");
            if (TextUtils.equals((CharSequence)item.getDiscount_price(), (CharSequence)item.getSale_price())) {
                helper.setVisible(R.id.histroy_price, false);
                helper.setTextColor(R.id.current_price, Color.parseColor((String)"#000000"));
            } else {
                helper.setVisible(R.id.histroy_price, true);
                helper.setTextColor(R.id.current_price, Color.parseColor((String)"#D83F56"));
                helper.setTextColor(R.id.histroy_price, Color.parseColor((String)"#000000"));
            }
            helper.addOnClickListener(new int[]{R.id.goods_pay});
            Glide.with((Context)this.mContext).load(item.getImage_url()).listener((RequestListener)new RequestListener<Drawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    helper.getView(R.id.goods_num).setVisibility(8);
                    helper.getView(R.id.goods_pay).setVisibility(8);
                    return false;
                }

                public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    helper.getView(R.id.goods_num).setVisibility(0);
                    helper.getView(R.id.goods_pay).setVisibility(0);
                    return false;
                }
            }).into((ImageView)helper.getView(R.id.goods_iv));
        }
    }

    public static interface NumCallback {
        public void callback(int var1);

        public void openFloat(GoodsResultBean.ListBean var1);
    }
}

