/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.R;

public class TriangleView
extends View {
    private final int TOP = 0;
    private final int BOTTOM = 1;
    private final int RIGHT = 2;
    private final int LEFT = 3;
    private Paint mPaint = new Paint();
    private int color = -16777216;
    private int width = 50;
    private int height = 50;
    private int direction = 0;

    public TriangleView(Context context) {
        super(context);
    }

    public TriangleView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.triangle, 0, 0);
        this.color = a.getColor(R.styleable.triangle_sjv_color, this.color);
        this.width = (int)a.getDimension(R.styleable.triangle_sjv_resolutionWidth, (float)this.width);
        this.height = (int)a.getDimension(R.styleable.triangle_sjv_resolutionHeight, (float)this.height);
        this.direction = a.getInt(R.styleable.triangle_sjv_direction, this.direction);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.width, this.height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(this.color);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        Path path = new Path();
        switch (this.direction) {
            case 0: {
                path.moveTo(0.0f, (float)this.width);
                path.lineTo((float)this.width, (float)this.height);
                path.lineTo((float)(this.width / 2), 0.0f);
                break;
            }
            case 1: {
                path.moveTo(0.0f, 0.0f);
                path.lineTo((float)(this.width / 2), (float)this.height);
                path.lineTo((float)this.width, 0.0f);
                break;
            }
            case 2: {
                path.moveTo(0.0f, 0.0f);
                path.lineTo(0.0f, (float)this.height);
                path.lineTo((float)this.width, (float)(this.height / 2));
                break;
            }
            case 3: {
                path.moveTo(0.0f, (float)(this.height / 2));
                path.lineTo((float)this.width, (float)this.height);
                path.lineTo((float)this.width, 0.0f);
            }
        }
        path.close();
        canvas.drawPath(path, this.mPaint);
    }
}

