/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.vhall.appui.baselib.widget.StreamItem;
import com.vhall.vhallrtc.client.Stream;
import java.util.HashMap;
import java.util.Map;

public class StreamItemContainerView
extends HorizontalScrollView {
    private Context mContext;
    private LinearLayout linearLayout;

    public StreamItemContainerView(Context context) {
        super(context);
        this.mContext = context;
        this.initView();
    }

    public StreamItemContainerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView();
    }

    public StreamItemContainerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initView();
    }

    @RequiresApi(api=21)
    public StreamItemContainerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        this.linearLayout = new LinearLayout(this.mContext);
        this.linearLayout.setOrientation(0);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        this.addView((View)this.linearLayout, layoutParams);
    }

    public void addItem(StreamItem item, ViewGroup.LayoutParams params) {
        this.linearLayout.addView(item.getView(), params);
    }

    public void removeItem(Stream stream) {
        if (stream == null) {
            return;
        }
        int childCount = this.linearLayout.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.linearLayout.getChildAt(i);
            StreamItem item = (StreamItem)view.getTag();
            Stream mStream = item.getStream();
            if (mStream == null || mStream != stream && !mStream.streamId.equals(stream.streamId)) continue;
            this.linearLayout.removeView(view);
            break;
        }
    }

    public void removeAllItem() {
        int childCount = this.linearLayout.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.linearLayout.getChildAt(i);
            StreamItem item = (StreamItem)view.getTag();
            Stream mStream = item.getStream();
            if (mStream == null) continue;
            this.linearLayout.removeView(view);
        }
    }

    public boolean changeStream(Stream stream) {
        if (stream == null) {
            return true;
        }
        boolean added = false;
        for (int i = 0; i < this.linearLayout.getChildCount(); ++i) {
            View v = this.linearLayout.getChildAt(i);
            StreamItem item = (StreamItem)v.getTag();
            if (item.mStream == null || !item.mStream.streamId.equals(stream.streamId)) continue;
            stream.removeAllRenderView();
            stream.addRenderView(item.getRenderView());
            added = true;
            break;
        }
        return added;
    }

    public void setItemStatus(String userId, int param, String action) {
        if (TextUtils.isEmpty((CharSequence)userId) && param == -1) {
            this.setAllItem(action);
            return;
        }
        for (int i = 0; i < this.linearLayout.getChildCount(); ++i) {
            View v = this.linearLayout.getChildAt(i);
            StreamItem item = (StreamItem)v.getTag();
            if (item.mStream == null || !item.mStream.userId.equals(userId)) continue;
            item.setParam(param, action);
        }
    }

    public void setAllItem(String action) {
        for (int i = 0; i < this.linearLayout.getChildCount(); ++i) {
            View v = this.linearLayout.getChildAt(i);
            StreamItem item = (StreamItem)v.getTag();
            if (item.mStream == null) continue;
            item.setParam(1, action);
        }
    }

    public Map<String, Stream> getAllStream() {
        HashMap<String, Stream> streamMap = new HashMap<String, Stream>();
        for (int i = 0; i < this.linearLayout.getChildCount(); ++i) {
            View v = this.linearLayout.getChildAt(i);
            StreamItem item = (StreamItem)v.getTag();
            if (item.mStream == null) continue;
            streamMap.put(item.mStream.userId, item.mStream);
        }
        return streamMap;
    }
}

