/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.alibaba.fastjson.JSON;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.IDevice;
import com.vhall.appui.baselib.bean.AttributesBean;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.utils.InteractiveUtils;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.utils.UserUtils;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.module.room.ProxyVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import com.vhall.vhallrtc.client.Stream;
import com.vhall.vhallrtc.client.VHRenderView;
import io.reactivex.disposables.Disposable;
import org.json.JSONObject;
import org.webrtc.SurfaceViewRenderer;

public class StreamItem {
    public static final int PARAM_VIDEO = 0;
    public static final int PARAM_AUDIO = 1;
    public static final int PARAM_All = -1;
    public static final String ACTION_OPEN = "open";
    public static final String ACTION_CLOSE = "close";
    TextView header_icon;
    View mView;
    VHRenderView mRenderview;
    Stream mStream;
    Context mContext;
    OnStreamItemClickListener mListener;
    public boolean isVideoAvailable = true;
    public boolean isAudioAvailable = true;
    public UserUtils mUserUtils;
    private View audio_off;
    private View camera_off;
    private TextView nick_name;
    private ProxyVssMessageListener listener;
    private Disposable mDisposable;

    public void setListener(OnStreamItemClickListener listener) {
        this.mListener = listener;
    }

    public StreamItem(Context context) {
        this.mContext = context;
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.item_video_layout, null);
        this.mRenderview = (VHRenderView)this.mView.findViewById(R.id.renderview);
        this.audio_off = this.mView.findViewById(R.id.audio_off);
        this.header_icon = (TextView)this.mView.findViewById(R.id.header_icon);
        this.camera_off = this.mView.findViewById(R.id.camera_off);
        this.nick_name = (TextView)this.mView.findViewById(R.id.nick_name);
        this.mRenderview.getHolder().setFormat(-2);
        this.mRenderview.setZOrderMediaOverlay(true);
        this.mRenderview.init(null, null);
        this.mRenderview.setScalingMode(SurfaceViewRenderer.VHRenderViewScalingMode.kVHRenderViewScalingModeAspectFill);
        this.mView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (StreamItem.this.mListener != null && StreamItem.this.mStream != null) {
                    StreamItem.this.mListener.onItemClick(StreamItem.this);
                }
            }
        });
        this.mView.setTag((Object)this);
        this.listener = new ProxyVssMessageListener(new RoomListenerInternalImpl());
        this.listener.setFilterOtherMsg(false);
        VssRoomManager.getInstance().setVssMessageListener(this.listener);
    }

    public View getView() {
        return this.mView;
    }

    public Stream getStream() {
        return this.mStream;
    }

    public VHRenderView getRenderView() {
        return this.mRenderview;
    }

    public void setStream(Stream stream) {
        if (stream == null) {
            return;
        }
        this.mStream = stream;
        stream.removeAllRenderView();
        stream.addRenderView(this.mRenderview);
        this.audio_off.setVisibility(InteractiveUtils.hasAudio(stream) ? 8 : 0);
        this.camera_off.setVisibility(InteractiveUtils.hasVideo(stream) ? 8 : 0);
        this.header_icon.setVisibility(InteractiveUtils.hasVideo(stream) ? 8 : 0);
        if (TextUtils.equals((CharSequence)AccountManager.getInstance().getUserId(), (CharSequence)stream.userId)) {
            this.nick_name.setText((CharSequence)AccountManager.getInstance().getNickName());
            this.header_icon.setText((CharSequence)UserUtils.getAvatarText(AccountManager.getInstance().getNickName()));
        } else {
            this.nick_name.setText((CharSequence)VssRoomManager.getInstance().getRoomInfo().getHostNickName());
            this.header_icon.setText((CharSequence)UserUtils.getAvatarText(VssRoomManager.getInstance().getRoomInfo().getHostNickName()));
        }
        try {
            String attributes = stream.getAttributes();
            AttributesBean attributesBean = (AttributesBean)JSON.parseObject((String)attributes, AttributesBean.class);
            if (TextUtils.equals((CharSequence)this.mStream.userId, (CharSequence)attributesBean.getAccount_id())) {
                InternalUtils.setMaxLength(2, this.nick_name, attributesBean.getNick_name());
                this.header_icon.setText((CharSequence)UserUtils.getAvatarText(attributesBean.getNick_name()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showAudio(boolean show) {
        if (this.mStream == null) {
            return;
        }
        this.audio_off.setVisibility(show ? 0 : 8);
    }

    public void showCamera(boolean show) {
        if (this.mStream == null) {
            return;
        }
        this.camera_off.setVisibility(show ? 0 : 8);
        this.header_icon.setVisibility(show ? 0 : 8);
    }

    public void setParam(int param, String action) {
        switch (param) {
            case 0: {
                this.isVideoAvailable = action.equals(ACTION_OPEN);
                break;
            }
            case 1: {
                this.isAudioAvailable = action.equals(ACTION_OPEN);
                break;
            }
        }
    }

    public void setUser(UserUtils userUtils) {
        this.mUserUtils = userUtils;
    }

    private void scheduleDeviceStatus(MessageData msg, IDevice.Device device, boolean open) {
        if (this.mStream == null) {
            return;
        }
        JSONObject jsonObject = (JSONObject)msg.getT();
        if (jsonObject != null) {
            String userId = jsonObject.optString("user_id");
            if (TextUtils.equals((CharSequence)userId, (CharSequence)this.mStream.userId) && device == IDevice.Device.Audio) {
                this.showAudio(!open);
            } else if (TextUtils.equals((CharSequence)userId, (CharSequence)this.mStream.userId) && device == IDevice.Device.Video) {
                this.showCamera(!open);
            }
        }
    }

    public void release() {
        InternalUtils.releaseVHRenderView(this.mRenderview);
    }

    private class RoomListenerInternalImpl
    implements IVssMessageListener {
        private RoomListenerInternalImpl() {
        }

        @Override
        public void onMessage(MessageData msg) {
            switch (msg.getType()) {
                case "vrtc_mute": {
                    StreamItem.this.scheduleDeviceStatus(msg, IDevice.Device.Audio, false);
                    break;
                }
                case "vrtc_mute_cancel": {
                    StreamItem.this.scheduleDeviceStatus(msg, IDevice.Device.Audio, true);
                    break;
                }
                case "vrtc_frames_forbid": {
                    StreamItem.this.scheduleDeviceStatus(msg, IDevice.Device.Video, false);
                    break;
                }
                case "vrtc_frames_display": {
                    StreamItem.this.scheduleDeviceStatus(msg, IDevice.Device.Video, true);
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
        }
    }

    public static interface OnStreamItemClickListener {
        public void onItemClick(StreamItem var1);
    }
}

