/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.os.Handler;
import android.os.Message;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.vss.VssSdk;
import com.vhall.appui.baselib.vss.data.ResponseScrollingInfo;
import com.vhall.appui.baselib.vss.utils.handler.WeakHandler;

public class ScrollingTextView
extends SurfaceView
implements SurfaceHolder.Callback {
    public Context mContext;
    private float mTextSize = 80.0f;
    private String mTextColor = "#000000";
    private boolean mIsRepeat;
    private int mStartPoint;
    private int mDirection = 1;
    private int mSpeed;
    private SurfaceHolder holder;
    private TextPaint mTextPaint;
    private ScrollingTextViewThread mThread;
    private String margueeString;
    private int textWidth = 0;
    private int textHeight = 0;
    private int ShadowColor = -16777216;
    public int currentX = 0;
    public int sepX = 10;
    private int interval = 0;
    private int alpha = 0;
    public static final int ROLL_OVER = 100;
    WeakHandler mHandler = new WeakHandler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (msg.what == 100) {
                ScrollingTextView.this.stopScroll();
                if (ScrollingTextView.this.mOnMargueeListener != null) {
                    ScrollingTextView.this.mOnMargueeListener.onRollOver();
                }
            }
            return false;
        }
    });
    OnMargueeListener mOnMargueeListener;

    public ScrollingTextView(Context context) {
        this(context, null);
    }

    public ScrollingTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScrollingTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ScrollingTextView, defStyleAttr, 0);
        this.mTextColor = a.getString(R.styleable.ScrollingTextView_textcolor);
        this.mTextSize = a.getDimension(R.styleable.ScrollingTextView_textSize, 48.0f);
        this.mIsRepeat = a.getBoolean(R.styleable.ScrollingTextView_isRepeat, true);
        this.mStartPoint = a.getInt(R.styleable.ScrollingTextView_startPoint, 0);
        this.mDirection = a.getInt(R.styleable.ScrollingTextView_direction, 1);
        this.mSpeed = a.getInt(R.styleable.ScrollingTextView_speed, 130);
        a.recycle();
        this.holder = this.getHolder();
        this.holder.addCallback((SurfaceHolder.Callback)this);
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setFlags(1);
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
        this.setZOrderOnTop(true);
        this.getHolder().setFormat(-3);
    }

    public void setText(String msg) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            this.measurementsText(msg);
        }
    }

    public void setScrollingInfo(ResponseScrollingInfo scrollingInfo) {
        if (scrollingInfo == null || TextUtils.isEmpty((CharSequence)scrollingInfo.getText())) {
            this.setVisibility(8);
        } else {
            if (scrollingInfo.getStatus() == 0) {
                this.setVisibility(8);
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)scrollingInfo.getColor())) {
                this.setTextColor(scrollingInfo.getColor());
            }
            if (scrollingInfo.getSize() > 0) {
                this.setTextSize(DensityUtils.dpToPx(scrollingInfo.getSize()));
            }
            switch (scrollingInfo.getSpeed()) {
                case 3000: {
                    this.sepX = 18;
                    this.setSpeed(20);
                    break;
                }
                case 6000: {
                    this.sepX = 6;
                    this.setSpeed(100);
                    break;
                }
                case 10000: {
                    this.sepX = 2;
                    this.setSpeed(700);
                    break;
                }
            }
            this.interval = scrollingInfo.getInterval();
            int mAlpha = scrollingInfo.getAlpha() > 100 ? 100 : (scrollingInfo.getAlpha() <= 0 ? 0 : scrollingInfo.getAlpha());
            this.alpha = (int)(2.55 * (double)mAlpha);
            if (scrollingInfo.getText_type() == 2) {
                this.setText(scrollingInfo.getText() + " - " + VssSdk.getInstance().getUserId() + " - " + VssSdk.getInstance().getNickName());
            } else {
                this.setText(scrollingInfo.getText());
            }
            if (scrollingInfo.getScrolling_open() != 0) {
                this.startScroll();
            }
        }
    }

    public void setTextSize(float mTextSize) {
        this.mTextSize = mTextSize;
    }

    public void setTextColor(String mTextColor) {
        this.mTextColor = mTextColor;
    }

    public void setSpeed(int mSpeed) {
        this.mSpeed = mSpeed;
    }

    protected void measurementsText(String msg) {
        this.margueeString = msg;
        this.mTextPaint.setTextSize(this.mTextSize);
        this.mTextPaint.setColor(Color.parseColor((String)this.mTextColor));
        this.mTextPaint.setStrokeWidth(0.1f);
        this.textWidth = (int)this.mTextPaint.measureText(this.margueeString);
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        this.textHeight = (int)fontMetrics.bottom;
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        int width = wm.getDefaultDisplay().getWidth();
        this.currentX = this.mStartPoint == 0 ? 0 : width - this.getPaddingLeft() - this.getPaddingRight();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.holder = holder;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mThread != null) {
            this.mThread.isRun = true;
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mThread != null) {
            this.mThread.isRun = false;
        }
    }

    public void startScroll() {
        if (this.mThread != null && this.mThread.isRun) {
            return;
        }
        this.mThread = new ScrollingTextViewThread(this.holder);
        this.mThread.start();
    }

    public void stopScroll() {
        if (this.mThread != null) {
            this.mThread.isRun = false;
            this.mThread.interrupt();
        }
        this.mThread = null;
    }

    public void reset() {
        int contentWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        this.currentX = this.mStartPoint == 0 ? 0 : contentWidth;
    }

    public void setOnMargueeListener(OnMargueeListener mOnMargueeListener) {
        this.mOnMargueeListener = mOnMargueeListener;
    }

    public static interface OnMargueeListener {
        public void onRollOver();
    }

    class ScrollingTextViewThread
    extends Thread {
        private SurfaceHolder holder;
        public boolean isRun;

        public ScrollingTextViewThread(SurfaceHolder holder) {
            this.holder = holder;
            this.isRun = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDraw() {
            try {
                SurfaceHolder surfaceHolder = this.holder;
                synchronized (surfaceHolder) {
                    if (TextUtils.isEmpty((CharSequence)ScrollingTextView.this.margueeString)) {
                        Thread.sleep(500L);
                        return;
                    }
                    Canvas canvas = this.holder.lockCanvas();
                    int paddingLeft = ScrollingTextView.this.getPaddingLeft();
                    int paddingTop = ScrollingTextView.this.getPaddingTop();
                    int paddingRight = ScrollingTextView.this.getPaddingRight();
                    int paddingBottom = ScrollingTextView.this.getPaddingBottom();
                    int contentWidth = ScrollingTextView.this.getWidth() - paddingLeft - paddingRight;
                    int contentHeight = ScrollingTextView.this.getHeight() - paddingTop - paddingBottom;
                    int centeYLine = paddingTop + contentHeight / 2;
                    if (ScrollingTextView.this.mDirection == 0) {
                        if (ScrollingTextView.this.currentX <= -ScrollingTextView.this.textWidth) {
                            if (!ScrollingTextView.this.mIsRepeat) {
                                ScrollingTextView.this.mHandler.sendEmptyMessage(100);
                            }
                            Thread.sleep(ScrollingTextView.this.interval * 1000);
                            ScrollingTextView.this.currentX = contentWidth;
                        } else {
                            ScrollingTextView.this.currentX -= ScrollingTextView.this.sepX;
                        }
                    } else if (ScrollingTextView.this.currentX >= contentWidth) {
                        if (!ScrollingTextView.this.mIsRepeat) {
                            ScrollingTextView.this.mHandler.sendEmptyMessage(100);
                        }
                        Thread.sleep(ScrollingTextView.this.interval * 1000);
                        ScrollingTextView.this.currentX = -ScrollingTextView.this.textWidth;
                    } else {
                        ScrollingTextView.this.currentX += ScrollingTextView.this.sepX;
                    }
                    if (canvas != null) {
                        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                        ScrollingTextView.this.mTextPaint.setAlpha(ScrollingTextView.this.alpha);
                        canvas.drawText(ScrollingTextView.this.margueeString, (float)ScrollingTextView.this.currentX, (float)(centeYLine + DensityUtils.dpToPxInt(ScrollingTextView.this.getContext(), ScrollingTextView.this.textHeight) / 2), (Paint)ScrollingTextView.this.mTextPaint);
                        this.holder.unlockCanvasAndPost(canvas);
                    }
                    int a = ScrollingTextView.this.textWidth / ScrollingTextView.this.margueeString.trim().length();
                    int b = a / ScrollingTextView.this.sepX;
                    int c = ScrollingTextView.this.mSpeed / b == 0 ? 1 : ScrollingTextView.this.mSpeed / b;
                    Thread.sleep(c);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            while (this.isRun) {
                this.onDraw();
            }
        }
    }
}

