/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.IBaseViewImpl;

public class RtcMenuWidget
extends IBaseViewImpl
implements View.OnClickListener {
    private TextView menu;
    private ImageView icon;
    private MenuInfo info;
    private String service;
    private OnMenuClick menuClick = new OnMenuClick(){

        @Override
        public void onServiceClick(MenuInfo info) {
        }
    };

    public RtcMenuWidget(@NonNull Context context) {
        super(context);
    }

    public RtcMenuWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public RtcMenuWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void init() {
        super.init();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.common_rtc_menu_layout, (ViewGroup)this);
        this.menu = (TextView)this.findViewById(R.id.menu);
        this.icon = (ImageView)this.findViewById(R.id.icon);
        this.setOnClickListener(this);
    }

    public void setData(MenuInfo info) {
        this.menu.setText(info.strId);
        this.service = info.service;
        this.info = info;
        this.icon.setImageResource(info.drawableId);
    }

    public void onClick(View v) {
        this.menuClick.onServiceClick(this.info);
    }

    public void setMenuClick(OnMenuClick menuClick) {
        this.menuClick = menuClick;
    }

    public String getService() {
        return this.service;
    }

    public static class MenuInfo
    implements IMenuInfo {
        public int strId;
        public String service;
        public int drawableId;
        public OnMenuClick onMenuClick;
        public int priority;
        public Context context;

        @Override
        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public MenuInfo() {
        }

        public MenuInfo(int strId, String service, int drawableId, int priority, OnMenuClick onMenuClick) {
            this.strId = strId;
            this.service = service;
            this.drawableId = drawableId;
            this.onMenuClick = onMenuClick;
            this.priority = priority;
        }

        public MenuInfo(int strId, String service, int drawableId) {
            this.strId = strId;
            this.service = service;
            this.drawableId = drawableId;
        }
    }

    public static interface IMenuInfo {
        default public int getPriority() {
            return 0;
        }
    }

    public static interface OnMenuClick {
        public void onServiceClick(MenuInfo var1);
    }
}

