/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.vss.data.ResponseScrollingInfo;
import com.vhall.appui.baselib.widget.ScrollingTextView;
import java.util.Random;

public class MarqueeView
extends FrameLayout {
    private Context mContext;
    private ScrollingTextView scrollingTextView;

    public MarqueeView(Context context) {
        this(context, null);
    }

    public MarqueeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MarqueeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.setClickable(false);
    }

    public void setScrollingInfo(ResponseScrollingInfo scrollingInfo) {
        if (scrollingInfo != null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, (int)((double)scrollingInfo.getSize() * 3.5));
            this.scrollingTextView = new ScrollingTextView(this.mContext);
            switch (scrollingInfo.getPosition()) {
                case 1: {
                    int min = 100;
                    int max = DensityUtils.getScreenHeight(this.mContext) - (int)((double)scrollingInfo.getSize() * 3.5);
                    Random random = new Random();
                    int num = random.nextInt(max) % (max - min + 1) + min;
                    layoutParams.setMargins(10, num, 10, 10);
                    break;
                }
                case 2: {
                    layoutParams.gravity = 48;
                    break;
                }
                case 3: {
                    layoutParams.gravity = 16;
                    break;
                }
                case 4: {
                    layoutParams.gravity = 80;
                    break;
                }
            }
            this.scrollingTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.removeAllViews();
            this.addView((View)this.scrollingTextView);
            this.scrollingTextView.setScrollingInfo(scrollingInfo);
        }
    }

    public void stopScroll() {
        if (this.scrollingTextView != null) {
            this.scrollingTextView.stopScroll();
        }
    }

    public void startScroll() {
        if (this.scrollingTextView != null) {
            this.scrollingTextView.startScroll();
        }
    }
}

