/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.IDevice;
import com.vhall.appui.baselib.network.bean.InteractiveListResponseBean;
import com.vhall.appui.baselib.widget.CellStreamWidget;
import com.vhall.appui.baselib.widget.IInteractivePage;
import com.vhall.vhallrtc.client.Stream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InteractivePageWidget
extends IInteractivePage {
    private ViewGroup top_left;
    private ViewGroup top_right;
    private ViewGroup bottom_left;
    private ViewGroup bottom_right;
    private List<ViewGroup> containers;
    private List<CellStreamWidget> childCells = new ArrayList<CellStreamWidget>();

    public InteractivePageWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    public void init() {
        super.init();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.interactive_page_widget_layout, (ViewGroup)this);
        this.top_left = (ViewGroup)this.findViewById(R.id.top_left);
        this.top_right = (ViewGroup)this.findViewById(R.id.top_right);
        this.bottom_left = (ViewGroup)this.findViewById(R.id.bottom_left);
        this.bottom_right = (ViewGroup)this.findViewById(R.id.bottom_right);
        this.containers = new ArrayList<ViewGroup>();
        this.containers.add(this.top_left);
        this.containers.add(this.top_right);
        this.containers.add(this.bottom_left);
        this.containers.add(this.bottom_right);
    }

    @Override
    public void setData(List<Stream> streams) {
        this.childCells.clear();
        for (int i = 0; i < streams.size(); ++i) {
            Stream stream = streams.get(i);
            CellStreamWidget cellStreamWidget = new CellStreamWidget(this.getContext());
            cellStreamWidget.setData(stream);
            this.childCells.add(cellStreamWidget);
            this.containers.get(i).addView((View)cellStreamWidget);
        }
    }

    @Override
    public void refreshUserInfo(Map<String, InteractiveListResponseBean> interactiveListResponseBeanMap) {
        for (CellStreamWidget widget : this.childCells) {
            if (!interactiveListResponseBeanMap.containsKey(widget.getUserId())) continue;
            widget.refreshCell(interactiveListResponseBeanMap.get(widget.getUserId()));
        }
    }

    @Override
    public void refreshPageCells(IDevice.Device device, boolean open, String userId) {
        for (CellStreamWidget widget : this.childCells) {
            widget.setDeviceStatus(device, open, userId);
        }
    }

    @Override
    public void release() {
        for (int i = this.childCells.size() - 1; i >= 0; --i) {
            this.childCells.get(i).release();
        }
    }
}

