/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.alibaba.fastjson.JSON;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.IBaseViewImpl;
import com.vhall.appui.baselib.base.IDevice;
import com.vhall.appui.baselib.bean.AttributesBean;
import com.vhall.appui.baselib.bean.User;
import com.vhall.appui.baselib.net.ApiCallBack;
import com.vhall.appui.baselib.net.bean.IBaseRequestBean;
import com.vhall.appui.baselib.network.CommonManagerNetWrapper;
import com.vhall.appui.baselib.network.bean.InteractiveListResponseBean;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.module.room.ProxyVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import com.vhall.appui.baselib.widget.IInteractivePage;
import com.vhall.appui.baselib.widget.InteractivePageWidget;
import com.vhall.appui.baselib.widget.ShareDesktopWidget;
import com.vhall.vhallrtc.client.Stream;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class InteractiveCellPageContainers
extends IBaseViewImpl
implements RadioGroup.OnCheckedChangeListener,
ViewPager.OnPageChangeListener {
    private RadioGroup page_indicator;
    private FrameLayout interactive_container;
    private ViewPager viewPager;
    private RadioButton indicator1;
    private RadioButton indicator2;
    private RadioButton indicator3;
    private List<RadioButton> pageIndicators;
    private Map<String, InteractiveListResponseBean> mInteractiveListResponseBeanMap = new HashMap<String, InteractiveListResponseBean>();
    private ProxyVssMessageListener listener;
    private List<IInteractivePage> pages = new ArrayList<IInteractivePage>();
    Map<String, Stream> mStreams;
    MyAdapter adapter;
    private ShareDesktopWidget shareDesktopWidget;
    private Disposable disposable;

    public InteractiveCellPageContainers(@androidx.annotation.NonNull Context context) {
        super(context);
    }

    public InteractiveCellPageContainers(@androidx.annotation.NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public InteractiveCellPageContainers(@androidx.annotation.NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void init() {
        super.init();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.interactive_cell_page_containers_layout, (ViewGroup)this);
        this.initView();
        this.interactive_container.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, DensityUtils.getScreenWidth()));
        this.page_indicator = (RadioGroup)this.findViewById(R.id.page_indicator);
        this.page_indicator.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        this.listener = new ProxyVssMessageListener(new RoomListenerInternalImpl());
        this.listener.setFilterOtherMsg(false);
        VssRoomManager.getInstance().setVssMessageListener(this.listener);
    }

    private void initView() {
        this.interactive_container = (FrameLayout)this.findViewById(R.id.interactive_container);
        this.pageIndicators = new ArrayList<RadioButton>();
        this.indicator1 = (RadioButton)this.findViewById(R.id.page1);
        this.indicator2 = (RadioButton)this.findViewById(R.id.page2);
        this.indicator3 = (RadioButton)this.findViewById(R.id.page3);
        this.pageIndicators.add(this.indicator1);
        this.pageIndicators.add(this.indicator2);
        this.pageIndicators.add(this.indicator3);
    }

    public void onPageScrolled(int i, float v, int i1) {
    }

    public void onPageSelected(int i) {
        this.pageIndicators.get(i).setChecked(true);
    }

    public void onPageScrollStateChanged(int i) {
    }

    public void setData(Map<String, Stream> streams, ResponseRoomInfo responseRoomInfo) {
        this.releaseRenderView();
        this.mStreams = streams;
        List<Stream> allStreams = this.processStreams(streams);
        Stream shareStreams = null;
        for (Stream stream : allStreams) {
            if (stream.getStreamType() != 3) continue;
            shareStreams = stream;
            break;
        }
        if (shareStreams != null) {
            this.shareDesktopWidget = new ShareDesktopWidget(this.getContext());
            this.shareDesktopWidget.setData(shareStreams);
            allStreams.remove(shareStreams);
        }
        List<List<Stream>> lists = InternalUtils.splitList(allStreams, 4);
        for (List<Stream> list : lists) {
            InteractivePageWidget interactivePageWidget = new InteractivePageWidget(this.getContext());
            interactivePageWidget.setData(list);
            this.pages.add(interactivePageWidget);
        }
        if (shareStreams != null) {
            this.pages.add(0, this.shareDesktopWidget);
        }
        this.showIndicator(this.pages.size());
        this.interactive_container.removeAllViews();
        this.adapter = new MyAdapter();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        this.viewPager = new ViewPager(this.getContext());
        this.viewPager.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.interactive_container.addView((View)this.viewPager);
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.refreshPageUserInfo();
    }

    private void releaseRenderView() {
        if (this.pages.size() > 0) {
            for (IInteractivePage iInteractivePage : this.pages) {
                iInteractivePage.release();
            }
        }
        this.pages.clear();
    }

    public void showIndicator(int size) {
        for (RadioButton button : this.pageIndicators) {
            button.setVisibility(8);
        }
        if (size > 1) {
            size = Math.min(3, size);
            for (int i = 0; i < size; ++i) {
                this.pageIndicators.get(i).setVisibility(0);
            }
        }
    }

    private List<Stream> processStreams(Map<String, Stream> streams) {
        ArrayList<Stream> allStreams = new ArrayList<Stream>(streams.values());
        ArrayList<Stream> resultStreams = new ArrayList<Stream>();
        String mainScreenId = VssRoomManager.getInstance().getMainScreenId();
        for (Stream stream : allStreams) {
            try {
                String attributes = stream.getAttributes();
                AttributesBean attributesBean = (AttributesBean)JSON.parseObject((String)attributes, AttributesBean.class);
                if (attributesBean == null) {
                    attributesBean = new AttributesBean();
                }
                String video = "1";
                String audio = "1";
                if (stream.remoteMuteStream == null) {
                    attributesBean.setAccount_id(User.getFromLocal((Context)this.getContext()).account_id);
                    attributesBean.setNick_name(User.getFromLocal((Context)this.getContext()).nick_name);
                    if (stream.muteStream != null) {
                        video = !stream.muteStream.optBoolean("video") ? "1" : "0";
                        audio = !stream.muteStream.optBoolean("audio") ? "1" : "0";
                    }
                } else {
                    JSONObject muteStream;
                    if (TextUtils.isEmpty((CharSequence)attributesBean.getAccount_id())) {
                        attributesBean.setAccount_id(stream.userId);
                    }
                    video = !(muteStream = stream.remoteMuteStream).optBoolean("video") ? "1" : "0";
                    audio = !muteStream.optBoolean("audio") ? "1" : "0";
                }
                boolean isMainScreen = false;
                if (TextUtils.equals((CharSequence)attributesBean.getAccount_id(), (CharSequence)VssRoomManager.getInstance().getMainScreenId())) {
                    isMainScreen = true;
                }
                this.mInteractiveListResponseBeanMap.put(attributesBean.getAccount_id(), new InteractiveListResponseBean(attributesBean.getAccount_id() + "", attributesBean.getNick_name() + "", attributesBean.getRole_name() + "", video + "", audio + "", isMainScreen));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (TextUtils.equals((CharSequence)stream.userId, (CharSequence)mainScreenId)) {
                resultStreams.add(0, stream);
                continue;
            }
            resultStreams.add(stream);
        }
        return resultStreams;
    }

    private void pullInteractiveInfo() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
        Observable.just((Object)"pullData").delay(2L, TimeUnit.SECONDS);
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<List<InteractiveListResponseBean>>(){

            public void subscribe(final @NonNull ObservableEmitter<List<InteractiveListResponseBean>> emitter) throws Exception {
                CommonManagerNetWrapper.getInteractiveUserList(new IBaseRequestBean(), new CallBack<ArrayList<InteractiveListResponseBean>>(){

                    @Override
                    public void onSuccess(ArrayList<InteractiveListResponseBean> result) {
                        emitter.onNext(result);
                        emitter.onComplete();
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        emitter.onError((Throwable)new Exception(msg));
                    }
                });
            }
        }).subscribe((Observer)new ApiCallBack<List<InteractiveListResponseBean>>(){

            @Override
            public void onSubscribe(Disposable disposable) {
                super.onSubscribe(disposable);
                InteractiveCellPageContainers.this.disposable = disposable;
                InteractiveCellPageContainers.this.addSubscribe(disposable);
            }

            @Override
            public void onNext(List<InteractiveListResponseBean> interactiveListResponseBeans) {
                super.onNext(interactiveListResponseBeans);
                if (InternalUtils.isNotEmpty(interactiveListResponseBeans)) {
                    InteractiveCellPageContainers.this.mInteractiveListResponseBeanMap.clear();
                    for (InteractiveListResponseBean bean : interactiveListResponseBeans) {
                        InteractiveCellPageContainers.this.mInteractiveListResponseBeanMap.put(bean.getAccount_id(), bean);
                    }
                    InteractiveCellPageContainers.this.refreshPageUserInfo();
                }
            }
        });
    }

    private void refreshPageUserInfo() {
        for (IInteractivePage pageWidget : this.pages) {
            pageWidget.refreshUserInfo(this.mInteractiveListResponseBeanMap);
        }
    }

    public void onCheckedChanged(RadioGroup group, int checkedId) {
        if (checkedId == R.id.page1) {
            this.viewPager.setCurrentItem(0);
        } else if (checkedId == R.id.page2) {
            this.viewPager.setCurrentItem(1);
        } else if (checkedId == R.id.page3) {
            this.viewPager.setCurrentItem(2);
        }
    }

    public void destroy() {
        this.releaseRenderView();
        this.interactive_container.removeAllViews();
        this.showIndicator(0);
    }

    private void scheduleDeviceStatus(MessageData msg, IDevice.Device device, boolean open) {
        JSONObject jsonObject = (JSONObject)msg.getT();
        if (jsonObject != null) {
            String userId = jsonObject.optString("user_id");
            for (IInteractivePage pageWidget : this.pages) {
                pageWidget.refreshPageCells(device, open, userId);
            }
        }
    }

    private class RoomListenerInternalImpl
    implements IVssMessageListener {
        private RoomListenerInternalImpl() {
        }

        @Override
        public void onMessage(MessageData msg) {
            switch (msg.getType()) {
                case "vrtc_mute": {
                    InteractiveCellPageContainers.this.scheduleDeviceStatus(msg, IDevice.Device.Audio, false);
                    break;
                }
                case "vrtc_mute_cancel": {
                    InteractiveCellPageContainers.this.scheduleDeviceStatus(msg, IDevice.Device.Audio, true);
                    break;
                }
                case "vrtc_frames_forbid": {
                    InteractiveCellPageContainers.this.scheduleDeviceStatus(msg, IDevice.Device.Video, false);
                    break;
                }
                case "vrtc_frames_display": {
                    InteractiveCellPageContainers.this.scheduleDeviceStatus(msg, IDevice.Device.Video, true);
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
        }
    }

    class MyAdapter
    extends PagerAdapter {
        MyAdapter() {
        }

        public int getCount() {
            return InteractiveCellPageContainers.this.pages.size();
        }

        public int getItemPosition(@androidx.annotation.NonNull Object object) {
            return -2;
        }

        public boolean isViewFromObject(@androidx.annotation.NonNull View view, @androidx.annotation.NonNull Object o) {
            return view == o;
        }

        @androidx.annotation.NonNull
        public Object instantiateItem(@androidx.annotation.NonNull ViewGroup container, int position) {
            container.addView((View)InteractiveCellPageContainers.this.pages.get(position));
            return InteractiveCellPageContainers.this.pages.get(position);
        }

        public void destroyItem(@androidx.annotation.NonNull ViewGroup container, int position, @androidx.annotation.NonNull Object object) {
            container.removeView((View)InteractiveCellPageContainers.this.pages.get(position));
        }
    }
}

