/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;

public class HeightProvider
extends PopupWindow
implements ViewTreeObserver.OnGlobalLayoutListener {
    private Activity mActivity;
    private View rootView;
    private HeightListener listener;
    private int heightMax;
    private ViewTreeObserver observer;

    public HeightProvider(Activity activity) {
        super((Context)activity);
        this.mActivity = activity;
        this.rootView = new View((Context)activity);
        this.setContentView(this.rootView);
        this.observer = this.rootView.getViewTreeObserver();
        this.observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setWidth(0);
        this.setHeight(-1);
        this.setSoftInputMode(16);
        this.setInputMethodMode(1);
    }

    public HeightProvider init() {
        if (!this.isShowing()) {
            final View view = this.mActivity.getWindow().getDecorView();
            view.post(new Runnable(){

                @Override
                public void run() {
                    HeightProvider.this.showAtLocation(view, 0, 0, 0);
                }
            });
        }
        return this;
    }

    public HeightProvider setHeightListener(HeightListener listener) {
        this.listener = listener;
        return this;
    }

    public void onGlobalLayout() {
        Rect rect = new Rect();
        this.rootView.getWindowVisibleDisplayFrame(rect);
        if (rect.bottom > this.heightMax) {
            this.heightMax = rect.bottom;
        }
        int keyboardHeight = this.heightMax - rect.bottom;
        if (this.listener != null) {
            this.listener.onHeightChanged(keyboardHeight);
        }
    }

    public void destroyed() {
        this.dismiss();
        if (this.observer != null && this.observer.isAlive()) {
            this.observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    public static interface HeightListener {
        public void onHeightChanged(int var1);
    }
}

