/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.text.style.ReplacementSpan;

public class CircleSpan
extends ReplacementSpan {
    public static final float DEFAULT_PADDING = 8.0f;
    public static final int DEFAULT_COLOR = 0;
    private final float padding;
    private final int circleColor;
    private final int textColor;

    public CircleSpan() {
        this(8.0f, 0, 0);
    }

    public CircleSpan(float padding) {
        this(padding, 0, 0);
    }

    public CircleSpan(int circleColor) {
        this(8.0f, circleColor, 0);
    }

    public CircleSpan(int circleColor, int textColor) {
        this(8.0f, circleColor, textColor);
    }

    public CircleSpan(float padding, int circleColor, int textColor) {
        this.padding = padding;
        this.circleColor = circleColor;
        this.textColor = textColor;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        return Math.round(paint.measureText(text, start, end) + this.padding * 2.0f);
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        float textSize = paint.measureText(text, start, end);
        int oldColor = paint.getColor();
        if (this.circleColor != 0) {
            paint.setColor(this.circleColor);
        }
        canvas.drawCircle(x + textSize / 2.0f + this.padding, (float)((top + bottom) / 2), (text.length() == 1 ? textSize : textSize / 2.0f) + this.padding, paint);
        if (this.textColor != 0) {
            paint.setColor(this.textColor);
        } else {
            paint.setColor(oldColor);
        }
        canvas.drawText(text, start, end, this.padding + x, (float)y, paint);
        paint.setColor(oldColor);
    }
}

