/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.utils.KeyboardManager;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;

public class ChatView
extends FrameLayout
implements View.OnClickListener,
TextView.OnEditorActionListener {
    private Context context;
    private EditText etChat;
    private View rootView;
    private boolean chatAble = true;
    private String hintContent = "";
    private int keyboardHeight = 0;
    private boolean hasVirtual = false;
    private int virtualHeight = 0;
    private KeyboardManager.KeyboardListener keyboardListener = new KeyboardManager.KeyboardListener(){

        @Override
        public void onKeyboardChange(final boolean isShow, final int height) {
            ChatView.this.post(new Runnable(){

                @Override
                public void run() {
                    if (isShow) {
                        ChatView.this.setVisibility(0);
                        ViewGroup.LayoutParams params = ChatView.this.rootView.getLayoutParams();
                        ViewGroup.MarginLayoutParams marginParams = params instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)params : new ViewGroup.MarginLayoutParams(params);
                        if (ChatView.this.keyboardHeight == 0) {
                            ChatView.this.keyboardHeight = height;
                            marginParams.setMargins(0, 0, 0, ChatView.this.keyboardHeight);
                            ChatView.this.rootView.setLayoutParams((ViewGroup.LayoutParams)marginParams);
                        }
                    } else {
                        ChatView.this.keyboardHeight = 0;
                        ChatView.this.setVisibility(8);
                    }
                }
            });
        }
    };

    public ChatView(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public ChatView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public ChatView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        this.context = context;
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.w_chat_view, (ViewGroup)this);
        this.hasVirtual = KeyboardManager.hasVirtualButton(context);
        this.etChat = (EditText)this.rootView.findViewById(R.id.et_chat);
        this.rootView.findViewById(R.id.tv_send).setOnClickListener((View.OnClickListener)this);
        this.etChat.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        KeyboardManager.create((Activity)context).setKeyboardListener(this.keyboardListener);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 4 || actionId == 0) {
            this.processSendMsg();
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tv_send) {
            this.processSendMsg();
        }
    }

    private void processSendMsg() {
        if (this.chatAble) {
            if (TextUtils.isEmpty((CharSequence)this.etChat.getText().toString().trim())) {
                Toast.makeText((Context)this.context, (int)R.string.input_content_to_send, (int)0).show();
            } else {
                this.sendMsg(this.etChat.getText().toString().trim());
            }
        } else {
            if (TextUtils.isEmpty((CharSequence)this.hintContent)) {
                this.hintContent = this.context.getString(R.string.disable_chat);
            } else if (this.hintContent.equals(this.context.getString(R.string.disable_chat_all))) {
                this.hintContent = this.context.getString(R.string.disable_chat_all1);
            }
            Toast.makeText((Context)this.context, (CharSequence)this.hintContent, (int)0).show();
        }
        this.etChat.setText((CharSequence)"");
        this.hintKeyboard();
    }

    private void sendMsg(String msg) {
        if (!VssRoomManager.enter) {
            Toast.makeText((Context)this.context, (int)R.string.base_please_init_room_info, (int)0).show();
            return;
        }
        VssRoomManager.getInstance().sendMsg(msg, "", new CallBack(){

            public void onSuccess(Object result) {
            }

            @Override
            public void onError(int eventCode, String msg) {
                Toast.makeText((Context)ChatView.this.context, (CharSequence)msg, (int)0).show();
            }
        });
    }

    public void showKeyboard() {
        KeyboardManager.showKeyboard(this.etChat, (Activity)this.context);
        ViewGroup.LayoutParams params = this.rootView.getLayoutParams();
        ViewGroup.MarginLayoutParams marginParams = params instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)params : new ViewGroup.MarginLayoutParams(params);
        marginParams.setMargins(0, 0, 0, this.keyboardHeight);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)marginParams);
    }

    public void hintKeyboard() {
        KeyboardManager.hintKeyboard((View)this.etChat, (Context)((Activity)this.context));
        this.setVisibility(8);
        ViewGroup.LayoutParams params = this.rootView.getLayoutParams();
        ViewGroup.MarginLayoutParams marginParams = params instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)params : new ViewGroup.MarginLayoutParams(params);
        marginParams.setMargins(0, 0, 0, 0);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)marginParams);
    }

    public void setChatAble(boolean chatAble, String hintContent) {
        this.chatAble = chatAble;
        this.hintContent = hintContent;
        if (!TextUtils.isEmpty((CharSequence)hintContent)) {
            this.etChat.setHint((CharSequence)hintContent);
        } else {
            this.etChat.setHint((CharSequence)this.context.getString(R.string.input_content_to_send));
        }
    }
}

