/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import com.alibaba.fastjson.JSON;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.IBaseViewImpl;
import com.vhall.appui.baselib.config.VhallComponentConfig;
import com.vhall.appui.baselib.service.chat.IChatBottomControl;
import com.vhall.appui.baselib.service.chat.IInputListener;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.utils.KeyboardManager;
import com.vhall.appui.baselib.utils.ListUtils;
import com.vhall.appui.baselib.utils.ToastUtil;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.EnumRoleName;
import com.vhall.appui.baselib.vss.data.ResponseChatInfo;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.module.chat.IAuditMessage;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.service.IMessage;
import com.vhall.appui.baselib.widget.HeightProvider;
import com.vhall.appui.baselib.widget.emoji.KeyBoardManager;
import com.vhall.framework.VhallSDK;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatBottomControlView
extends IBaseViewImpl
implements View.OnClickListener,
TextView.OnEditorActionListener,
IChatBottomControl {
    private Context context;
    private EditText etChat;
    private ImageView tv_send;
    private View rootView;
    private boolean chatAble = true;
    private String hintContent = "";
    private int showType = 0;
    private String qaIsShow = "0";
    private int qaMaxCount = 500;
    private int keyboardHeight;
    private int historyKeyboardHeight = 900;
    private static final int REQUEST_CODE = 17;
    private static final int PERMISSION_WRITE_EXTERNAL_REQUEST_CODE = 17;
    private HeightProvider heightProvider;
    private IMessage message;
    private long lastClickTime = 0L;
    private IInputListener mInputListener = new IInputListener.SimpleInputListener();
    private SendMsgCallBack sendMsgCallBack;

    public ChatBottomControlView(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public ChatBottomControlView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public ChatBottomControlView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    public void setShowType(int showType) {
        this.showType = showType;
        if (showType == 1) {
            this.etChat.setHint((CharSequence)this.context.getString(R.string.qa_hint));
        } else {
            this.etChat.setHint((CharSequence)this.context.getString(R.string.chat_you_want_send_msg));
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 8) {
            this.findViewById(R.id.line1).setVisibility(8);
            KeyboardManager.hintKeyboard((View)this, this.getContext());
        }
    }

    public void setShowData(int showType, IMessage chatData) {
        this.message = chatData;
        this.showType = showType;
        if (showType == 2) {
            this.etChat.setHint((CharSequence)String.format("%s %s", this.context.getString(R.string.at), chatData.getNickname()));
        } else if (showType == 3) {
            this.etChat.setHint((CharSequence)String.format("%s %s", this.context.getString(R.string.reply), chatData.getNickname()));
        }
    }

    public void setQaIsShow(String qaIsShow) {
        this.qaIsShow = qaIsShow;
    }

    private void showErrrorToast() {
        long currentClickTime = System.currentTimeMillis();
        if (currentClickTime - this.lastClickTime > 2500L) {
            ToastUtil.showToast(this.context, "\u8d85\u8fc750\u5b57\u4e0d\u53ef\u53d1\u9001", this.rootView);
            this.lastClickTime = currentClickTime;
        }
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        this.context = context;
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.base_chat_view_layout, (ViewGroup)this);
        this.etChat = (EditText)this.rootView.findViewById(R.id.et_chat);
        this.tv_send = (ImageView)this.rootView.findViewById(R.id.chat_tv_send);
        this.tv_send.setOnClickListener((View.OnClickListener)this);
        this.rootView.findViewById(R.id.chat_bg).setOnClickListener((View.OnClickListener)this);
        this.etChat.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.etChat.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatBottomControlView.this.show(false);
            }
        });
        int hasWriteExternalPermission = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        if (hasWriteExternalPermission != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)17);
        }
        this.etChat.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (ChatBottomControlView.this.etChat.getText().toString().trim().length() > 0) {
                    ChatBottomControlView.this.tv_send.setImageResource(R.drawable.tv_chat_send);
                } else {
                    ChatBottomControlView.this.tv_send.setImageResource(R.drawable.un_tv_chat_send);
                }
                if (ChatBottomControlView.this.showType != 1) {
                    if (s.length() > 50) {
                        ChatBottomControlView.this.etChat.setText(s.subSequence(0, 50));
                        Selection.setSelection((Spannable)ChatBottomControlView.this.etChat.getText(), (int)50);
                        ChatBottomControlView.this.showErrrorToast();
                    }
                } else if (s.length() > 50) {
                    ChatBottomControlView.this.etChat.setText(s.subSequence(0, 50));
                    Selection.setSelection((Spannable)ChatBottomControlView.this.etChat.getText(), (int)50);
                    ChatBottomControlView.this.showErrrorToast();
                }
            }
        });
        if (context instanceof Activity) {
            this.heightProvider = new HeightProvider((Activity)context).init().setHeightListener(new HeightProvider.HeightListener(){

                @Override
                public void onHeightChanged(int height) {
                    ViewGroup.LayoutParams params = ChatBottomControlView.this.rootView.getLayoutParams();
                    ViewGroup.MarginLayoutParams marginParams = params instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)params : new ViewGroup.MarginLayoutParams(params);
                    Bundle bundle = new Bundle();
                    if (height > 100) {
                        ChatBottomControlView.this.historyKeyboardHeight = ChatBottomControlView.this.keyboardHeight;
                        ChatBottomControlView.this.keyboardHeight = height;
                        ChatBottomControlView.this.setVisibility(0);
                        ChatBottomControlView.this.etChat.setVisibility(0);
                        ChatBottomControlView.this.tv_send.setVisibility(0);
                        ChatBottomControlView.this.mInputListener.onKeyBordOpen("", new Bundle());
                    } else {
                        marginParams.height = -2;
                        ChatBottomControlView.this.setVisibility(8);
                        bundle.putString("content", ChatBottomControlView.this.etChat.getText().toString());
                        ChatBottomControlView.this.mInputListener.onKeyBordClose("", bundle);
                    }
                    marginParams.setMargins(0, 0, 0, height);
                    ChatBottomControlView.this.rootView.setLayoutParams((ViewGroup.LayoutParams)marginParams);
                }
            });
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 4 || actionId == 0) {
            this.processSendMsg();
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.chat_bg) {
            this.show(false);
            this.setVisibility(8);
        } else if (v.getId() == R.id.chat_tv_send) {
            if (this.etChat.getText().toString().equals("")) {
                return;
            }
            this.processSendMsg();
        }
    }

    public void show(boolean isShowEmoji) {
        this.etChat.requestFocus();
        this.showKeyboardView();
        this.findViewById(R.id.line1).setVisibility(8);
    }

    private void showKeyboardView() {
        final ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.rootView.getLayoutParams();
        if (this.keyboardHeight == 0) {
            KeyBoardManager.openKeyboard(this.etChat, this.context);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    params.setMargins(0, 0, 0, ChatBottomControlView.this.historyKeyboardHeight);
                    ChatBottomControlView.this.rootView.setLayoutParams((ViewGroup.LayoutParams)params);
                    ChatBottomControlView.this.rootView.setVisibility(0);
                }
            }, 30L);
            return;
        }
        params.setMargins(0, 0, 0, this.keyboardHeight);
        if (this.rootView.getVisibility() == 0) {
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.findViewById(R.id.line1).setVisibility(8);
            this.rootView.setVisibility(0);
            KeyBoardManager.openKeyboard(this.etChat, this.context);
            KeyBoardManager.openKeyboard(this.etChat, this.context);
        } else {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    ChatBottomControlView.this.rootView.setLayoutParams((ViewGroup.LayoutParams)params);
                    ChatBottomControlView.this.findViewById(R.id.line1).setVisibility(8);
                    ChatBottomControlView.this.rootView.setVisibility(0);
                    KeyBoardManager.openKeyboard(ChatBottomControlView.this.etChat, ChatBottomControlView.this.context);
                }
            }, 30L);
        }
    }

    private void processSendMsg() {
        String trim = this.etChat.getText().toString().trim();
        if (this.showType == 1) {
            if (TextUtils.isEmpty((CharSequence)trim)) {
                VHToast.showShortToast(R.string.qa_an_input_empty);
            } else {
                this.sendQaAn(trim);
            }
        } else if (this.chatAble) {
            if (TextUtils.isEmpty((CharSequence)trim)) {
                VHToast.showShortToast(R.string.chat_please_input_your_send_content);
            } else {
                this.sendMsg(trim, null);
            }
        } else {
            if (TextUtils.isEmpty((CharSequence)this.hintContent)) {
                this.hintContent = this.context.getString(R.string.disable_chat);
            } else if (this.hintContent.equals(this.context.getString(R.string.disable_chat_all))) {
                this.hintContent = this.context.getString(R.string.disable_chat_all1);
            }
            VHToast.showShortToast(this.hintContent);
        }
        this.findViewById(R.id.line1).setVisibility(8);
        this.etChat.setText((CharSequence)"");
        this.etChat.postDelayed(new Runnable(){

            @Override
            public void run() {
                ChatBottomControlView.this.hintKeyboard();
            }
        }, 50L);
        this.rootView.setVisibility(8);
    }

    private void sendMsg(String msg, final List<String> image) {
        JSONObject jsonObject = new JSONObject();
        String canSpeak = (String)VhallComponentConfig.share().getVal("can_speak", "0");
        if (InternalUtils.convertBoolean(canSpeak) && !EnumRoleName.isHost(InternalUtils.strToInt(VssRoomManager.getInstance().getRoomInfo().getRole_name()))) {
            VHToast.showShortToast(R.string.disable_chat);
            return;
        }
        try {
            JSONObject context = new JSONObject(VhallSDK.getInstance().getmUserInfo());
            if (context.has("atList")) {
                context.remove("atList");
            }
            if (context.has("replyMsg")) {
                context.remove("replyMsg");
            }
            if (this.showType == 2) {
                JSONArray array = new JSONArray();
                JSONObject at = new JSONObject();
                at.put("accountId", (Object)this.message.getUserId());
                at.put("nickName", (Object)this.message.getNickname());
                at.put("index", 0);
                array.put((Object)at);
                context.put("atList", (Object)array);
                msg = String.format("***%s %s", this.message.getNickname(), msg);
            } else if (this.showType == 3) {
                JSONObject reply = new JSONObject();
                if (ListUtils.isEmpty(this.message.getImage_urls())) {
                    reply.put("type", (Object)"text");
                } else {
                    reply.put("type", (Object)"image");
                }
                reply.put("avatar", (Object)this.message.getAvatar());
                reply.put("sendId", (Object)this.message.getUserId());
                reply.put("nickName", (Object)this.message.getNickname());
                reply.put("roleName", (Object)this.message.getRoleName());
                reply.put("client", (Object)"android");
                reply.put("isHistoryMsg", false);
                JSONObject content = new JSONObject();
                if (ListUtils.isEmpty(this.message.getImage_urls())) {
                    content.put("type", (Object)"text");
                } else {
                    content.put("type", (Object)"image");
                }
                content.put("avatar", (Object)this.message.getAvatar());
                content.put("nick_name", (Object)this.message.getNickname());
                JSONObject textContent = new JSONObject();
                textContent.put("msgType", (Object)"text");
                textContent.put("msgCont", (Object)this.message.getText_content());
                JSONArray text_content = new JSONArray();
                text_content.put((Object)textContent);
                content.put("text_content", (Object)text_content);
                if (!ListUtils.isEmpty(this.message.getImage_urls())) {
                    JSONArray image_urls = new JSONArray();
                    for (int i = 0; i < this.message.getImage_urls().size(); ++i) {
                        String url = this.message.getImage_urls().get(i);
                        image_urls.put((Object)url);
                    }
                    content.put("image_urls", (Object)image_urls);
                }
                reply.put("content", (Object)content);
                context.put("replyMsg", (Object)reply);
            }
            Field useInfoF = VhallSDK.class.getDeclaredField("mUserInfo");
            useInfoF.setAccessible(true);
            useInfoF.set(VhallSDK.getInstance(), context.toString());
            jsonObject = context;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ListUtils.isEmpty(image)) {
            int role = 0;
            try {
                role = InternalUtils.strToInt(VssRoomManager.getInstance().getRoomInfo().getRole_name());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IAuditMessage.AuditMessageContextBuilder builder = new IAuditMessage.AuditMessageContextBuilder().setRoleName(role).setNickName(AccountManager.getInstance().getNickName());
            if (this.showType == 2) {
                try {
                    JSONArray array = new JSONArray();
                    JSONObject at = new JSONObject();
                    at.put("accountId", (Object)this.message.getUserId());
                    at.put("nickName", (Object)this.message.getNickname());
                    at.put("index", 0);
                    array.put((Object)at);
                    builder.setAtList(array);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else if (this.showType == 3) {
                try {
                    JSONObject reply = new JSONObject();
                    if (ListUtils.isEmpty(this.message.getImage_urls())) {
                        reply.put("type", (Object)"text");
                    } else {
                        reply.put("type", (Object)"image");
                    }
                    reply.put("avatar", (Object)this.message.getAvatar());
                    reply.put("sendId", (Object)this.message.getUserId());
                    reply.put("nickName", (Object)this.message.getNickname());
                    reply.put("roleName", (Object)this.message.getRoleName());
                    reply.put("client", (Object)"android");
                    reply.put("isHistoryMsg", false);
                    JSONObject content = new JSONObject();
                    if (ListUtils.isEmpty(this.message.getImage_urls())) {
                        content.put("type", (Object)"text");
                    } else {
                        content.put("type", (Object)"image");
                    }
                    content.put("avatar", (Object)this.message.getAvatar());
                    content.put("nick_name", (Object)this.message.getNickname());
                    JSONObject textContent = new JSONObject();
                    textContent.put("msgType", (Object)"text");
                    textContent.put("msgCont", (Object)this.message.getText_content());
                    JSONArray text_content = new JSONArray();
                    text_content.put((Object)textContent);
                    content.put("text_content", (Object)text_content);
                    if (!ListUtils.isEmpty(this.message.getImage_urls())) {
                        JSONArray image_urls = new JSONArray();
                        for (int i = 0; i < this.message.getImage_urls().size(); ++i) {
                            String url = this.message.getImage_urls().get(i);
                            image_urls.put((Object)url);
                        }
                        content.put("image_urls", (Object)image_urls);
                    }
                    reply.put("content", (Object)content);
                    builder.setReplayMsg(reply);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            IAuditMessage message = new IAuditMessage.AuditMessageBuilder().setAudit("0").setContext(builder.build().buildJsonContext().toString()).setMessageText(msg).build();
            final JSONObject finalJsonObject1 = jsonObject;
            final String finalMsg1 = msg;
            VssRoomManager.getInstance().sendMsg(msg, "", new CallBack(){

                public void onSuccess(Object result) {
                    ChatBottomControlView.this.rootView.setVisibility(8);
                    if (ChatBottomControlView.this.sendMsgCallBack != null) {
                        ChatBottomControlView.this.sendMsgCallBack.addChatMsg(ChatBottomControlView.this.getChatMessageData(finalJsonObject1, ListUtils.isEmpty(image) ? "text" : "image", finalMsg1, image));
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    VHToast.showShortToast(msg);
                }
            }, message);
        } else {
            final JSONObject finalJsonObject = jsonObject;
            final String finalMsg = msg;
            VssRoomManager.getInstance().sendImageMsg(msg, image, new CallBack(){

                public void onSuccess(Object result) {
                    ChatBottomControlView.this.rootView.setVisibility(8);
                    if (ChatBottomControlView.this.sendMsgCallBack != null) {
                        ChatBottomControlView.this.sendMsgCallBack.addChatMsg(ChatBottomControlView.this.getChatMessageData(finalJsonObject, ListUtils.isEmpty(image) ? "text" : "image", finalMsg, image));
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    VHToast.showShortToast(msg);
                }
            });
        }
    }

    private VssMessageChatData getChatMessageData(JSONObject objCon, String type, String text, List<String> urls) {
        VssMessageChatData chatData = new VssMessageChatData();
        ArrayList<ResponseChatInfo.ContextBean.AtListBean> atList = new ArrayList();
        if (objCon != null) {
            chatData.setAvatar(objCon.optString("avatar"));
            chatData.setRoom_id(objCon.optString("room_id"));
            chatData.setRoleName(objCon.optString("role_name"));
            if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                chatData.setNickname(objCon.optString("nickname"));
            } else {
                chatData.setNickname(objCon.optString("nick_name"));
            }
            String replyMsg = objCon.optString("replyMsg").trim();
            if (TextUtils.isEmpty((CharSequence)replyMsg) || replyMsg.startsWith("[")) {
                Log.i((String)"message", (String)"error replyMsg");
            } else if (replyMsg.startsWith("{")) {
                VssMessageChatData.ReplyMsgBean replyMsgBean = (VssMessageChatData.ReplyMsgBean)JSON.parseObject((String)replyMsg, VssMessageChatData.ReplyMsgBean.class);
                chatData.setReplyMsg(replyMsgBean);
            }
            JSONArray atListArray = objCon.optJSONArray("atList");
            if (atListArray != null && atListArray.length() > 0) {
                atList = JSON.parseArray((String)atListArray.toString(), ResponseChatInfo.ContextBean.AtListBean.class);
                chatData.setAtlist(atList);
            }
        }
        chatData.setImage_urls(urls);
        chatData.setTime(System.currentTimeMillis() + "");
        chatData.setType(type);
        String textContent = text;
        if (atList.size() > 0) {
            for (ResponseChatInfo.ContextBean.AtListBean bean : atList) {
                textContent = textContent.replace("***" + bean.getNickName(), "@" + bean.getNickName());
            }
        }
        chatData.setText_content(textContent);
        chatData.setUserId(AccountManager.getInstance().getUserId());
        chatData.setMy(true);
        chatData.setMsg_id("");
        return chatData;
    }

    private void sendQaAn(String msg) {
        if (!VssRoomManager.enter) {
            VHToast.showShortToast(R.string.chat_please_init_room_info);
            return;
        }
        VssRoomManager.getInstance().sendQuestionAnswer(msg, this.qaIsShow, new CallBack(){

            public void onSuccess(Object result) {
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    @Override
    public void showKeyboard() {
        this.tv_send.setVisibility(0);
        KeyboardManager.showKeyboard(this.etChat, (Activity)this.context);
    }

    @Override
    public void hintKeyboard() {
        KeyboardManager.hintKeyboard((View)this.etChat, (Context)((Activity)this.context));
    }

    @Override
    public void setChatAble(boolean chatAble, String hintContent) {
        this.chatAble = chatAble;
        this.hintContent = hintContent;
        if (!TextUtils.isEmpty((CharSequence)hintContent)) {
            this.etChat.setHint((CharSequence)hintContent);
        } else {
            this.etChat.setHint((CharSequence)this.context.getString(R.string.input_content_to_send));
        }
    }

    @Override
    public boolean isChatControlVisible() {
        return this.isShown();
    }

    @Override
    public void setSendMessage(String msg) {
        if (msg != null) {
            this.etChat.setText((CharSequence)msg);
            this.etChat.setSelection(msg.length());
        }
    }

    @Override
    public void unSubscribe() {
        super.unSubscribe();
        if (this.heightProvider != null) {
            this.heightProvider.destroyed();
        }
    }

    @Override
    public void setInputListener(IInputListener inputListener) {
        if (inputListener != null) {
            this.mInputListener = inputListener;
        }
    }

    public void setSendMsgCallBack(SendMsgCallBack sendMsgCallBack) {
        this.sendMsgCallBack = sendMsgCallBack;
    }

    public static interface SendMsgCallBack {
        public void addChatMsg(VssMessageChatData var1);
    }

    public class EmojiPagerAdapter
    extends PagerAdapter {
        private List<View> views;

        public EmojiPagerAdapter(List<View> views) {
            this.views = views;
        }

        public int getCount() {
            return this.views.size();
        }

        public boolean isViewFromObject(View arg0, Object arg1) {
            return arg0 == arg1;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            container.addView(this.views.get(position));
            return this.views.get(position);
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView(this.views.get(position));
        }
    }
}

