/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.IBaseViewImpl;
import com.vhall.appui.baselib.base.IDevice;
import com.vhall.appui.baselib.network.bean.InteractiveListResponseBean;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.appui.baselib.utils.DrawableUtils;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.utils.UserUtils;
import com.vhall.appui.baselib.vss.data.EnumRoleName;
import com.vhall.vhallrtc.client.Stream;
import com.vhall.vhallrtc.client.VHRenderView;
import org.webrtc.SurfaceViewRenderer;

public class CellStreamWidget
extends IBaseViewImpl {
    private TextView header_icon;
    private ImageView host;
    private TextView role_name;
    private TextView nick_name;
    private VHRenderView render_view;
    private ImageView audio_off;
    private ImageView camera_off;
    private String mUserId;
    private Stream mStream;
    InteractiveListResponseBean mInteractiveListResponseBean;

    public void setData(Stream stream) {
        if (stream == null) {
            return;
        }
        try {
            this.mUserId = stream.userId;
            this.mStream = stream;
            stream.removeAllRenderView();
            stream.addRenderView(this.render_view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CellStreamWidget(Context context) {
        super(context);
    }

    public CellStreamWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void init() {
        super.init();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.cell_layout, (ViewGroup)this);
        this.header_icon = (TextView)this.findViewById(R.id.header_icon);
        this.host = (ImageView)this.findViewById(R.id.host);
        this.role_name = (TextView)this.findViewById(R.id.role_name);
        this.nick_name = (TextView)this.findViewById(R.id.nick_name);
        this.render_view = (VHRenderView)this.findViewById(R.id.render_view);
        this.camera_off = (ImageView)this.findViewById(R.id.camera_off);
        this.audio_off = (ImageView)this.findViewById(R.id.audio_off);
        this.render_view.getHolder().setFormat(-2);
        this.render_view.setZOrderMediaOverlay(true);
        this.render_view.init(null, null);
        this.render_view.setScalingMode(SurfaceViewRenderer.VHRenderViewScalingMode.kVHRenderViewScalingModeAspectFill);
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void refreshCell(InteractiveListResponseBean interactiveListResponseBean) {
        this.mInteractiveListResponseBean = interactiveListResponseBean;
        InternalUtils.setMaxLength(4, this.nick_name, interactiveListResponseBean.getNick_name());
        this.role_name.setText((CharSequence)InternalUtils.getRoleNameStr(interactiveListResponseBean.getRole_name()));
        EnumRoleName role = EnumRoleName.getRole(interactiveListResponseBean.getRole_name());
        this.role_name.setBackground(DrawableUtils.getDrawable(InternalUtils.getColorStr(role), InternalUtils.getColorStr(role), 0, DensityUtils.dpToPxInt(8.0f)));
        if (role == EnumRoleName.viewer) {
            this.role_name.setVisibility(8);
        }
        this.audio_off.setVisibility(InternalUtils.convertBoolean(interactiveListResponseBean.getAudio()) ? 8 : 0);
        this.camera_off.setVisibility(InternalUtils.convertBoolean(interactiveListResponseBean.getVideo()) ? 8 : 0);
        this.header_icon.setVisibility(InternalUtils.convertBoolean(interactiveListResponseBean.getVideo()) ? 8 : 0);
        this.host.setVisibility(InternalUtils.convertBoolean(interactiveListResponseBean.getIs_main_screen()) ? 0 : 8);
        if (!InternalUtils.convertBoolean(interactiveListResponseBean.getVideo())) {
            UserUtils.setAvatar(this.header_icon, this.mUserId, interactiveListResponseBean.getNick_name());
        }
    }

    public void setDeviceStatus(IDevice.Device device, boolean open, String userId) {
        if (this.mInteractiveListResponseBean == null) {
            return;
        }
        if (TextUtils.equals((CharSequence)userId, (CharSequence)this.mUserId)) {
            if (device == IDevice.Device.Audio) {
                this.mInteractiveListResponseBean.setAudio(InternalUtils.booleanConvertToIntStr(open));
            } else {
                this.mInteractiveListResponseBean.setVideo(InternalUtils.booleanConvertToIntStr(open));
            }
            this.refreshCell(this.mInteractiveListResponseBean);
        }
    }

    public void release() {
        if (this.render_view != null) {
            InternalUtils.releaseVHRenderView(this.render_view);
        }
    }
}

