/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.webview;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.BaseActivity;
import com.vhall.appui.baselib.service.vote.VoteManager;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.utils.LogUtils;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.module.room.ProxyVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import com.vhall.appui.baselib.vss.utils.handler.WeakHandler;
import com.vhall.appui.baselib.webview.VHJsBridge;
import com.vhall.appui.baselib.webview.VhallWebManager;
import org.json.JSONException;
import org.json.JSONObject;

public class VhallWebviewActivity
extends BaseActivity {
    private WebView webview;
    private ProgressBar loading_progress;
    private IVssMessageListener mListener;
    private String url;
    private VHJsBridge mBridge = new VHJsBridge(){

        @Override
        void jsCallAppInUI(String action, String extra) {
            VhallWebviewActivity.this.processJsMethod(action, extra);
        }

        @Override
        void jsCallAppInUI(String action) {
            VhallWebviewActivity.this.processJsMethod(action, "");
        }
    };
    private WebViewClient webViewClient = new WebViewClient(){

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return super.shouldOverrideUrlLoading(view, request);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            view.loadUrl(url);
            return true;
        }
    };
    private WebChromeClient webChromeClient = new WebChromeClient(){

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            VhallWebviewActivity.this.loading_progress.setVisibility(newProgress < 100 ? 0 : 8);
            VhallWebviewActivity.this.loading_progress.setProgress(newProgress);
        }
    };

    @Override
    protected int getLayoutId() {
        return R.layout.common_vhall_webview_activity_layout;
    }

    public static void startActivity(Context context, Bundle bundle) {
        InternalUtils.launchActivity(context, bundle, VhallWebviewActivity.class);
    }

    @Override
    protected boolean hintBar() {
        return true;
    }

    @Override
    protected void initView() {
        this.webview = (WebView)this.findViewById(R.id.webview);
        this.loading_progress = (ProgressBar)this.findViewById(R.id.loading_progress);
    }

    @Override
    protected void initData() {
        WebSettings webSettings = this.webview.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setDisplayZoomControls(false);
        webSettings.setAllowFileAccess(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setUseWideViewPort(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setCacheMode(2);
        webSettings.setGeolocationEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        this.webview.setWebViewClient(this.webViewClient);
        this.webview.addJavascriptInterface((Object)this.mBridge, "messageHandlers");
        this.webview.setWebChromeClient(this.webChromeClient);
        this.url = this.getExtraString("load_url");
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            this.webview.loadUrl(this.url);
            LogUtils.e(this.url);
        } else {
            this.finish();
        }
        this.initListener();
        LogUtils.e(this.url);
        VssRoomManager.getInstance().setVssMessageListener(new ProxyVssMessageListener(this.mListener));
        VhallWebManager.getInstance().addUrl(this.url);
    }

    @Override
    protected void onDestroy() {
        if (this.webview != null) {
            this.webview.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            this.webview.clearHistory();
            ((ViewGroup)this.webview.getParent()).removeView((View)this.webview);
            this.webview.destroy();
            this.webview = null;
        }
        if (this.mListener != null) {
            VssRoomManager.getInstance().removeVssMessageListener(this.mListener);
        }
        VhallWebManager.getInstance().removeUrl(this.url);
        super.onDestroy();
    }

    public void onBackPressed() {
        if (this.webview.canGoBack()) {
            this.webview.goBack();
        } else {
            super.onBackPressed();
        }
    }

    private void processJsMethod(String action, String extra) {
        if (TextUtils.equals((CharSequence)action, (CharSequence)"close")) {
            this.finish();
        }
    }

    private void initListener() {
        this.mListener = new IVssMessageListener(){

            @Override
            public void onMessage(MessageData msg) {
                switch (msg.getType()) {
                    case "vote_finish": 
                    case "vote_statis": 
                    case "vote_final_statis": {
                        if (!VoteManager.getInstance().isLoaded()) {
                            return;
                        }
                        try {
                            JSONObject vote = new JSONObject(msg.getImMessageInfo().getData());
                            String vote_id = vote.optString("vote_id");
                            if (!(!TextUtils.isEmpty((CharSequence)vote_id) & VhallWebviewActivity.this.url.contains(vote_id))) break;
                            new WeakHandler(Looper.getMainLooper()).post(new Runnable(){

                                @Override
                                public void run() {
                                    VhallWebviewActivity.this.finish();
                                }
                            });
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }

            @Override
            public void onError(int code, String msg) {
            }
        };
    }
}

